/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.inbox;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.PorterDuff;
import android.os.AsyncTask;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.support.design.widget.FloatingActionButton;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ProgressBar;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.actions.Actions;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.inbox.ConversationClickListener;
import io.intercom.android.sdk.inbox.InboxAdapter;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.events.realtime.NewCommentEvent;
import io.intercom.android.sdk.state.InboxState;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.store.Selectors;
import io.intercom.android.sdk.store.Store;
import io.intercom.android.sdk.twig.Twig;
import io.intercom.android.sdk.utilities.Phrase;
import io.intercom.android.sdk.utilities.StoreUtils;
import io.intercom.android.sdk.utilities.TimeFormatter;
import io.intercom.android.sdk.utilities.ViewUtils;
import io.intercom.android.sdk.views.EndlessRecyclerScrollListener;
import io.intercom.android.sdk.views.EndlessScrollListener;
import io.intercom.android.sdk.views.IntercomErrorView;
import io.intercom.android.sdk.views.IntercomToolbar;
import io.intercom.com.squareup.otto.Subscribe;
import java.util.List;

public class InboxFragment
extends Fragment
implements View.OnClickListener,
ConversationClickListener,
EndlessScrollListener,
IntercomToolbar.Listener,
Store.Subscriber<InboxState> {
    private static final String ARG_IS_TWO_PANE = "is_two_pane";
    private static final int FADE_DURATION_MS = 150;
    private IntercomToolbar intercomToolbar;
    private View rootView;
    @VisibleForTesting
    RecyclerView inboxView;
    private IntercomErrorView inboxErrorView;
    private FloatingActionButton composerButton;
    private ProgressBar progressBar;
    private LinearLayoutManager layoutManager;
    private EndlessRecyclerScrollListener endlessRecyclerScrollListener;
    Listener listener;
    private InboxAdapter adapter;
    private Store<State> store;
    private Provider<AppConfig> appConfigProvider;
    private String openConversationId = "";
    private boolean isTwoPane = false;
    @Nullable
    private Store.Subscription subscription;
    private final Twig twig = LumberMill.getLogger();

    public static InboxFragment newInstance(boolean isTwoPane) {
        InboxFragment fragment = new InboxFragment();
        Bundle args = new Bundle();
        args.putBoolean(ARG_IS_TWO_PANE, isTwoPane);
        fragment.setArguments(args);
        return fragment;
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        try {
            this.listener = (Listener)context;
        }
        catch (ClassCastException e) {
            throw new ClassCastException(context + " must implement InboxFragment.Listener");
        }
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Injector injector = Injector.get();
        this.store = injector.getStore();
        this.appConfigProvider = injector.getAppConfigProvider();
        FragmentActivity activity = this.getActivity();
        TimeFormatter timeFormatter = new TimeFormatter((Context)activity, injector.getTimeProvider());
        this.adapter = new InboxAdapter(LayoutInflater.from((Context)activity), this, this.store, timeFormatter, this.appConfigProvider, injector.getUserIdentity());
        this.layoutManager = new LinearLayoutManager((Context)activity);
        this.endlessRecyclerScrollListener = new EndlessRecyclerScrollListener(this.layoutManager, this);
        injector.getBus().register((Object)this);
        Bundle args = this.getArguments();
        if (args != null) {
            this.isTwoPane = args.getBoolean(ARG_IS_TWO_PANE, false);
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.twig.internal("inbox frag", "creating view for fragment");
        if (this.rootView == null) {
            this.rootView = inflater.inflate(R.layout.intercom_fragment_inbox, container, false);
            this.progressBar = (ProgressBar)this.rootView.findViewById(R.id.progress_bar);
            this.inboxView = (RecyclerView)this.rootView.findViewById(R.id.inbox_recycler_view);
            this.inboxView.setLayoutManager((RecyclerView.LayoutManager)this.layoutManager);
            this.inboxView.addOnScrollListener((RecyclerView.OnScrollListener)this.endlessRecyclerScrollListener);
            this.inboxView.setAdapter((RecyclerView.Adapter)this.adapter);
            this.composerButton = (FloatingActionButton)this.rootView.findViewById(R.id.compose_action_button);
            this.composerButton.setOnClickListener((View.OnClickListener)this);
            this.inboxErrorView = (IntercomErrorView)this.rootView.findViewById(R.id.error_layout_inbox);
            this.inboxErrorView.setActionButtonTextColor(this.appConfigProvider.get().getBaseColor());
            this.inboxErrorView.setActionButtonClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    InboxFragment.this.store.dispatch(Actions.fetchInboxRequest());
                }
            });
            this.intercomToolbar = (IntercomToolbar)this.rootView.findViewById(R.id.intercom_toolbar);
            this.intercomToolbar.setListener(this);
            this.intercomToolbar.setSubtitleVisibility(8);
            if (this.isTwoPane) {
                this.intercomToolbar.setCloseButtonVisibility(8);
            }
            AsyncTask.THREAD_POOL_EXECUTOR.execute(new Runnable(){

                @Override
                public void run() {
                    InboxFragment.this.store.dispatch(Actions.fetchInboxRequest());
                }
            });
        } else {
            ViewGroup parent = (ViewGroup)this.rootView.getParent();
            if (parent != null) {
                parent.removeView(this.rootView);
            }
        }
        this.openConversationId = "";
        return this.rootView;
    }

    private boolean isInboundMessageEnabled() {
        return this.appConfigProvider.get().isInboundMessages();
    }

    public void onResume() {
        this.store.dispatch(Actions.inboxOpened());
        if (!this.isTwoPane) {
            this.inboxView.setAlpha(1.0f);
        }
        this.setToolbarTitle();
        this.setColorScheme();
        super.onResume();
    }

    public void onStart() {
        super.onStart();
        this.subscription = this.store.subscribeToChanges(Selectors.INBOX, this);
    }

    public void onStop() {
        StoreUtils.safeUnsubscribe(this.subscription);
        super.onStop();
    }

    private void setToolbarTitle() {
        String appName = this.appConfigProvider.get().getName();
        if (TextUtils.isEmpty((CharSequence)appName)) {
            this.intercomToolbar.setTitle(this.getString(R.string.intercom_chats));
        } else {
            CharSequence title = Phrase.from(this.getContext(), R.string.intercom_chats_with).put("name", appName).format();
            this.intercomToolbar.setTitle(title);
        }
    }

    private void setColorScheme() {
        int baseColor = this.appConfigProvider.get().getBaseColor();
        this.progressBar.getIndeterminateDrawable().setColorFilter(baseColor, PorterDuff.Mode.SRC_IN);
        this.composerButton.setBackgroundTintList(ColorStateList.valueOf((int)baseColor));
        this.listener.setStatusBarColor();
        this.intercomToolbar.setBackgroundColor(baseColor);
    }

    public void onDestroy() {
        Injector.get().getBus().unregister((Object)this);
        super.onDestroy();
    }

    public void onDetach() {
        super.onDetach();
        this.listener = null;
    }

    public void onClick(View view) {
        if (view.getId() == R.id.compose_action_button) {
            if (this.isTwoPane) {
                this.listener.onComposerSelected();
            } else {
                this.fadeOutInbox((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                    public void onAnimationEnd(Animator animation) {
                        InboxFragment.this.listener.onComposerSelected();
                    }
                });
            }
        }
    }

    private void fadeOutInbox(Animator.AnimatorListener listener) {
        this.intercomToolbar.fadeOutTitle(150);
        this.inboxView.animate().alpha(0.0f).setDuration(150L).setListener(listener).start();
    }

    @Override
    public void onConversationClicked(int position) {
        final Conversation conversation = this.store.state().inboxState().conversations().get(position);
        this.openConversationId = conversation.getId();
        if (this.isTwoPane) {
            this.listener.onConversationSelected(conversation);
        } else {
            this.fadeOutInbox((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    InboxFragment.this.listener.onConversationSelected(conversation);
                }
            });
        }
    }

    @Override
    public void onLoadMore() {
        InboxState inboxState = this.store.state().inboxState();
        List<Conversation> conversations = inboxState.conversations();
        if (inboxState.status() == InboxState.Status.LOADING || conversations.isEmpty()) {
            return;
        }
        long lastPartCreatedAt = conversations.get(conversations.size() - 1).getLastPart().getCreatedAt();
        this.store.dispatch(Actions.fetchInboxBeforeDateRequest(lastPartCreatedAt));
    }

    @Override
    public void setOverScrollColour() {
        ViewUtils.setOverScrollColour(this.inboxView, this.appConfigProvider.get().getBaseColor());
    }

    @Override
    public void onCloseClicked() {
        this.listener.onToolbarCloseClicked();
    }

    @Override
    public void onToolbarClicked() {
    }

    @Override
    public void onInboxClicked() {
    }

    @Override
    public void onStateChange(InboxState inboxState) {
        if (!this.isAdded()) {
            return;
        }
        switch (inboxState.status()) {
            case INITIAL: {
                this.displayLoadingView();
                break;
            }
            case LOADING: {
                if (inboxState.conversations().isEmpty()) {
                    this.displayLoadingView();
                    break;
                }
                this.displayInbox();
                break;
            }
            case SUCCESS: {
                if (this.layoutManager.findFirstCompletelyVisibleItemPosition() == 0) {
                    this.layoutManager.scrollToPosition(0);
                }
                if (inboxState.conversations().isEmpty()) {
                    this.displayEmptyView();
                } else {
                    this.displayInbox();
                }
                this.listener.onConversationsLoaded(inboxState.conversations(), inboxState.status());
                break;
            }
            default: {
                this.displayErrorView();
            }
        }
        this.adapter.setInboxState(inboxState);
        this.adapter.notifyDataSetChanged();
        this.endlessRecyclerScrollListener.setMorePagesAvailable(inboxState.hasMorePages());
    }

    private void displayLoadingView() {
        this.inboxErrorView.setVisibility(8);
        this.inboxView.setVisibility(8);
        this.composerButton.setVisibility(8);
        this.progressBar.setVisibility(0);
    }

    private void displayInbox() {
        this.inboxView.setVisibility(0);
        this.showComposerButtonIfEnabled();
        this.inboxErrorView.setVisibility(8);
        this.progressBar.setVisibility(8);
    }

    private void displayEmptyView() {
        this.inboxErrorView.setTitle(R.string.intercom_no_messages);
        CharSequence subtitle = Phrase.from(this.getContext(), R.string.intercom_empty_conversations).put("name", this.appConfigProvider.get().getName()).format();
        this.inboxErrorView.setSubtitle(subtitle);
        this.inboxErrorView.setActionButtonVisibility(8);
        this.inboxErrorView.setVisibility(0);
        this.showComposerButtonIfEnabled();
        this.inboxView.setVisibility(8);
        this.progressBar.setVisibility(8);
    }

    private void showComposerButtonIfEnabled() {
        this.composerButton.setVisibility(this.isInboundMessageEnabled() ? 0 : 8);
    }

    private void displayErrorView() {
        this.inboxErrorView.setTitle(R.string.intercom_inbox_error_state_title);
        this.inboxErrorView.setSubtitle(R.string.intercom_conversation_error_state_subtitle);
        this.inboxErrorView.setActionButtonText(R.string.intercom_tap_to_retry);
        this.inboxErrorView.setActionButtonVisibility(0);
        this.inboxErrorView.setVisibility(0);
        this.inboxView.setVisibility(8);
        this.progressBar.setVisibility(8);
        this.composerButton.setVisibility(8);
    }

    @Subscribe
    public void newComment(NewCommentEvent event) {
        if (!event.getConversationId().equals(this.openConversationId)) {
            this.store.dispatch(Actions.fetchInboxRequest());
        }
    }

    public static interface Listener {
        public void onConversationsLoaded(List<Conversation> var1, InboxState.Status var2);

        public void onConversationSelected(Conversation var1);

        public void onComposerSelected();

        public void setStatusBarColor();

        public void onToolbarCloseClicked();
    }
}

