/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.identity;

import android.content.Context;
import android.content.SharedPreferences;
import android.graphics.Color;
import android.support.annotation.ColorInt;
import android.support.v4.content.ContextCompat;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.models.Config;
import io.intercom.android.sdk.models.events.ConfigUpdateEvent;
import io.intercom.android.sdk.models.events.FirstMessageEvent;
import io.intercom.android.sdk.nexus.NexusConfig;
import io.intercom.android.sdk.utilities.ColorUtils;
import io.intercom.com.squareup.otto.Bus;
import java.util.HashSet;
import java.util.Set;

public class AppConfig {
    private static final String APP_NAME = "app_name";
    private static final String APP_INTERCOM_LINK = "app_intercom_link";
    private static final String APP_FIRST_REQUEST = "app_is_first_request";
    private static final String APP_INBOUND_MESSAGES = "app_inbound_messages";
    private static final String APP_TEAM_BIO = "app_team_bio";
    private static final String APP_PRIMARY_COLOR = "app_primary_color";
    private static final String APP_PRIMARY_DARK_COLOR = "app_primary_dark_color";
    private static final String APP_USER_UPDATE_CACHE_MAX_AGE_MS = "app_user_update_cache_max_age_ms";
    private static final String APP_RATE_LIMIT_PERIOD_MS = "app_rate_limit_period_ms";
    private static final String APP_SOFT_RESET_TIMEOUT_MS = "app_soft_reset_timeout_ms";
    private static final String APP_NEW_SESSION_THRESHOLD_MS = "new_session_threshold_ms";
    private static final String APP_BATCH_USER_UPDATE_PERIOD_MS = "batch_user_update_period_ms";
    private static final String APP_PING_DELAY_MS = "ping_delay_ms";
    private static final String APP_RATE_LIMIT_COUNT = "app_rate_limit_count";
    private static final String APP_AUDIO_ENABLED = "app_audio_enabled";
    private static final String APP_METRICS_ENABLED = "app_metrics_enabled";
    private static final String APP_WALLPAPER = "app_wallpaper";
    private static final String APP_LOCALE = "app_locale";
    private static final String APP_RECEIVED_FROM_SERVER = "app_received_from_server";
    private static final String APP_BACKGROUND_REQUESTS_ENABLED = "app_background_requests_enabled";
    private static final String APP_FEATURES = "features";
    private final SharedPreferences prefs;
    @ColorInt
    private final int defaultColor;
    private NexusConfig realTimeConfig = new NexusConfig();
    private String teamProfileBio = "";
    private String wallpaper = "";
    private String name = "";
    private String locale = "";
    @ColorInt
    private int baseColor;
    @ColorInt
    private int baseColorDark;
    private int rateLimitCount;
    private long rateLimitPeriodMs;
    private long userUpdateCacheMaxAgeMs;
    private long newSessionThresholdMs;
    private long batchUserUpdatePeriodMs;
    private long pingDelayMs;
    private long softResetTimeoutMs;
    private boolean isFirstRequest;
    private boolean inboundMessages;
    private boolean showIntercomLink;
    private boolean metricsEnabled;
    private boolean audioEnabled;
    private boolean receivedFromServer;
    private boolean backgroundRequestsEnabled;
    private Set<String> features = new HashSet<String>();

    public AppConfig(Context context) {
        this.defaultColor = ContextCompat.getColor((Context)context, (int)R.color.intercom_main_blue);
        this.prefs = context.getSharedPreferences("INTERCOM_SDK_PREFS", 0);
        this.name = this.prefs.getString(APP_NAME, "");
        this.baseColor = this.prefs.getInt(APP_PRIMARY_COLOR, this.defaultColor);
        this.baseColorDark = this.prefs.getInt(APP_PRIMARY_DARK_COLOR, ColorUtils.darkenColor(this.defaultColor));
        this.showIntercomLink = this.prefs.getBoolean(APP_INTERCOM_LINK, true);
        this.isFirstRequest = this.prefs.getBoolean(APP_FIRST_REQUEST, false);
        this.inboundMessages = this.prefs.getBoolean(APP_INBOUND_MESSAGES, false);
        this.rateLimitCount = this.prefs.getInt(APP_RATE_LIMIT_COUNT, 100);
        this.rateLimitPeriodMs = this.prefs.getLong(APP_RATE_LIMIT_PERIOD_MS, Config.DEFAULT_RATE_LIMIT_PERIOD_MS);
        this.userUpdateCacheMaxAgeMs = this.prefs.getLong(APP_USER_UPDATE_CACHE_MAX_AGE_MS, Config.DEFAULT_CACHE_MAX_AGE_MS);
        this.newSessionThresholdMs = this.prefs.getLong(APP_NEW_SESSION_THRESHOLD_MS, Config.DEFAULT_SESSION_TIMEOUT_MS);
        this.softResetTimeoutMs = this.prefs.getLong(APP_SOFT_RESET_TIMEOUT_MS, Config.DEFAULT_SOFT_RESET_TIMEOUT_MS);
        this.batchUserUpdatePeriodMs = this.prefs.getLong(APP_BATCH_USER_UPDATE_PERIOD_MS, Config.DEFAULT_BATCH_USER_UPDATE_PERIOD_MS);
        this.pingDelayMs = this.prefs.getLong(APP_PING_DELAY_MS, Config.DEFAULT_PING_DELAY_MS);
        this.metricsEnabled = this.prefs.getBoolean(APP_METRICS_ENABLED, true);
        this.audioEnabled = this.prefs.getBoolean(APP_AUDIO_ENABLED, true);
        this.teamProfileBio = this.prefs.getString(APP_TEAM_BIO, "");
        this.wallpaper = this.prefs.getString(APP_WALLPAPER, "");
        this.locale = this.prefs.getString(APP_LOCALE, "");
        this.receivedFromServer = this.prefs.getBoolean(APP_RECEIVED_FROM_SERVER, false);
        this.backgroundRequestsEnabled = this.prefs.getBoolean(APP_BACKGROUND_REQUESTS_ENABLED, true);
        this.features = this.prefs.getStringSet(APP_FEATURES, new HashSet());
    }

    public void update(Config config, Bus bus) {
        if (config == Config.NULL) {
            return;
        }
        this.realTimeConfig = config.getRealTimeConfig();
        this.receivedFromServer = true;
        if (this.isNewConfig(config)) {
            this.name = config.getName();
            this.teamProfileBio = config.getWelcomeMessage();
            this.wallpaper = config.getMessengerBackground();
            this.baseColor = this.getConfigColor(config);
            this.baseColorDark = ColorUtils.darkenColor(this.baseColor);
            this.isFirstRequest = config.isFirstRequest();
            this.inboundMessages = config.isInboundMessages();
            this.showIntercomLink = config.isShowPoweredBy();
            this.audioEnabled = config.isAudioEnabled();
            this.metricsEnabled = config.isMetricsEnabled();
            this.userUpdateCacheMaxAgeMs = config.getUserUpdateCacheMaxAge();
            this.rateLimitPeriodMs = config.getRateLimitPeriod();
            this.rateLimitCount = config.getRateLimitCount();
            this.newSessionThresholdMs = config.getNewSessionThreshold();
            this.softResetTimeoutMs = config.getSoftResetTimeout();
            this.batchUserUpdatePeriodMs = config.getBatchUserUpdatePeriod();
            this.pingDelayMs = config.getPingDelayMs();
            this.backgroundRequestsEnabled = config.isBackgroundRequestsEnabled();
            this.locale = config.getLocale();
            this.features = config.getFeatures();
            this.prefs.edit().putString(APP_NAME, this.name).putString(APP_TEAM_BIO, this.teamProfileBio).putString(APP_WALLPAPER, this.wallpaper).putString(APP_LOCALE, this.locale).putInt(APP_PRIMARY_COLOR, this.baseColor).putInt(APP_PRIMARY_DARK_COLOR, this.baseColorDark).putInt(APP_RATE_LIMIT_COUNT, this.rateLimitCount).putLong(APP_USER_UPDATE_CACHE_MAX_AGE_MS, this.userUpdateCacheMaxAgeMs).putLong(APP_RATE_LIMIT_PERIOD_MS, this.rateLimitPeriodMs).putLong(APP_NEW_SESSION_THRESHOLD_MS, this.newSessionThresholdMs).putLong(APP_BATCH_USER_UPDATE_PERIOD_MS, this.batchUserUpdatePeriodMs).putLong(APP_PING_DELAY_MS, this.pingDelayMs).putLong(APP_SOFT_RESET_TIMEOUT_MS, this.softResetTimeoutMs).putBoolean(APP_INTERCOM_LINK, this.showIntercomLink).putBoolean(APP_FIRST_REQUEST, this.isFirstRequest).putBoolean(APP_INBOUND_MESSAGES, this.inboundMessages).putBoolean(APP_AUDIO_ENABLED, this.audioEnabled).putBoolean(APP_METRICS_ENABLED, this.metricsEnabled).putBoolean(APP_RECEIVED_FROM_SERVER, true).putBoolean(APP_BACKGROUND_REQUESTS_ENABLED, this.backgroundRequestsEnabled).putStringSet(APP_FEATURES, this.features).apply();
            if (this.isFirstRequest) {
                bus.post((Object)new FirstMessageEvent());
            }
            bus.post((Object)new ConfigUpdateEvent());
        }
    }

    private int getConfigColor(Config config) {
        if ("default".equals(config.getBaseColor())) {
            return this.defaultColor;
        }
        return Color.parseColor((String)config.getBaseColor());
    }

    public String getName() {
        return this.name;
    }

    public String getTeamProfileBio() {
        return this.teamProfileBio;
    }

    public String getWallpaper() {
        return this.wallpaper;
    }

    @ColorInt
    public int getBaseColor() {
        return this.baseColor;
    }

    @ColorInt
    public int getBaseColorDark() {
        return this.baseColorDark;
    }

    public boolean shouldShowIntercomLink() {
        return this.showIntercomLink;
    }

    public boolean isInboundMessages() {
        return this.inboundMessages;
    }

    public boolean isFirstRequest() {
        return this.isFirstRequest;
    }

    public int getRateLimitCount() {
        return this.rateLimitCount;
    }

    public long getUserUpdateCacheMaxAgeMs() {
        return this.userUpdateCacheMaxAgeMs;
    }

    public long getRateLimitPeriodMs() {
        return this.rateLimitPeriodMs;
    }

    public long getNewSessionThresholdMs() {
        return this.newSessionThresholdMs;
    }

    public long getSoftResetTimeoutMs() {
        return this.softResetTimeoutMs;
    }

    public long getBatchUserUpdatePeriodMs() {
        return this.batchUserUpdatePeriodMs;
    }

    public long getPingDelayMs() {
        return this.pingDelayMs;
    }

    public NexusConfig getRealTimeConfig() {
        return this.realTimeConfig;
    }

    public boolean isAudioEnabled() {
        return this.audioEnabled;
    }

    public boolean isMetricsEnabled() {
        return this.metricsEnabled;
    }

    public String getLocale() {
        return this.locale;
    }

    public boolean isReceivedFromServer() {
        return this.receivedFromServer;
    }

    public void resetRealTimeConfig() {
        this.realTimeConfig = new NexusConfig();
    }

    public boolean backgroundRequestsDisabled() {
        return !this.backgroundRequestsEnabled;
    }

    public boolean hasFeature(String feature) {
        return this.features.contains(feature);
    }

    private boolean isNewConfig(Config config) {
        return !config.getWelcomeMessage().equals(this.teamProfileBio) || !config.getMessengerBackground().equals(this.wallpaper) || !config.getName().equals(this.name) || !config.getLocale().equals(this.locale) || this.getConfigColor(config) != this.baseColor || config.getUserUpdateCacheMaxAge() != this.userUpdateCacheMaxAgeMs || config.isMetricsEnabled() != this.metricsEnabled || config.isAudioEnabled() != this.audioEnabled || config.isShowPoweredBy() != this.showIntercomLink || config.isInboundMessages() != this.inboundMessages || config.isFirstRequest() != this.isFirstRequest || config.getRateLimitCount() != this.rateLimitCount || config.getRateLimitPeriod() != this.rateLimitPeriodMs || config.getNewSessionThreshold() != this.newSessionThresholdMs || config.getSoftResetTimeout() != this.softResetTimeoutMs || config.getBatchUserUpdatePeriod() != this.batchUserUpdatePeriodMs || config.getPingDelayMs() != this.pingDelayMs || config.isBackgroundRequestsEnabled() != this.backgroundRequestsEnabled || !config.getFeatures().equals(this.features);
    }
}

