/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.views;

import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import io.intercom.android.sdk.views.EndlessScrollListener;

public class EndlessRecyclerScrollListener
extends RecyclerView.OnScrollListener {
    private final LinearLayoutManager layoutManager;
    private final int offset;
    final EndlessScrollListener endlessScrollListener;
    private boolean morePagesAvailable = true;

    public EndlessRecyclerScrollListener(LinearLayoutManager layoutManager, EndlessScrollListener endlessScrollListener) {
        this(layoutManager, 0, endlessScrollListener);
    }

    public EndlessRecyclerScrollListener(LinearLayoutManager layoutManager, int offset, EndlessScrollListener endlessScrollListener) {
        this.layoutManager = layoutManager;
        this.offset = offset;
        this.endlessScrollListener = endlessScrollListener;
    }

    public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
        super.onScrolled(recyclerView, dx, dy);
        int visibleItemCount = recyclerView.getChildCount();
        int totalItemCount = this.layoutManager.getItemCount();
        int firstVisibleItem = this.layoutManager.findFirstVisibleItemPosition();
        if (totalItemCount - visibleItemCount <= firstVisibleItem + this.offset && this.morePagesAvailable) {
            recyclerView.post(new Runnable(){

                @Override
                public void run() {
                    EndlessRecyclerScrollListener.this.endlessScrollListener.onLoadMore();
                }
            });
        }
    }

    public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
        super.onScrollStateChanged(recyclerView, newState);
        this.endlessScrollListener.setOverScrollColour();
    }

    public void setMorePagesAvailable(boolean morePagesAvailable) {
        this.morePagesAvailable = morePagesAvailable;
    }
}

