/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.middleware;

import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.actions.Action;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.store.Selectors;
import io.intercom.android.sdk.store.Store;

public class ApiMiddleware
implements Store.Middleware<State> {
    private final Provider<Api> apiProvider;

    public ApiMiddleware(Provider<Api> apiProvider) {
        this.apiProvider = apiProvider;
    }

    @Override
    public void dispatch(Store<State> store, Action<?> action, Store.NextDispatcher next) {
        next.dispatch(action);
        switch (action.type()) {
            case CONVERSATION_MARKED_AS_DISMISSED: {
                Conversation conversation = (Conversation)action.value();
                this.apiProvider.get().markConversationAsDismissed(conversation.getId());
                break;
            }
            case CONVERSATION_MARKED_AS_READ: {
                int inAppConversationCount = store.select(Selectors.OVERLAY).conversations().size();
                if (inAppConversationCount != 1 || store.select(Selectors.UNREAD_COUNT) <= inAppConversationCount) break;
                this.apiProvider.get().getUnreadConversations();
                break;
            }
            case FETCH_INBOX_REQUEST: {
                this.apiProvider.get().getInbox();
                break;
            }
            case FETCH_INBOX_BEFORE_DATE_REQUEST: {
                this.apiProvider.get().getInboxBefore((Long)action.value());
                break;
            }
            case CREATE_CONVERSATION_EVENT_RECEIVED: {
                this.apiProvider.get().getInbox();
                if (store.select(Selectors.OVERLAY).resumedHostActivity() == null) break;
                this.apiProvider.get().getUnreadConversations();
                break;
            }
        }
    }
}

