/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.conversation;

import android.annotation.SuppressLint;
import android.content.Context;
import android.support.annotation.VisibleForTesting;
import android.view.View;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.intercom.input.gallery.GalleryImage;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.blocks.models.Block;
import io.intercom.android.sdk.conversation.ConversationContentPresenter;
import io.intercom.android.sdk.conversation.events.AdminIsTypingEvent;
import io.intercom.android.sdk.conversation.events.AdminTypingEndedEvent;
import io.intercom.android.sdk.identity.AppIdentity;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.models.events.ConversationEvent;
import io.intercom.android.sdk.models.events.NewConversationEvent;
import io.intercom.android.sdk.models.events.ReplyEvent;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

class WebViewConversationContentPresenter
implements ConversationContentPresenter {
    private static final String WEB_PAGE_URL = "https://js.intercomcdn.com/mobile.html";
    private final WebView webView;
    private final View container;
    private final AppIdentity appIdentity;
    private final UserIdentity userIdentity;
    private final Collection<Runnable> actionsAfterLoad = new LinkedList<Runnable>();
    private boolean hasLoaded = false;

    WebViewConversationContentPresenter(WebView webView, View container, AppIdentity appIdentity, UserIdentity userIdentity) {
        this.webView = webView;
        this.container = container;
        this.appIdentity = appIdentity;
        this.userIdentity = userIdentity;
    }

    @Override
    @SuppressLint(value={"SetJavaScriptEnabled"})
    public void setup() {
        this.container.setVisibility(0);
        this.webView.getSettings().setJavaScriptEnabled(true);
        this.webView.loadUrl(WEB_PAGE_URL);
        this.webView.setWebViewClient(new WebViewClient(){

            public void onPageFinished(WebView view, String url) {
                WebViewConversationContentPresenter.this.hasLoaded = true;
                for (Runnable action : WebViewConversationContentPresenter.this.actionsAfterLoad) {
                    action.run();
                }
            }
        });
        this.webView.setBackgroundResource(R.color.intercom_full_transparent_full_white);
    }

    @Override
    public void smoothScrollToTop() {
        this.scrollToTop();
    }

    @Override
    public void scrollToTop() {
        this.webView.scrollTo(0, 0);
    }

    @Override
    public void scrollToBottom() {
        this.webView.scrollTo(0, this.webView.getContentHeight());
    }

    @Override
    public boolean isAtBottom() {
        return this.webView.getScrollY() + this.webView.getHeight() >= this.webView.getContentHeight();
    }

    @Override
    public void onProfileScrolled() {
    }

    @Override
    public void onGlobalLayout() {
    }

    @Override
    public void onNewPartReceived() {
    }

    @Override
    public void showErrorView() {
    }

    @Override
    public void showLoadingView() {
    }

    @Override
    public void showContentView() {
    }

    @Override
    public void onAdminStartedTyping(AdminIsTypingEvent event, Context context) {
    }

    @Override
    public void onAdminStoppedTyping(AdminTypingEndedEvent event) {
    }

    @Override
    public void fetchConversation(String conversationId) {
        this.executeJavascript("renderConversation('" + this.appIdentity.getAppId() + "', '" + conversationId + "', '" + this.getUserIdForConversation() + "')");
    }

    @VisibleForTesting
    String getUserIdForConversation() {
        String userId = this.userIdentity.getUserId();
        if (!userId.isEmpty()) {
            return userId;
        }
        String email = this.userIdentity.getEmail();
        if (!email.isEmpty()) {
            return email;
        }
        return this.userIdentity.getAnonymousId();
    }

    private void executeJavascript(final String script) {
        if (this.hasLoaded) {
            this.webView.loadUrl("javascript:" + script);
        } else {
            this.actionsAfterLoad.add(new Runnable(){

                @Override
                public void run() {
                    WebViewConversationContentPresenter.this.webView.loadUrl("javascript:" + script);
                }
            });
        }
    }

    @Override
    public void onPartClicked(Part part) {
    }

    @Override
    public void sendPart(List<Block.Builder> blockBuilders, Part part) {
    }

    @Override
    public Part addSendingPart(List<Block> blocks) {
        return new Part();
    }

    @Override
    public void uploadImage(List<Block> blocks, GalleryImage galleryImage) {
    }

    @Override
    public void onNewConversation(NewConversationEvent event) {
    }

    @Override
    public void onReplyDelivered(ReplyEvent event) {
    }

    @Override
    public void onConversationFetched(ConversationEvent event) {
    }

    @Override
    public void cleanup() {
    }
}

