/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.activities;

import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.conversation.ReactionListener;
import io.intercom.android.sdk.metrics.MetricFactory;
import io.intercom.android.sdk.metrics.MetricsStore;
import io.intercom.android.sdk.models.Reaction;

public class ConversationReactionListener
implements ReactionListener {
    private final String conversationId;
    private final String partId;
    private final MetricFactory.ReactionLocation location;
    private final Api api;
    private final MetricsStore metricStore;
    private final MetricFactory metricFactory;

    public ConversationReactionListener(MetricFactory.ReactionLocation location, String partId, String conversationId, Api api, MetricsStore metricStore, MetricFactory metricFactory) {
        this.conversationId = conversationId;
        this.partId = partId;
        this.location = location;
        this.api = api;
        this.metricStore = metricStore;
        this.metricFactory = metricFactory;
    }

    @Override
    public void onReactionSelected(Reaction reaction) {
        this.api.reactToConversation(this.conversationId, reaction.getIndex());
        this.metricStore.track(this.metricFactory.sentReaction(this.conversationId, this.partId, reaction.getIndex(), this.location));
    }
}

