/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.store;

import io.intercom.android.sdk.actions.Action;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.ConversationsResponse;
import io.intercom.android.sdk.state.InboxState;
import io.intercom.android.sdk.state.ReplyPart;
import io.intercom.android.sdk.store.Store;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;

class InboxStateReducer
implements Store.Reducer<InboxState> {
    static final InboxState INITIAL_STATE = new InboxState(new ArrayList<Conversation>(), InboxState.Status.INITIAL, true);

    InboxStateReducer() {
    }

    @Override
    public InboxState reduce(Action<?> action, InboxState currentState) {
        switch (action.type()) {
            case FETCH_INBOX_REQUEST: 
            case FETCH_INBOX_BEFORE_DATE_REQUEST: {
                if (currentState.status() == InboxState.Status.LOADING) {
                    return currentState;
                }
                return new InboxState(currentState.conversations(), InboxState.Status.LOADING, currentState.hasMorePages());
            }
            case FETCH_INBOX_SUCCESS: {
                ConversationsResponse response = (ConversationsResponse)action.value();
                List<Conversation> newList = response.getConversationPage().getConversations();
                List<Conversation> mergedConversations = this.mergeConversationLists(currentState.conversations(), newList);
                return new InboxState(mergedConversations, InboxState.Status.SUCCESS, response.getConversationPage().hasMorePages());
            }
            case FETCH_INBOX_FAILED: {
                return new InboxState(currentState.conversations(), InboxState.Status.FAILED, currentState.hasMorePages());
            }
            case CONVERSATION_MARKED_AS_READ: {
                ArrayList<Conversation> conversations = new ArrayList<Conversation>(currentState.conversations());
                String conversationId = (String)action.value();
                this.markConversationAsRead(conversationId, conversations);
                return new InboxState(conversations, InboxState.Status.SUCCESS, currentState.hasMorePages());
            }
            case CONVERSATION_REPLY_SUCCESS: {
                ArrayList<Conversation> conversations = new ArrayList<Conversation>(currentState.conversations());
                this.updateRepliedConversationAndMoveToTop((ReplyPart)action.value(), conversations);
                return new InboxState(conversations, InboxState.Status.SUCCESS, currentState.hasMorePages());
            }
            case FETCH_CONVERSATION_SUCCESS: {
                ArrayList<Conversation> conversations = new ArrayList<Conversation>(currentState.conversations());
                this.updateConversation((Conversation)action.value(), conversations);
                return new InboxState(conversations, InboxState.Status.SUCCESS, currentState.hasMorePages());
            }
            case NEW_CONVERSATION_SUCCESS: {
                ArrayList<Conversation> conversations = new ArrayList<Conversation>(currentState.conversations());
                this.addConversationAtTop(conversations, (Conversation)action.value());
                return new InboxState(conversations, InboxState.Status.SUCCESS, currentState.hasMorePages());
            }
            case SOFT_RESET: 
            case HARD_RESET: {
                return INITIAL_STATE;
            }
        }
        return currentState;
    }

    private List<Conversation> mergeConversationLists(List<Conversation> oldList, List<Conversation> newList) {
        ArrayList<Conversation> mergedList = new ArrayList<Conversation>(oldList.size() + newList.size());
        HashSet<String> fetchedIds = new HashSet<String>(newList.size());
        for (Conversation conversation : newList) {
            fetchedIds.add(conversation.getId());
            mergedList.add(conversation);
        }
        for (Conversation conversation : oldList) {
            if (fetchedIds.contains(conversation.getId())) continue;
            mergedList.add(conversation);
        }
        Collections.sort(mergedList, new Comparator<Conversation>(){

            @Override
            public int compare(Conversation lhs, Conversation rhs) {
                return (int)(rhs.getLastPart().getCreatedAt() - lhs.getLastPart().getCreatedAt());
            }
        });
        return mergedList;
    }

    private void markConversationAsRead(String conversationId, List<Conversation> conversations) {
        int size = conversations.size();
        for (int i = 0; i < size; ++i) {
            Conversation conversation = conversations.get(i);
            if (!conversationId.equals(conversation.getId())) continue;
            conversations.set(i, conversation.withRead(true));
        }
    }

    private void updateRepliedConversationAndMoveToTop(ReplyPart reply, List<Conversation> result) {
        for (int i = 0; i < result.size(); ++i) {
            Conversation conversation = result.get(i);
            if (!reply.getConversationId().equals(conversation.getId())) continue;
            conversation.getParts().add(reply.getPart());
            result.remove(conversation);
            this.addConversationAtTop(result, conversation);
        }
    }

    private void updateConversation(Conversation updatedConversation, List<Conversation> conversations) {
        for (int i = 0; i < conversations.size(); ++i) {
            Conversation conversation = conversations.get(i);
            if (!updatedConversation.getId().equals(conversation.getId())) continue;
            conversations.set(i, updatedConversation);
        }
    }

    private void addConversationAtTop(List<Conversation> conversations, Conversation value) {
        conversations.add(0, value);
    }
}

