/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.conversation.composer.textinput;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.StringRes;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.widget.EditText;
import com.intercom.composer.input.IconProvider;
import com.intercom.composer.input.Input;
import com.intercom.composer.input.text.SendTextCallback;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.conversation.composer.ComposerManager;
import io.intercom.android.sdk.conversation.composer.InputDrawableManager;
import io.intercom.android.sdk.conversation.composer.textinput.MessengerTextInput;
import io.intercom.android.sdk.conversation.composer.textinput.TextInputWatcher;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.metrics.MetricFactory;
import io.intercom.android.sdk.metrics.MetricsComposerTextWatcher;
import io.intercom.android.sdk.metrics.MetricsStore;
import io.intercom.android.sdk.nexus.NexusClient;

public class TextInputManager {
    private final EditText composerText;
    private final TextInputWatcher textWatcher;
    private final MetricsComposerTextWatcher metricsTextWatcher;
    private final Context context;
    private final ComposerManager.Listener listener;
    private final Drawable textIcon;
    private String conversationId;
    private String initialMessage;

    public TextInputManager(Context context, LayoutInflater inflater, UserIdentity userIdentity, NexusClient nexusClient, MetricsStore metricsStore, MetricFactory metricFactory, String conversationId, String initialMessage, InputDrawableManager inputDrawableManager, ComposerManager.Listener listener) {
        this.context = context;
        this.listener = listener;
        this.conversationId = conversationId;
        this.initialMessage = initialMessage;
        this.textIcon = inputDrawableManager.createDrawable(context, R.drawable.intercom_input_text);
        this.composerText = (EditText)inflater.inflate(R.layout.intercom_composer_edit_text, null);
        this.textWatcher = new TextInputWatcher(userIdentity.getIntercomId(), nexusClient, new Handler(Looper.getMainLooper()));
        this.metricsTextWatcher = new MetricsComposerTextWatcher(metricsStore, metricFactory);
        this.metricsTextWatcher.setConversationId(conversationId);
        this.composerText.addTextChangedListener((TextWatcher)this.textWatcher);
        this.composerText.addTextChangedListener((TextWatcher)this.metricsTextWatcher);
    }

    public void setConversationId(String conversationId) {
        this.textWatcher.setConversationId(conversationId);
        this.metricsTextWatcher.setConversationId(conversationId);
    }

    public void setHint(@StringRes int hintRes) {
        this.composerText.setHint(hintRes);
    }

    public void requestFocus() {
        this.composerText.requestFocus();
    }

    public Input createInput() {
        String hint = TextUtils.isEmpty((CharSequence)this.conversationId) ? this.context.getResources().getString(R.string.intercom_start_new_conversation) : this.context.getResources().getString(R.string.intercom_reply_to_conversation);
        return new MessengerTextInput("text_input", new IconProvider(){

            public Drawable getIconDrawable(String inputIdentifier, Context context) {
                return TextInputManager.this.textIcon;
            }
        }, hint, this.initialMessage, new SendTextCallback(){

            public void textToBeSent(Input sourceInput, CharSequence charSequence) {
                TextInputManager.this.listener.onSendButtonPressed(charSequence);
            }
        }, this.composerText);
    }

    public void updateMaxLines() {
        this.composerText.setMaxLines(this.context.getResources().getInteger(R.integer.intercom_max_composer_lines));
    }

    public void cleanup() {
        this.composerText.removeTextChangedListener((TextWatcher)this.textWatcher);
        this.composerText.removeTextChangedListener((TextWatcher)this.metricsTextWatcher);
        this.composerText.clearFocus();
        this.metricsTextWatcher.reset();
    }
}

