/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.conversation;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Configuration;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.support.design.widget.AppBarLayout;
import android.support.design.widget.CoordinatorLayout;
import android.support.design.widget.Snackbar;
import android.support.v4.app.Fragment;
import android.support.v7.app.AlertDialog;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.SimpleItemAnimator;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.intercom.input.gallery.GalleryImage;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.actions.Actions;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.blocks.BlockFactory;
import io.intercom.android.sdk.blocks.BlockType;
import io.intercom.android.sdk.blocks.Blocks;
import io.intercom.android.sdk.blocks.BlocksViewHolder;
import io.intercom.android.sdk.blocks.UploadingImageCache;
import io.intercom.android.sdk.blocks.ViewHolderGenerator;
import io.intercom.android.sdk.blocks.function.TimestampAdder;
import io.intercom.android.sdk.blocks.logic.TextSplittingStrategy;
import io.intercom.android.sdk.blocks.models.Block;
import io.intercom.android.sdk.blocks.models.BlockAttachment;
import io.intercom.android.sdk.commons.utilities.TimeProvider;
import io.intercom.android.sdk.conversation.ConversationPartAdapter;
import io.intercom.android.sdk.conversation.ProfileExpansionLogic;
import io.intercom.android.sdk.conversation.ReactionInputView;
import io.intercom.android.sdk.conversation.SoundPlayer;
import io.intercom.android.sdk.conversation.UploadProgressListener;
import io.intercom.android.sdk.conversation.composer.ComposerManager;
import io.intercom.android.sdk.conversation.events.AdminIsTypingEvent;
import io.intercom.android.sdk.conversation.events.AdminTypingEndedEvent;
import io.intercom.android.sdk.conversation.events.CancelAdminTypingEvent;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.identity.AppIdentity;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.imageloader.WallpaperLoader;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.metrics.MetricFactory;
import io.intercom.android.sdk.metrics.MetricsStore;
import io.intercom.android.sdk.models.Attachments;
import io.intercom.android.sdk.models.Avatar;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.LastParticipatingAdmin;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.models.Participant;
import io.intercom.android.sdk.models.ReactionReply;
import io.intercom.android.sdk.models.TeamPresence;
import io.intercom.android.sdk.models.events.ConversationEvent;
import io.intercom.android.sdk.models.events.NewConversationEvent;
import io.intercom.android.sdk.models.events.ReplyEvent;
import io.intercom.android.sdk.models.events.UploadEvent;
import io.intercom.android.sdk.models.events.failure.ConversationFailedEvent;
import io.intercom.android.sdk.models.events.failure.NewConversationFailedEvent;
import io.intercom.android.sdk.models.events.failure.ReplyFailedEvent;
import io.intercom.android.sdk.models.events.failure.UploadFailedEvent;
import io.intercom.android.sdk.models.events.realtime.NewCommentEvent;
import io.intercom.android.sdk.models.events.realtime.UserContentSeenByAdminEvent;
import io.intercom.android.sdk.nexus.NexusClient;
import io.intercom.android.sdk.nexus.NexusEvent;
import io.intercom.android.sdk.profile.ProfileCoordinator;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.store.Selectors;
import io.intercom.android.sdk.store.Store;
import io.intercom.android.sdk.twig.Twig;
import io.intercom.android.sdk.utilities.BackgroundUtils;
import io.intercom.android.sdk.utilities.NetworkConnectivityListener;
import io.intercom.android.sdk.utilities.NetworkState;
import io.intercom.android.sdk.utilities.Phrase;
import io.intercom.android.sdk.utilities.StoreUtils;
import io.intercom.android.sdk.utilities.TimeFormatter;
import io.intercom.android.sdk.utilities.ViewUtils;
import io.intercom.android.sdk.views.AdminIsTypingView;
import io.intercom.android.sdk.views.IntercomErrorView;
import io.intercom.android.sdk.views.IntercomLinkView;
import io.intercom.android.sdk.views.IntercomToolbar;
import io.intercom.android.sdk.views.decoration.ConversationItemDecoration;
import io.intercom.com.squareup.otto.Bus;
import io.intercom.com.squareup.otto.Subscribe;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class ConversationFragment
extends Fragment
implements ConversationPartAdapter.PartClickedListener,
IntercomToolbar.Listener,
Store.Subscriber<Integer> {
    private static final String ARG_IS_READ = "intercomsdk-isRead";
    private static final String ARG_CONVERSATION_ID = "conversationId";
    private static final String ARG_LAST_PARTICIPANT = "last_participant";
    private static final String ARG_IS_TWO_PANE = "is_two_pane";
    private static final String ARG_INITIAL_MESSAGE = "initial_message";
    private static final String IMAGE_MIME_TYPE = "image";
    private static final int MAX_FILE_SIZE_BYTES = 0x2800000;
    static final long TIMESTAMP_UPDATE_PERIOD = TimeUnit.MINUTES.toMillis(1L);
    private static final long PART_DISPLAY_DELIVERED_TIMEOUT = TimeUnit.MINUTES.toMillis(1L);
    final NetworkConnectivityListener networkConnectivityListener = new NetworkConnectivityListener();
    private final Set<String> currentTypers = new HashSet<String>();
    final List<Part> sendingFailures = new ArrayList<Part>();
    private final TimestampAdder timestampAdder = TimestampAdder.create();
    private final UploadingImageCache uploadingImageCache = new UploadingImageCache();
    private final BlockFactory blockFactory = new BlockFactory(new TextSplittingStrategy());
    private final ProfileExpansionLogic profileExpansionLogic = new ProfileExpansionLogic();
    private Listener listener;
    String conversationId;
    ViewHolderGenerator generator;
    ConversationPartAdapter adapter;
    Blocks blocks;
    List<Part> conversationParts;
    private BlocksViewHolder blocksUserViewHolder;
    private BlocksViewHolder blocksAnnouncementViewHolder;
    private BlocksViewHolder blocksAdminViewHolder;
    private BlocksViewHolder blocksLinkViewHolder;
    View rootView;
    private ReactionInputView reactionComposer;
    RecyclerView conversationList;
    private IntercomErrorView intercomErrorView;
    TextView pill;
    ProfileCoordinator profileCoordinator;
    private LinearLayoutManager layoutManager;
    private WallpaperLoader wallpaperLoader;
    private IntercomToolbar intercomToolbar;
    Conversation conversation;
    private LastParticipatingAdmin lastParticipant;
    SoundPlayer soundPlayer;
    NetworkState networkState;
    private CharSequence lastActiveTime;
    private boolean canOpenProfile = true;
    @Nullable
    private Part markedPart = null;
    @Nullable
    private Part loadingPart = null;
    private Bus bus;
    Api api;
    private NexusClient nexusClient;
    private Store<State> store;
    AppIdentity appIdentity;
    private UserIdentity userIdentity;
    private FrameLayout composerHolder;
    private boolean hasLoadedConversation = false;
    boolean orientationChanged = false;
    private int currentOrientation;
    IntercomLinkView intercomLinkView;
    private boolean shouldShowIntercomLink = false;
    private boolean wasAtBottom = false;
    boolean shouldStayAtBottom = false;
    private ViewTreeObserver.OnGlobalLayoutListener globalLayoutListener;
    private String initialMessage = "";
    private boolean isTwoPane = false;
    private MetricFactory metricFactory;
    private MetricsStore metricStore;
    private Store.Subscription subscription;
    private Runnable replyDeliveredUpdater;
    private ComposerManager composerManager;
    private final Twig twig = LumberMill.getLogger();
    private final Handler connectivityMonitor = new Handler(new Handler.Callback(){

        public boolean handleMessage(Message msg) {
            if (ConversationFragment.this.networkState != ConversationFragment.this.networkConnectivityListener.getState()) {
                if (ConversationFragment.this.networkConnectivityListener.getState() == NetworkState.NOT_CONNECTED) {
                    Snackbar.make((View)ConversationFragment.this.rootView, (int)R.string.intercom_no_network_connection, (int)-2).show();
                } else if (ConversationFragment.this.networkConnectivityListener.getState() == NetworkState.CONNECTED && ConversationFragment.this.networkState == NetworkState.NOT_CONNECTED) {
                    Snackbar.make((View)ConversationFragment.this.rootView, (int)R.string.intercom_connected, (int)0).setActionTextColor(ConversationFragment.this.appIdentity.getAppConfig().getBaseColor()).setAction(R.string.intercom_dismiss, new View.OnClickListener(){

                        public void onClick(View v) {
                        }
                    }).show();
                }
                ConversationFragment.this.networkState = ConversationFragment.this.networkConnectivityListener.getState();
            }
            return false;
        }
    });
    final Runnable timestampUpdater = new Runnable(){

        @Override
        public void run() {
            ConversationFragment.this.adapter.notifyDataSetChanged();
            ConversationFragment.this.postOnView(ConversationFragment.this.timestampUpdater, TIMESTAMP_UPDATE_PERIOD);
        }
    };
    private final ComposerManager.Listener composerListener = new ComposerManager.Listener(){

        @Override
        public void onSendButtonPressed(CharSequence text) {
            ConversationFragment.this.sendTapped(text.toString().trim());
        }

        @Override
        public void onUploadImageSelected(GalleryImage galleryImage) {
            if (galleryImage.getFileSize() > 0x2800000) {
                ConversationFragment.this.showUploadError();
            } else {
                Part uploadingPart = ConversationFragment.this.createUploadingPart(galleryImage);
                ConversationFragment.this.soundPlayer.playReplySentSound();
                ConversationFragment.this.api.uploadFile(galleryImage, ConversationFragment.this.conversationParts.size() - 1, uploadingPart.getId(), ConversationFragment.this.uploadingImageCache, (UploadProgressListener)ConversationFragment.this.getLayoutForPart(uploadingPart).getChildAt(0));
            }
        }

        @Override
        public void onRemoteImageSelected(GalleryImage galleryImage) {
            String path = galleryImage.getPath();
            ConversationFragment.this.sendTapped(Collections.singletonList(new Block.Builder().withType(ConversationFragment.IMAGE_MIME_TYPE).withUrl(path).withAttribution(galleryImage.getAttribution()).withHeight(galleryImage.getImageHeight()).withWidth(galleryImage.getImageWidth())));
            ConversationFragment.this.composerManager.returnToDefaultInput();
        }
    };

    public static ConversationFragment newInstance(String conversationId, LastParticipatingAdmin participant, boolean isRead, boolean isTwoPane, String initialMessage) {
        ConversationFragment frag = new ConversationFragment();
        Bundle args = new Bundle();
        args.putString(ARG_CONVERSATION_ID, conversationId);
        args.putString(ARG_INITIAL_MESSAGE, initialMessage);
        args.putParcelable(ARG_LAST_PARTICIPANT, (Parcelable)participant);
        args.putBoolean(ARG_IS_READ, isRead);
        args.putBoolean(ARG_IS_TWO_PANE, isTwoPane);
        args.setClassLoader(Part.class.getClassLoader());
        frag.setArguments(args);
        return frag;
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        try {
            this.listener = (Listener)context;
        }
        catch (ClassCastException e) {
            throw new ClassCastException(context + " must implement ConversationFragment.Listener");
        }
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Injector injector = Injector.get();
        this.bus = injector.getBus();
        this.api = injector.getApi();
        this.nexusClient = injector.getNexusClient();
        this.appIdentity = injector.getAppIdentity();
        this.userIdentity = injector.getUserIdentity();
        this.store = injector.getStore();
        UserIdentity userIdentity = injector.getUserIdentity();
        this.metricFactory = new MetricFactory(userIdentity);
        this.metricStore = injector.getMetricsStore();
        this.conversationParts = new ArrayList<Part>();
        this.generator = new ViewHolderGenerator((Context)this.getActivity(), this.uploadingImageCache, injector.getApiProvider(), this.appIdentity, this.conversationId);
        this.blocksUserViewHolder = this.generator.getUserHolder();
        this.blocksAnnouncementViewHolder = this.generator.getContainerCardHolder();
        this.blocksAdminViewHolder = this.generator.getAdminHolder();
        this.blocksLinkViewHolder = this.generator.getLinkHolder();
        Bundle args = this.getArguments();
        if (args != null) {
            boolean isRead;
            args.setClassLoader(Part.class.getClassLoader());
            this.conversationId = args.getString(ARG_CONVERSATION_ID, "");
            this.initialMessage = args.getString(ARG_INITIAL_MESSAGE, "");
            this.lastParticipant = (LastParticipatingAdmin)args.getParcelable(ARG_LAST_PARTICIPANT);
            if (this.lastParticipant == null) {
                this.lastParticipant = LastParticipatingAdmin.NULL;
            }
            if (!(isRead = args.getBoolean(ARG_IS_READ, false))) {
                this.store.dispatch(Actions.conversationMarkedAsRead(this.conversationId));
            }
            this.isTwoPane = args.getBoolean(ARG_IS_TWO_PANE, false);
            if (TextUtils.isEmpty((CharSequence)this.conversationId)) {
                this.store.dispatch(Actions.composerOpened());
            } else {
                this.store.dispatch(Actions.conversationOpened(this.conversationId));
            }
        }
        this.conversationParts = new ArrayList<Part>();
        this.conversation = new Conversation();
        this.soundPlayer = new SoundPlayer((Context)this.getActivity(), this.appIdentity);
        this.networkState = NetworkState.UNKNOWN;
        this.currentOrientation = this.getResources().getConfiguration().orientation;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        if (this.rootView == null) {
            this.rootView = inflater.inflate(R.layout.intercom_fragment_conversation, container, false);
        } else {
            ViewGroup parent = (ViewGroup)this.rootView.getParent();
            if (parent != null) {
                parent.removeView(this.rootView);
            }
        }
        this.pill = (TextView)this.rootView.findViewById(R.id.pill);
        this.pill.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ConversationFragment.this.pill.setVisibility(8);
                ConversationFragment.this.conversationList.smoothScrollToPosition(ConversationFragment.this.adapter.getCount() - 1);
            }
        });
        this.composerHolder = (FrameLayout)this.rootView.findViewById(R.id.composer_holder);
        this.profileCoordinator = new ProfileCoordinator((CoordinatorLayout)this.rootView.findViewById(R.id.conversation_coordinator_layout), this.metricStore, this.metricFactory);
        this.profileCoordinator.setConversationId(this.conversationId);
        this.conversationList = (RecyclerView)this.rootView.findViewById(R.id.conversation_list);
        ((SimpleItemAnimator)this.conversationList.getItemAnimator()).setSupportsChangeAnimations(false);
        this.conversationList.setNestedScrollingEnabled(true);
        this.intercomErrorView = (IntercomErrorView)this.rootView.findViewById(R.id.error_layout_conversation);
        this.intercomErrorView.setActionButtonTextColor(this.appIdentity.getAppConfig().getBaseColor());
        this.intercomErrorView.setActionButtonClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ConversationFragment.this.displayLoadingView();
                ConversationFragment.this.api.getConversation(ConversationFragment.this.conversationId);
            }
        });
        this.blocks = new Blocks((Context)this.getActivity(), LumberMill.getBlocksTwig());
        this.layoutManager = new LinearLayoutManager((Context)this.getActivity(), 1, false);
        this.conversationList.setLayoutManager((RecyclerView.LayoutManager)this.layoutManager);
        this.conversationList.addItemDecoration((RecyclerView.ItemDecoration)new ConversationItemDecoration((Context)this.getActivity(), this.conversationParts));
        this.adapter = ConversationPartAdapter.create((Activity)this.getActivity(), this.conversationParts, this, this.api, this.conversationId);
        this.conversationList.setAdapter((RecyclerView.Adapter)this.adapter);
        this.bus.register((Object)this);
        this.intercomLinkView = (IntercomLinkView)this.rootView.findViewById(R.id.intercom_link);
        this.intercomLinkView.setAlpha(0.0f);
        this.shouldShowIntercomLink = this.appIdentity.getAppConfig().shouldShowIntercomLink();
        if (this.shouldShowIntercomLink) {
            int bottomPadding = this.conversationList.getPaddingBottom() + this.getResources().getDimensionPixelSize(R.dimen.intercom_link_height);
            this.conversationList.setPadding(this.conversationList.getPaddingLeft(), this.conversationList.getPaddingTop(), this.conversationList.getPaddingRight(), bottomPadding);
            this.intercomLinkView.setOnTouchListener(new View.OnTouchListener(){

                public boolean onTouch(View v, MotionEvent event) {
                    boolean interceptEvent;
                    int action = event.getActionMasked();
                    boolean bl = interceptEvent = ConversationFragment.this.intercomLinkView.getAlpha() == 1.0f;
                    if (interceptEvent && 1 == action) {
                        ConversationFragment.this.intercomLinkView.followIntercomLink(ConversationFragment.this.appIdentity, ConversationFragment.this.getFirstMessagePart(), ConversationFragment.this.api);
                    }
                    return interceptEvent;
                }
            });
            this.profileCoordinator.addListener(new AppBarLayout.OnOffsetChangedListener(){

                public void onOffsetChanged(AppBarLayout appBarLayout, int verticalOffset) {
                    View lastChild;
                    int lastPos = ConversationFragment.this.adapter.getCount() - 1;
                    if (lastPos > 0 && (lastChild = ConversationFragment.this.conversationList.getChildAt(lastPos)) != null) {
                        ConversationFragment.this.intercomLinkView.intersectsView(lastChild);
                    }
                }
            });
        }
        ImageView wallpaper = (ImageView)this.rootView.findViewById(R.id.wallpaper);
        this.wallpaperLoader = WallpaperLoader.create(this.getContext(), this.appIdentity);
        this.wallpaperLoader.loadWallpaperInto(wallpaper, new WallpaperLoader.Listener(){

            @Override
            public void onLoadComplete() {
                BackgroundUtils.setBackground(ConversationFragment.this.rootView, null);
            }
        });
        FrameLayout composerContainer = (FrameLayout)this.rootView.findViewById(R.id.composer_container);
        composerContainer.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (ConversationFragment.this.isAtBottom()) {
                    ConversationFragment.this.shouldStayAtBottom = true;
                }
            }
        });
        this.composerManager = new ComposerManager(this.composerListener, composerContainer, this.getChildFragmentManager(), inflater, this.nexusClient, this.userIdentity, this.appIdentity, this.metricStore, this.metricFactory, this.conversationId, this.initialMessage, (Context)this.getActivity(), this.appIdentity.getAppConfig().getBaseColor());
        this.reactionComposer = (ReactionInputView)this.rootView.findViewById(R.id.reaction_input_view);
        this.setupComposer();
        this.intercomToolbar = (IntercomToolbar)this.rootView.findViewById(R.id.intercom_toolbar);
        this.intercomToolbar.setListener(this);
        this.intercomToolbar.setInboxButtonVisibility(this.isTwoPane ? 8 : 0);
        this.listener.setStatusBarColor();
        this.globalLayoutListener = new ViewTreeObserver.OnGlobalLayoutListener(){
            private int previousHeight;

            public void onGlobalLayout() {
                int newHeight = ConversationFragment.this.rootView.getHeight();
                if (this.previousHeight != 0 && !ConversationFragment.this.orientationChanged && this.previousHeight > newHeight) {
                    ConversationFragment.this.profileCoordinator.flingProfileClosed();
                    if (ConversationFragment.this.shouldStayAtBottom) {
                        ConversationFragment.this.conversationList.scrollToPosition(ConversationFragment.this.adapter.getCount() - 1);
                        ConversationFragment.this.shouldStayAtBottom = false;
                    }
                }
                if (ConversationFragment.this.orientationChanged && this.previousHeight != newHeight) {
                    ConversationFragment.this.orientationChanged = false;
                }
                this.previousHeight = newHeight;
                ConversationFragment.this.updateIntercomLink();
            }
        };
        this.rootView.getViewTreeObserver().addOnGlobalLayoutListener(this.globalLayoutListener);
        this.conversationList.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
                if (newState == 0 && ConversationFragment.this.isAtBottom()) {
                    ConversationFragment.this.pill.setVisibility(8);
                }
            }

            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);
                ConversationFragment.this.updateIntercomLink();
            }
        });
        return this.rootView;
    }

    void displayLoadingView() {
        if (this.isAdded()) {
            this.intercomErrorView.setVisibility(8);
            this.pill.setVisibility(8);
            this.composerManager.hideComposer();
            this.loadingPart = new Part.Builder().withStyle("loading_layout_style").build();
            this.conversationParts.add(0, this.loadingPart);
            this.adapter.notifyItemInserted(0);
            this.conversationList.setVisibility(0);
        }
    }

    Part getFirstMessagePart() {
        for (Part part : this.conversationParts) {
            if (!part.isMessagePart()) continue;
            return part;
        }
        return Part.NULL;
    }

    private void setupComposer() {
        this.composerManager.requestFocus();
        this.configureInputView(this.conversation);
        if (this.conversationId.isEmpty()) {
            this.composerHolder.setVisibility(0);
            this.conversationList.setVisibility(0);
            this.displayConversation();
        } else {
            this.composerManager.setConversationId(this.conversationId);
            this.displayLoadingView();
        }
    }

    private void configureInputView(Conversation conversation) {
        Part lastPart = conversation.getLastPart();
        if (ReactionReply.isNull(lastPart.getReactionReply())) {
            this.composerManager.showComposer();
            this.composerManager.requestFocus();
            this.reactionComposer.setVisibility(8);
        } else {
            this.reactionComposer.setUpReactions(lastPart.getReactionReply(), conversation.getId(), lastPart.getId(), "", ReactionInputView.ReactionLocation.CONVERSATION, true, this.metricStore, this.metricFactory);
            this.composerManager.hideComposer();
        }
    }

    @VisibleForTesting
    protected void displayConversation() {
        if (this.isAdded()) {
            this.intercomErrorView.setVisibility(8);
            this.conversationList.setVisibility(0);
            this.removeLoadingPart();
            this.configureInputView(this.conversation);
        }
    }

    private void removeLoadingPart() {
        int index = this.conversationParts.indexOf(this.loadingPart);
        if (index != -1) {
            this.conversationParts.remove(index);
            this.adapter.notifyItemRemoved(index);
        }
    }

    void updateIntercomLink() {
        boolean isAtBottom = this.isAtBottom();
        if (this.shouldShowIntercomLink) {
            if (isAtBottom && !this.wasAtBottom) {
                this.intercomLinkView.show();
            } else if (this.wasAtBottom && !isAtBottom) {
                this.intercomLinkView.hide();
            }
            this.wasAtBottom = this.isAtBottom();
        }
    }

    boolean isAtBottom() {
        return this.layoutManager.findLastCompletelyVisibleItemPosition() >= this.conversationParts.size() - 1;
    }

    public void onViewCreated(View view, Bundle bundle) {
        super.onViewCreated(view, bundle);
        if (this.conversationId.isEmpty()) {
            if (this.shouldShowIntercomLink) {
                this.intercomLinkView.show();
            }
            this.canOpenProfile = false;
            view.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (ConversationFragment.this.getActivity() == null) {
                        return;
                    }
                    ConversationFragment.this.profileCoordinator.profileAutoOpened();
                    ConversationFragment.this.profileCoordinator.startOffsetListener();
                    ConversationFragment.this.conversationList.smoothScrollToPosition(0);
                }
            }, 50L);
        }
    }

    public void onStart() {
        super.onStart();
        if (!this.hasLoadedConversation && !this.conversationId.isEmpty() && LastParticipatingAdmin.isNull(this.lastParticipant)) {
            this.profileCoordinator.setUnknownPresence();
        } else {
            this.updateProfileToolbar();
        }
        this.networkConnectivityListener.startListening((Context)this.getActivity());
        this.networkConnectivityListener.registerHandler(this.connectivityMonitor, 0);
        if (!this.conversationId.isEmpty()) {
            AsyncTask.THREAD_POOL_EXECUTOR.execute(new Runnable(){

                @Override
                public void run() {
                    ConversationFragment.this.api.getConversation(ConversationFragment.this.conversationId);
                }
            });
        }
    }

    private void updateProfileToolbar() {
        if (LastParticipatingAdmin.isNull(this.lastParticipant) || this.lastParticipant == LastParticipatingAdmin.NONE) {
            this.showTeamPresence();
        } else {
            this.updateLastActiveTime(this.lastParticipant.getLastActiveAt());
            TimeFormatter timeFormatter = new TimeFormatter((Context)this.getActivity(), Injector.get().getTimeProvider());
            this.profileCoordinator.setTeammatePresence(this.lastParticipant, this.lastActiveTime, timeFormatter.isAdminActive(this.lastParticipant.getLastActiveAt()), this.rootView.getWidth());
        }
    }

    private void updateLastActiveTime(long time) {
        LastParticipatingAdmin lastAdmin = this.conversation.getLastParticipatingAdmin();
        if (lastAdmin != null && this.getActivity() != null) {
            TimeFormatter timeFormatter = new TimeFormatter((Context)this.getActivity(), Injector.get().getTimeProvider());
            this.lastActiveTime = timeFormatter.getAdminActiveStatus(time, (AppConfig.Provider)this.appIdentity);
        }
    }

    private void showTeamPresence() {
        this.profileCoordinator.setTeamCollapsingTitle(this.appIdentity.getAppConfig().getName());
        TeamPresence presence = this.store.state().teamPresence();
        if (presence.isEmpty()) {
            this.profileCoordinator.hideTeammateSubtitle();
        } else {
            this.profileCoordinator.setTeamPresence(presence, this.getActivity().getWindow().getDecorView().getMeasuredWidth());
        }
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (newConfig.orientation != this.currentOrientation) {
            this.orientationChanged = true;
            this.composerManager.updateMaxLines();
        }
        this.currentOrientation = newConfig.orientation;
    }

    public void onResume() {
        super.onResume();
        this.subscription = this.store.subscribeToChanges(Selectors.UNREAD_COUNT, this);
    }

    @Override
    public void onStateChange(Integer unreadCount) {
        this.intercomToolbar.setUnreadCount(unreadCount);
    }

    public void onPause() {
        StoreUtils.safeUnsubscribe(this.subscription);
        super.onPause();
    }

    public void onStop() {
        super.onStop();
        this.networkConnectivityListener.unregisterHandler(this.connectivityMonitor);
        this.networkConnectivityListener.stopListening();
        this.profileCoordinator.onStop();
    }

    public void onDestroyView() {
        ViewUtils.removeGlobalLayoutListener(this.rootView, this.globalLayoutListener);
        this.bus.unregister((Object)this);
        View view = this.getView();
        if (view != null) {
            view.removeCallbacks(this.replyDeliveredUpdater);
            view.removeCallbacks(this.timestampUpdater);
        }
        this.composerManager.cleanup();
        try {
            this.wallpaperLoader.close();
        }
        catch (IOException e) {
            this.twig.d("Couldn't close LongTermImageLoader: " + e.getMessage(), new Object[0]);
        }
        super.onDestroyView();
    }

    public void sdkWindowFinishedAnimating() {
        if (this.getView() != null && this.profileExpansionLogic.shouldExpandProfile(this.conversation)) {
            this.profileCoordinator.profileAutoOpened();
            this.conversationList.smoothScrollToPosition(0);
        }
    }

    public String getConversationId() {
        return this.conversationId;
    }

    public void retryTapped() {
        if (this.markedPart == null) {
            return;
        }
        this.markedPart.setMessageState(Part.MessageState.SENDING);
        this.conversationParts.remove(this.markedPart);
        this.conversationParts.add(this.markedPart);
        this.adapter.notifyDataSetChanged();
        List<Block> partBlocks = this.markedPart.getBlocks();
        int size = partBlocks.size();
        ArrayList<Block.Builder> blockBuilders = new ArrayList<Block.Builder>(partBlocks.size());
        for (int i = 0; i < size; ++i) {
            blockBuilders.add(partBlocks.get(i).toBuilder());
        }
        if (TextUtils.isEmpty((CharSequence)this.conversationId)) {
            this.startConversation(blockBuilders, this.markedPart.getId());
        } else {
            this.replyToConversation(blockBuilders, this.markedPart, this.conversationParts.size() - 1);
        }
        this.markedPart = null;
    }

    private void startConversation(List<Block.Builder> blockBuilders, String partId) {
        this.api.startNewConversation(blockBuilders, this.conversationParts.size() - 1, partId);
    }

    private void replyToConversation(List<Block.Builder> blockBuilders, Part part, int partPosition) {
        this.api.replyToConversation(this.conversationId, blockBuilders, partPosition, part.getId(), false);
    }

    public void toggleProfile() {
        if (this.profileCoordinator.isExpanded()) {
            this.profileCoordinator.flingProfileClosed();
        } else {
            this.profileCoordinator.profileClicked();
            this.conversationList.smoothScrollToPosition(0);
        }
    }

    @Subscribe
    public void conversationSuccess(ConversationEvent event) {
        this.composerHolder.setVisibility(0);
        int conversationSize = this.conversation.getParts().size();
        List<Part> eventParts = event.getResponse().getParts();
        if (event.getResponse().getId().equals(this.conversationId) && eventParts.size() > conversationSize) {
            boolean isUnread;
            this.conversation = event.getResponse();
            if (this.isAdded()) {
                this.setupWithConversation();
            }
            boolean bl = isUnread = !this.conversation.isRead();
            if (isUnread) {
                this.api.markConversationAsRead(this.conversationId);
                this.store.dispatch(Actions.conversationMarkedAsRead(this.conversationId));
                this.nexusClient.fire(NexusEvent.getConversationSeenEvent((String)this.conversationId, (String)this.userIdentity.getIntercomId()));
            }
            if (conversationSize == 0) {
                View view;
                Part lastPart = eventParts.get(eventParts.size() - 1);
                if (lastPart.isReply() && isUnread) {
                    this.metricStore.track(this.metricFactory.receivedReply(lastPart.hasAttachments(), lastPart.isLinkCard(), lastPart.getId(), this.conversationId));
                }
                if (this.canOpenProfile && (view = this.getView()) != null) {
                    final boolean profileWillOpen = this.profileExpansionLogic.shouldExpandProfile(this.conversation);
                    view.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            if (ConversationFragment.this.getContext() == null) {
                                return;
                            }
                            if (profileWillOpen) {
                                ConversationFragment.this.profileCoordinator.profileAutoOpened();
                                ConversationFragment.this.profileCoordinator.startOffsetListener();
                                ConversationFragment.this.conversationList.smoothScrollToPosition(0);
                            } else {
                                ConversationFragment.this.profileCoordinator.startOffsetListener();
                            }
                        }
                    }, 50L);
                    if (profileWillOpen) {
                        this.conversationList.scrollToPosition(0);
                    } else {
                        this.conversationList.scrollToPosition(this.adapter.getCount() - 1);
                    }
                    this.canOpenProfile = false;
                }
            } else {
                List<Part> newParts = eventParts.subList(conversationSize, eventParts.size());
                for (Part p : newParts) {
                    if (!p.isAdmin()) continue;
                    this.soundPlayer.playMessageReceivedSound();
                    break;
                }
                if (this.isAtBottom()) {
                    this.conversationList.smoothScrollToPosition(this.adapter.getCount() - 1);
                } else {
                    this.pill.setVisibility(0);
                }
                this.bus.post((Object)new CancelAdminTypingEvent());
                this.currentTypers.clear();
                Part lastPart = newParts.get(newParts.size() - 1);
                this.metricStore.track(this.metricFactory.receivedReply(lastPart.hasAttachments(), lastPart.isLinkCard(), lastPart.getId(), this.conversationId));
            }
        }
        this.lastParticipant = this.conversation.getLastParticipatingAdmin();
        this.adapter.setLastParticipatingAdmin(this.lastParticipant);
        LastParticipatingAdmin lastAdmin = this.conversation.getLastParticipatingAdmin();
        if (lastAdmin != null) {
            this.updateLastActiveTime(lastAdmin.getLastActiveAt());
        }
        this.updateProfileToolbar();
        this.hasLoadedConversation = true;
    }

    private void setupWithConversation() {
        this.createConversationUi(this.conversation.getParts());
        this.postOnView(this.timestampUpdater, TIMESTAMP_UPDATE_PERIOD);
    }

    private void createConversationUi(List<Part> parts) {
        this.conversationParts.clear();
        for (Part part : parts) {
            if (this.getLayoutForPart(part) == null) {
                this.createMessageUi(part);
            }
            this.conversationParts.add(part);
        }
        this.conversationParts.addAll(this.sendingFailures);
        this.timestampAdder.addDayDividers(this.conversationParts);
        this.adapter.notifyDataSetChanged();
        this.displayConversation();
    }

    ViewGroup getLayoutForPart(Part part) {
        return this.adapter.getLayoutForPart(part);
    }

    private Part createSendingPart(List<Block.Builder> blockBuilders) {
        ArrayList<Block> builtBlocks = new ArrayList<Block>(blockBuilders.size());
        int size = blockBuilders.size();
        for (int i = 0; i < size; ++i) {
            builtBlocks.add(blockBuilders.get(i).build());
        }
        Part part = new Part();
        part.setMessageStyle("chat");
        part.setMessageState(Part.MessageState.SENDING);
        part.setParticipant(this.getUserParticipant());
        part.setBlocks(builtBlocks);
        part.setCreatedAt(TimeUnit.MILLISECONDS.toSeconds(TimeProvider.SYSTEM.currentTimeMillis()));
        this.setLayoutForBlock(part, (ViewGroup)this.blocks.createBlocks(builtBlocks, this.generator.getPreviewHolder()));
        part.setEntranceAnimation(true);
        this.conversationParts.add(part);
        this.sendingFailures.add(part);
        this.adapter.notifyDataSetChanged();
        return part;
    }

    void setLayoutForBlock(Part part, ViewGroup blocks) {
        this.adapter.setLayoutForBlock(part, blocks);
    }

    Participant getUserParticipant() {
        String intercomId = this.userIdentity.getIntercomId();
        Participant user = this.conversation.getParticipant(intercomId);
        if (Participant.isNull(user)) {
            user = new Participant.Builder().withId(intercomId).build();
        }
        return user;
    }

    @Subscribe
    public void onUserContentSeenByAdmin(UserContentSeenByAdminEvent event) {
        if (event.getConversationId().equals(this.conversationId) && this.conversationParts != null && !this.conversationParts.isEmpty()) {
            boolean markedAsSeen = false;
            for (int i = this.conversationParts.size() - 1; i >= 0; --i) {
                Part part = this.conversationParts.get(i);
                if (!markedAsSeen && !part.isAdmin()) {
                    part.setSeenByAdmin("seen");
                    markedAsSeen = true;
                    continue;
                }
                part.setSeenByAdmin("hide");
            }
            this.adapter.notifyDataSetChanged();
        }
    }

    @Subscribe
    public void conversationFailure(ConversationFailedEvent event) {
        this.displayErrorView();
    }

    private void displayErrorView() {
        if (this.isAdded()) {
            this.intercomErrorView.setVisibility(0);
            this.composerHolder.setVisibility(8);
            this.conversationList.setVisibility(8);
            this.pill.setVisibility(8);
            this.removeLoadingPart();
        }
    }

    @Subscribe
    public void newConversationSuccess(NewConversationEvent event) {
        if (!this.conversationParts.isEmpty() && this.conversationParts.get(this.conversationParts.size() - 1).getId().equals(event.getIdentifier())) {
            this.conversation = event.getResponse();
            this.conversationId = this.conversation.getId();
            this.profileCoordinator.setConversationId(this.conversationId);
            this.conversationParts.remove(this.conversationParts.size() - 1);
            this.sendingFailures.clear();
            Part part = event.getResponse().getParts().get(0);
            this.createMessageUi(part);
            this.conversationParts.add(part);
            this.composerManager.setConversationId(this.conversationId);
            this.composerManager.setHint(R.string.intercom_reply_to_conversation);
            this.nexusClient.fire(NexusEvent.getCreateConversationEvent((String)this.conversationId, (String)this.userIdentity.getIntercomId()));
            this.soundPlayer.playReplyDeliveredSound();
            this.adapter.notifyDataSetChanged();
            this.metricStore.track(this.metricFactory.sentInNewConversation(part.hasAttachments(), part.isGifOnlyPart(), part.getId(), this.conversationId));
            this.metricStore.track(this.metricFactory.startConversation(this.conversationId));
            this.hasLoadedConversation = true;
        }
    }

    @Subscribe
    public void newConversationFailure(NewConversationFailedEvent event) {
        this.markAsFailed(event.getPosition(), event.getPartId(), false);
    }

    private void markAsFailed(int position, String partId, boolean uploadFailed) {
        int partPosition = this.positionOfTempPart(position, partId);
        if (partPosition >= 0) {
            Part failedPart = this.conversationParts.get(partPosition);
            View partView = this.getLayoutForPart(failedPart).getChildAt(0);
            if (partView instanceof UploadProgressListener) {
                UploadProgressListener listener = (UploadProgressListener)partView;
                listener.uploadStopped();
            }
            failedPart.setMessageState(uploadFailed ? Part.MessageState.UPLOAD_FAILED : Part.MessageState.FAILED);
            this.adapter.notifyDataSetChanged();
        }
    }

    int positionOfTempPart(int position, String partId) {
        if (position >= 0 && position < this.conversationParts.size()) {
            Part sendingPart = this.conversationParts.get(position);
            if (sendingPart.getId().equals(partId)) {
                return position;
            }
            for (int i = this.conversationParts.size() - 1; i >= 0; --i) {
                if (!this.conversationParts.get(i).getId().equals(partId)) continue;
                return i;
            }
        }
        return -1;
    }

    @Subscribe
    public void replySuccess(ReplyEvent event) {
        if (event.getConversationId().equals(this.conversationId)) {
            this.nexusClient.fire(NexusEvent.getNewCommentEvent((String)this.conversationId, (String)this.userIdentity.getIntercomId()));
            final Part part = event.getResponse();
            Participant participant = this.conversation.getParticipant(part.getParticipantId());
            if (Participant.isNull(participant)) {
                participant = new Participant.Builder().withId(part.getParticipantId()).build();
                this.conversation.getParticipants().put(part.getParticipantId(), participant);
            }
            part.setParticipant(participant);
            int position = this.positionOfTempPart(event.getPosition(), event.getPartId());
            if (position >= 0) {
                this.sendingFailures.remove(this.conversationParts.remove(position));
            }
            this.createMessageUi(part);
            part.setDisplayDelivered(true);
            this.conversationParts.add(part);
            this.adapter.notifyDataSetChanged();
            this.soundPlayer.playReplyDeliveredSound();
            this.metricStore.track(this.metricFactory.sentInConversation(part.hasAttachments(), part.isGifOnlyPart(), part.getId(), this.conversationId));
            View view = this.getView();
            if (view != null) {
                view.removeCallbacks(this.replyDeliveredUpdater);
                this.replyDeliveredUpdater = new Runnable(){

                    @Override
                    public void run() {
                        part.setDisplayDelivered(false);
                        ConversationFragment.this.adapter.notifyDataSetChanged();
                    }
                };
                view.postDelayed(this.replyDeliveredUpdater, PART_DISPLAY_DELIVERED_TIMEOUT);
            }
        }
    }

    void postOnView(Runnable action, long delayMillis) {
        View view = this.getView();
        if (view != null) {
            view.postDelayed(action, delayMillis);
        }
    }

    @Subscribe
    public void replyFailure(ReplyFailedEvent event) {
        this.markAsFailed(event.getPosition(), event.getPartId(), event.isUpload());
        this.soundPlayer.playReplyFailedSound();
    }

    @Subscribe
    public void uploadSuccess(UploadEvent event) {
        int partPosition = this.positionOfTempPart(event.getTempPartPosition(), event.getTempPartId());
        if (partPosition >= 0) {
            List<Block.Builder> blocks = this.getSendableBlocks(event);
            if (TextUtils.isEmpty((CharSequence)this.conversationId)) {
                this.api.startNewConversation(blocks, this.conversationParts.size() - 1, event.getTempPartId());
            } else {
                this.api.replyToConversation(this.conversationId, blocks, partPosition, this.conversationParts.get(partPosition).getId(), true);
            }
        }
    }

    private List<Block.Builder> getSendableBlocks(UploadEvent event) {
        Part part = this.conversationParts.get(event.getTempPartPosition());
        Block tempBlock = part.getBlocks().get(0);
        if (event.getUpload().getContentType().contains(IMAGE_MIME_TYPE)) {
            return Collections.singletonList(tempBlock.toBuilder().withType(BlockType.IMAGE.getSerializedName()).withUrl(event.getUpload().getPublicUrl()));
        }
        BlockAttachment tempAttachment = (BlockAttachment)tempBlock.getAttachments().get(0);
        tempAttachment = tempAttachment.toBuilder().withSize(event.getSize()).withId(event.getUpload().getId()).build();
        Block.Builder buider = tempBlock.toBuilder().withAttachments(Collections.singletonList(tempAttachment)).withType(BlockType.ATTACHMENTLIST.getSerializedName());
        return Collections.singletonList(buider);
    }

    private Part createUploadingPart(GalleryImage uploadImage) {
        ArrayList<Block> blockParts = new ArrayList<Block>();
        Part part = new Part();
        part.setUpload(uploadImage);
        if (uploadImage.getMimeType().contains(IMAGE_MIME_TYPE)) {
            Block block = new Block.Builder().withUrl(uploadImage.getPath()).withType(BlockType.LOCALIMAGE.name()).withWidth(uploadImage.getImageWidth()).withHeight(uploadImage.getImageHeight()).build();
            blockParts.add(block);
        } else {
            BlockAttachment blockAttachment = new BlockAttachment.Builder().withName(uploadImage.getFileName()).withUrl(uploadImage.getPath()).withContentType(uploadImage.getMimeType()).build();
            Block block = new Block.Builder().withAttachments(Collections.singletonList(blockAttachment)).withType(BlockType.LOCAL_ATTACHMENT.name()).build();
            blockParts.add(block);
        }
        part.setMessageStyle("chat");
        part.setMessageState(Part.MessageState.SENDING);
        part.setParticipant(this.getUserParticipant());
        part.setBlocks(blockParts);
        part.setCreatedAt(TimeUnit.MILLISECONDS.toSeconds(TimeProvider.SYSTEM.currentTimeMillis()));
        part.setEntranceAnimation(true);
        this.setLayoutForBlock(part, (ViewGroup)this.blocks.createBlocks(blockParts, this.generator.getPreviewHolder()));
        this.conversationParts.add(part);
        this.sendingFailures.add(part);
        this.adapter.notifyDataSetChanged();
        this.conversationList.smoothScrollToPosition(this.adapter.getCount() - 1);
        return part;
    }

    @Subscribe
    public void uploadFailure(UploadFailedEvent event) {
        this.markAsFailed(event.getPosition(), event.getPartId(), true);
        this.soundPlayer.playReplyFailedSound();
    }

    @Subscribe
    public void newComment(NewCommentEvent event) {
        if (event.getConversationId().equals(this.conversationId)) {
            this.api.getConversation(this.conversationId);
        }
    }

    @Subscribe
    public void adminIsTyping(AdminIsTypingEvent event) {
        if (this.conversationId.equals(event.getConversationId()) && !this.currentTypers.contains(event.getAdminId())) {
            Part isTypingPart = new Part();
            Participant participant = this.conversation.getParticipant(event.getAdminId());
            if (Participant.isNull(participant)) {
                participant = new Participant.Builder().withId(event.getAdminId()).withName(event.getAdminName()).withAvatar(new Avatar.Builder().withImageUrl(event.getAdminAvatarUrl())).withType("admin").build();
            }
            isTypingPart.setParticipantIsAdmin(true);
            isTypingPart.setParticipant(participant);
            isTypingPart.setMessageStyle("admin_is_typing_style");
            isTypingPart.setEntranceAnimation(true);
            LinearLayout contentLayout = (LinearLayout)View.inflate((Context)this.getActivity(), (int)R.layout.intercom_blocks_admin_layout, null);
            AdminIsTypingView adminIsTypingView = new AdminIsTypingView((Context)this.getActivity(), event.getAdminId(), this.conversationId, isTypingPart.getId());
            contentLayout.addView((View)adminIsTypingView);
            this.setLayoutForBlock(isTypingPart, (ViewGroup)contentLayout);
            boolean wasAtBottom = this.isAtBottom();
            this.conversationParts.add(isTypingPart);
            this.adapter.notifyDataSetChanged();
            this.currentTypers.add(event.getAdminId());
            if (wasAtBottom) {
                this.conversationList.smoothScrollToPosition(this.adapter.getCount() - 1);
            }
        }
    }

    @Subscribe
    public void adminIsntTyping(AdminTypingEndedEvent event) {
        int position = this.positionOfTempPart(this.conversationParts.size() - 1, event.getPartId());
        if (position >= 0) {
            this.currentTypers.remove(event.getAdminId());
            this.conversationParts.remove(position);
            this.adapter.notifyDataSetChanged();
        }
    }

    private void sendTapped(String text) {
        if (!text.isEmpty()) {
            this.sendTapped(this.blockFactory.getBlocksForText(text));
        }
    }

    private void sendTapped(List<Block.Builder> blockBuilders) {
        Part message = this.createSendingPart(blockBuilders);
        this.soundPlayer.playReplyDeliveredSound();
        if (TextUtils.isEmpty((CharSequence)this.conversationId)) {
            this.startConversation(blockBuilders, message.getId());
        } else {
            this.replyToConversation(blockBuilders, message, this.conversationParts.size() - 1);
        }
        this.conversationList.smoothScrollToPosition(this.adapter.getCount() - 1);
    }

    @Override
    public void onPartClicked(Part part) {
        if (part.getMessageState() == Part.MessageState.FAILED) {
            this.markedPart = part;
            this.showRetryError();
        } else if (part.getMessageState() == Part.MessageState.UPLOAD_FAILED) {
            this.retryFailedUpload(part);
        }
    }

    private void retryFailedUpload(Part part) {
        UploadProgressListener listener;
        int position = this.positionOfTempPart(this.conversationParts.size() - 1, part.getId());
        if (position >= 0) {
            listener = (UploadProgressListener)this.getLayoutForPart(this.conversationParts.get(position)).getChildAt(0);
            listener.uploadStarted();
        } else {
            listener = new UploadProgressListener(){

                @Override
                public void uploadStarted() {
                }

                @Override
                public void uploadNotice(byte percentUploaded) {
                }

                @Override
                public void uploadStopped() {
                }
            };
        }
        part.setMessageState(Part.MessageState.SENDING);
        this.conversationParts.remove(this.conversationParts.indexOf(part));
        this.conversationParts.add(part);
        this.adapter.notifyDataSetChanged();
        this.soundPlayer.playReplySentSound();
        this.api.uploadFile(part.getUpload(), position, part.getId(), this.uploadingImageCache, listener);
    }

    private void showUploadError() {
        new AlertDialog.Builder((Context)this.getActivity()).setTitle(R.string.intercom_failed_to_send).setMessage(R.string.intercom_file_too_big).setPositiveButton(17039370, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
            }
        }).show();
    }

    private void showRetryError() {
        new AlertDialog.Builder((Context)this.getActivity()).setTitle(R.string.intercom_inbox_error_state_title).setMessage(R.string.intercom_message_error_message).setPositiveButton(R.string.intercom_tap_to_retry, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                ConversationFragment.this.retryTapped();
            }
        }).show();
    }

    private void createMessageUi(Part part) {
        Participant user;
        List<Block> blockParts = part.getBlocks();
        if (!part.getAttachments().isEmpty()) {
            ArrayList<BlockAttachment> blockAttachments = new ArrayList<BlockAttachment>();
            for (Attachments attachment : part.getAttachments()) {
                blockAttachments.add(new BlockAttachment.Builder().withName(attachment.getName()).withUrl(attachment.getUrl()).withContentType(attachment.getContentType()).build());
            }
            Block attachmentBlock = new Block.Builder().withType(BlockType.ATTACHMENTLIST.name()).withAttachments(blockAttachments).build();
            blockParts.add(attachmentBlock);
        }
        if ("user".equals((user = part.getParticipant()).getType()) && user.getId().equals(this.userIdentity.getIntercomId())) {
            this.setLayoutForBlock(part, (ViewGroup)this.blocks.createBlocks(blockParts, this.blocksUserViewHolder));
        } else if ("post".equals(part.getMessageStyle()) || "note".equals(part.getMessageStyle())) {
            this.setLayoutForBlock(part, (ViewGroup)this.blocks.createBlocks(blockParts, this.blocksAnnouncementViewHolder));
        } else if (part.isLinkCard()) {
            this.setLayoutForBlock(part, (ViewGroup)this.blocks.createBlocks(blockParts, this.blocksLinkViewHolder));
        } else {
            this.setLayoutForBlock(part, (ViewGroup)this.blocks.createBlocks(blockParts, this.blocksAdminViewHolder));
        }
    }

    @Override
    public void onCloseClicked() {
        this.listener.onToolbarCloseClicked();
    }

    @Override
    public void onToolbarClicked() {
        this.toggleProfile();
    }

    @Override
    public void onInboxClicked() {
        this.composerManager.cleanup();
        this.listener.onBackToInboxClicked();
        this.intercomToolbar.setInboxButtonVisibility(8);
        CharSequence title = Phrase.from(this.intercomToolbar.getContext(), R.string.intercom_chats_with).put("name", this.appIdentity.getAppConfig().getName()).format();
        this.intercomToolbar.setTitle(title);
        this.intercomToolbar.setSubtitle("");
    }

    public boolean shouldHandleOnBackPressed() {
        return this.composerManager.isOpen();
    }

    public void handleOnBackPressed() {
        this.composerManager.onBackPressed();
    }

    public static interface Listener {
        public void setStatusBarColor();

        public void onToolbarCloseClicked();

        public void onBackToInboxClicked();
    }
}

