/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.input.gallery;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import java.io.File;

public class GalleryImage
implements Parcelable {
    @NonNull
    private final String fileName;
    @NonNull
    private final String mimeType;
    @NonNull
    private final String path;
    @NonNull
    private final String previewPath;
    @NonNull
    private final String attribution;
    private final int imageWidth;
    private final int imageHeight;
    public static final Parcelable.Creator<GalleryImage> CREATOR = new Parcelable.Creator<GalleryImage>(){

        public GalleryImage createFromParcel(Parcel source) {
            return new GalleryImage(source);
        }

        public GalleryImage[] newArray(int size) {
            return new GalleryImage[size];
        }
    };

    private GalleryImage(Builder builder) {
        this.fileName = builder.fileName == null ? "" : builder.fileName;
        this.mimeType = builder.mimeType == null ? "" : builder.mimeType;
        this.path = builder.path == null ? "" : builder.path;
        this.previewPath = builder.previewPath == null ? "" : builder.previewPath;
        this.attribution = builder.attribution == null ? "" : builder.attribution;
        this.imageWidth = builder.imageWidth;
        this.imageHeight = builder.imageHeight;
    }

    @NonNull
    public String getPath() {
        return this.path;
    }

    @NonNull
    public String getFileName() {
        return this.fileName;
    }

    @NonNull
    public String getMimeType() {
        return this.mimeType;
    }

    @NonNull
    public String getPreviewPath() {
        return this.previewPath;
    }

    @NonNull
    public String getAttribution() {
        return this.attribution;
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public int getImageHeight() {
        return this.imageHeight;
    }

    public String getImageWidthXHeight() {
        return this.imageWidth + "x" + this.imageHeight;
    }

    public File buildFile() {
        return new File(this.path);
    }

    protected GalleryImage(Parcel in) {
        this.fileName = in.readString();
        this.mimeType = in.readString();
        this.path = in.readString();
        this.previewPath = in.readString();
        this.attribution = in.readString();
        this.imageWidth = in.readInt();
        this.imageHeight = in.readInt();
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.fileName);
        dest.writeString(this.mimeType);
        dest.writeString(this.path);
        dest.writeString(this.previewPath);
        dest.writeString(this.attribution);
        dest.writeInt(this.imageWidth);
        dest.writeInt(this.imageHeight);
    }

    public int describeContents() {
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GalleryImage that = (GalleryImage)o;
        if (this.imageWidth != that.imageWidth) {
            return false;
        }
        if (this.imageHeight != that.imageHeight) {
            return false;
        }
        if (!this.fileName.equals(that.fileName)) {
            return false;
        }
        if (!this.mimeType.equals(that.mimeType)) {
            return false;
        }
        if (!this.path.equals(that.path)) {
            return false;
        }
        if (!this.previewPath.equals(that.previewPath)) {
            return false;
        }
        return this.attribution.equals(that.attribution);
    }

    public int hashCode() {
        int result = this.fileName.hashCode();
        result = 31 * result + this.mimeType.hashCode();
        result = 31 * result + this.path.hashCode();
        result = 31 * result + this.previewPath.hashCode();
        result = 31 * result + this.attribution.hashCode();
        result = 31 * result + this.imageWidth;
        result = 31 * result + this.imageHeight;
        return result;
    }

    public static final class Builder {
        private String fileName;
        private String mimeType;
        private String path;
        private String previewPath;
        private String attribution;
        private int imageWidth;
        private int imageHeight;

        public Builder withFileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public Builder withMimeType(String mimeType) {
            this.mimeType = mimeType;
            return this;
        }

        public Builder withPath(String path) {
            this.path = path;
            return this;
        }

        public Builder withPreviewPath(String previewPath) {
            this.previewPath = previewPath;
            return this;
        }

        public Builder withAttribution(String attribution) {
            this.attribution = attribution;
            return this;
        }

        public Builder withImageWidth(int imageWidth) {
            this.imageWidth = imageWidth;
            return this;
        }

        public Builder withImageHeight(int imageHeight) {
            this.imageHeight = imageHeight;
            return this;
        }

        public GalleryImage build() {
            return new GalleryImage(this);
        }
    }
}

