/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.composer.input;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorRes;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentManager;
import android.text.TextUtils;
import com.intercom.composer.input.IconProvider;
import com.intercom.composer.input.InputFragment;
import io.intercom.android.sdk.R;

public abstract class Input<T extends InputFragment> {
    private final String uniqueIdentifier;
    private final IconProvider iconProvider;
    private String fragmentTag;

    protected Input(String uniqueIdentifier, IconProvider iconProvider) {
        this.uniqueIdentifier = uniqueIdentifier;
        this.iconProvider = iconProvider;
        if (TextUtils.isEmpty((CharSequence)uniqueIdentifier)) {
            throw new IllegalArgumentException("Inputs must have a non-empty unique identifier.");
        }
    }

    public abstract T createFragment();

    public String getUniqueIdentifier() {
        return this.uniqueIdentifier;
    }

    @Nullable
    public T findFragment(FragmentManager fragmentManager) {
        return (T)((Object)((InputFragment)fragmentManager.findFragmentByTag(this.fragmentTag)));
    }

    @ColorRes
    public int getBackgroundColor() {
        return R.color.intercom_composer_white;
    }

    @ColorRes
    public int getBorderColor() {
        return R.color.intercom_composer_border;
    }

    public void setFragmentTag(String fragmentTag) {
        this.fragmentTag = fragmentTag;
    }

    public Drawable getIconDrawable(Context context) {
        return this.iconProvider.getIconDrawable(this.uniqueIdentifier, context);
    }
}

