/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.models;

import io.intercom.android.sdk.models.Avatar;
import io.intercom.com.google.gson.annotations.SerializedName;

public class User {
    @SerializedName(value="intercom_id")
    private final String intercomId;
    @SerializedName(value="anonymous_id")
    private final String anonymousId;
    @SerializedName(value="user_id")
    private final String userId;
    private final String email;

    public User() {
        this.intercomId = "";
        this.anonymousId = "";
        this.userId = "";
        this.email = "";
    }

    User(Builder builder) {
        this.intercomId = builder.intercom_id == null ? "" : builder.intercom_id;
        this.anonymousId = builder.anonymous_id == null ? "" : builder.anonymous_id;
        this.userId = builder.user_id == null ? "" : builder.user_id;
        this.email = builder.email == null ? "" : builder.email;
    }

    public String getIntercomId() {
        return this.intercomId;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getEmail() {
        return this.email;
    }

    public String getAnonymousId() {
        return this.anonymousId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        User user = (User)o;
        if (!this.intercomId.equals(user.intercomId)) {
            return false;
        }
        if (!this.anonymousId.equals(user.anonymousId)) {
            return false;
        }
        if (!this.userId.equals(user.userId)) {
            return false;
        }
        return this.email.equals(user.email);
    }

    public int hashCode() {
        int result = this.intercomId.hashCode();
        result = 31 * result + this.anonymousId.hashCode();
        result = 31 * result + this.userId.hashCode();
        result = 31 * result + this.email.hashCode();
        return result;
    }

    public static final class Builder {
        String intercom_id;
        String anonymous_id;
        String user_id;
        String email;
        private Avatar.Builder avatar;

        public Builder withIntercomId(String intercomId) {
            this.intercom_id = intercomId;
            return this;
        }

        public Builder withAnonymousId(String anonymousId) {
            this.anonymous_id = anonymousId;
            return this;
        }

        public Builder withUserId(String userId) {
            this.user_id = userId;
            return this;
        }

        public Builder withEmail(String email) {
            this.email = email;
            return this;
        }

        public Builder withAvatar(Avatar.Builder avatar) {
            this.avatar = avatar;
            return this;
        }

        public User build() {
            return new User(this);
        }
    }
}

