/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.preview;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import android.util.Property;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.commons.utilities.ScreenUtils;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.preview.PreviewCallbacks;
import io.intercom.android.sdk.utilities.Phrase;
import io.intercom.android.sdk.utilities.SimpleAnimatorListener;
import io.intercom.com.facebook.rebound.BaseSpringSystem;
import io.intercom.com.facebook.rebound.SimpleSpringListener;
import io.intercom.com.facebook.rebound.Spring;
import io.intercom.com.facebook.rebound.SpringConfig;
import io.intercom.com.facebook.rebound.SpringListener;

abstract class Overlay
implements View.OnTouchListener {
    private static final float RESISTANCE = 2.0f;
    private static final int ANIMATE_OFFSCREEN_OFFSET = 200;
    private static final int DISMISS_DISTANCE_DP = 80;
    protected static final float SCALE_OFFSET = 0.05f;
    protected static final int MARGIN_OFFSET_DP = 8;
    private final PreviewCallbacks previewCallbacks;
    protected final Spring spring;
    protected final int screenHeight;
    protected final Context localisedContext;
    @NonNull
    protected Conversation conversation;
    protected int position;
    private float initialViewX;
    private float initialTouchX;
    protected ViewGroup overlayRoot;

    protected Overlay(Context localisedContext, @NonNull Conversation conversation, int position, BaseSpringSystem springSystem, int screenHeight, PreviewCallbacks previewCallbacks) {
        this.conversation = conversation;
        this.previewCallbacks = previewCallbacks;
        this.position = position;
        this.screenHeight = screenHeight;
        this.localisedContext = localisedContext;
        this.spring = springSystem.createSpring();
        this.spring.setSpringConfig(new SpringConfig(400.0, 40.0));
    }

    public void removeView() {
        if (this.getRootView() != null && this.getRootView().getParent() != null) {
            ((ViewGroup)this.getRootView().getParent()).removeView(this.getRootView());
        }
    }

    @NonNull
    public Conversation getConversation() {
        return this.conversation;
    }

    public boolean onTouch(View v, MotionEvent event) {
        float dx = (event.getRawX() - this.initialTouchX) / 2.0f;
        this.spring.setAtRest();
        switch (event.getAction()) {
            case 0: {
                this.initialViewX = v.getX();
                this.initialTouchX = event.getRawX();
                this.onPreviewPressed(this.getRootView());
                break;
            }
            case 2: {
                v.setX(dx + this.initialViewX);
                break;
            }
            case 1: {
                float absDx = Math.abs(dx);
                if (absDx < 5.0f) {
                    this.previewCallbacks.onSnippetTap(this.conversation);
                    break;
                }
                if (absDx > (float)ScreenUtils.convertDpToPixel((float)80.0f, (Context)this.localisedContext)) {
                    this.stopListeningForTouchEvents();
                    this.animateOffScreen(v, this.initialViewX, ((View)v.getParent()).getWidth());
                    break;
                }
                this.onPreviewReleased(this.getRootView());
                this.animateToOriginalPosition(v);
                break;
            }
        }
        return true;
    }

    private void animateToOriginalPosition(final View view) {
        this.spring.removeAllListeners();
        this.spring.addListener((SpringListener)new SimpleSpringListener(){

            public void onSpringUpdate(Spring spring) {
                view.setX((float)spring.getCurrentValue());
            }
        });
        this.spring.setCurrentValue((double)view.getX());
        this.spring.setEndValue((double)this.initialViewX);
    }

    private void animateOffScreen(final View view, float initialViewX, float screenWidth) {
        int offset = ScreenUtils.convertDpToPixel((float)200.0f, (Context)view.getContext());
        float endValue = view.getX() > initialViewX ? screenWidth + (float)offset : (float)(-1 * view.getWidth() - offset);
        this.spring.removeAllListeners();
        this.spring.addListener((SpringListener)new SimpleSpringListener(){

            public void onSpringUpdate(Spring spring) {
                view.setX((float)spring.getCurrentValue());
            }

            public void onSpringAtRest(Spring spring) {
                Overlay.this.previewCallbacks.onSnippetDismiss(Overlay.this);
            }
        });
        this.spring.setCurrentValue((double)view.getX());
        float threshold = Math.abs(endValue / view.getX());
        this.spring.setRestDisplacementThreshold((double)threshold);
        this.spring.setRestSpeedThreshold((double)threshold);
        this.spring.setEndValue((double)endValue);
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public boolean isAttached() {
        return this.overlayRoot.getParent() != null;
    }

    @VisibleForTesting
    CharSequence getHeaderText() {
        if (this.conversation.isAdminReply()) {
            return this.localisedContext.getText(R.string.intercom_reply_from_admin) + " " + this.conversation.getLastAdmin().getForename();
        }
        return Phrase.from(this.localisedContext, R.string.intercom_teammate_from_company).put("name", this.conversation.getLastAdmin().getForename()).put("company", Injector.get().getAppIdentity().getAppConfig().getName()).format();
    }

    protected void animateToPosition(Context context) {
        int rootHeight = (int)context.getResources().getDimension(R.dimen.intercom_notification_preview_height);
        int margin = ScreenUtils.convertDpToPixel((float)(32 + 8 * this.position), (Context)context);
        int dy = this.screenHeight - (rootHeight + margin);
        PropertyValuesHolder y = PropertyValuesHolder.ofFloat((String)"y", (float[])new float[]{this.overlayRoot.getY(), dy});
        float startScaleX = this.overlayRoot.getScaleX();
        float endScaleX = 1.0f - (float)this.position * 0.05f;
        PropertyValuesHolder scaleX = PropertyValuesHolder.ofFloat((String)"scaleX", (float[])new float[]{startScaleX, endScaleX});
        ObjectAnimator.ofPropertyValuesHolder((Object)this.overlayRoot, (PropertyValuesHolder[])new PropertyValuesHolder[]{y, scaleX}).setDuration(200L).start();
    }

    protected void animateToBackOfStack(Context context) {
        int rootHeight = (int)context.getResources().getDimension(R.dimen.intercom_notification_preview_height);
        int margin = ScreenUtils.convertDpToPixel((float)(32 + 8 * this.position), (Context)context);
        int dy = this.screenHeight - (rootHeight + margin);
        int ddy = dy + ScreenUtils.convertDpToPixel((float)8.0f, (Context)context);
        PropertyValuesHolder y = PropertyValuesHolder.ofFloat((Property)View.Y, (float[])new float[]{ddy, dy});
        PropertyValuesHolder alpha = PropertyValuesHolder.ofFloat((Property)View.ALPHA, (float[])new float[]{this.overlayRoot.getAlpha(), 1.0f});
        PropertyValuesHolder scaleX = PropertyValuesHolder.ofFloat((Property)View.SCALE_X, (float[])new float[]{0.85f, 1.0f - (float)this.position * 0.05f});
        ObjectAnimator.ofPropertyValuesHolder((Object)this.overlayRoot, (PropertyValuesHolder[])new PropertyValuesHolder[]{y, alpha, scaleX}).setDuration(200L).start();
    }

    protected void performReplyPulse(View textContainer, final View text, final Runnable updateEndAction) {
        PropertyValuesHolder scaleX = PropertyValuesHolder.ofFloat((Property)View.SCALE_X, (float[])new float[]{1.0f, 1.05f});
        PropertyValuesHolder scaleY = PropertyValuesHolder.ofFloat((Property)View.SCALE_Y, (float[])new float[]{1.0f, 1.05f});
        ObjectAnimator textBubbleAnimator = ObjectAnimator.ofPropertyValuesHolder((Object)textContainer, (PropertyValuesHolder[])new PropertyValuesHolder[]{scaleX, scaleY}).setDuration(150L);
        textBubbleAnimator.setRepeatCount(1);
        textBubbleAnimator.setRepeatMode(2);
        textBubbleAnimator.start();
        ObjectAnimator fadeOutAnimator = ObjectAnimator.ofFloat((Object)text, (Property)View.ALPHA, (float[])new float[]{1.0f, 0.0f}).setDuration(200L);
        fadeOutAnimator.addListener((Animator.AnimatorListener)new SimpleAnimatorListener(){

            @Override
            public void onAnimationEnd(Animator animation) {
                Overlay.this.updateViewDataDuringReplyPulse();
                ObjectAnimator fadeInAnimator = ObjectAnimator.ofFloat((Object)text, (Property)View.ALPHA, (float[])new float[]{0.0f, 1.0f}).setDuration(200L);
                fadeInAnimator.setStartDelay(100L);
                fadeInAnimator.start();
                fadeInAnimator.addListener((Animator.AnimatorListener)new SimpleAnimatorListener(){

                    @Override
                    public void onAnimationEnd(Animator animation) {
                        updateEndAction.run();
                    }
                });
            }
        });
        fadeOutAnimator.start();
    }

    public void moveForward(ViewGroup root, LayoutInflater inflater) {
        --this.position;
        if (this.position < 0) {
            if (this.overlayRoot != null && this.overlayRoot.getParent() instanceof ViewGroup) {
                ((ViewGroup)this.overlayRoot.getParent()).removeView((View)this.overlayRoot);
            }
        } else if (this.position == 0) {
            this.animateToPosition(root.getContext());
            this.beginListeningForTouchEvents();
        } else if (this.position == 1) {
            this.animateToPosition(root.getContext());
        } else if (this.position == 2) {
            this.display(root, inflater, false);
            this.animateToBackOfStack(root.getContext());
        }
    }

    protected void stopListeningForTouchEvents() {
        this.overlayRoot.setOnTouchListener(null);
    }

    protected void beginListeningForTouchEvents() {
        this.overlayRoot.setOnTouchListener((View.OnTouchListener)this);
    }

    protected View getRootView() {
        return this.overlayRoot;
    }

    protected abstract void onPreviewPressed(View var1);

    protected abstract void onPreviewReleased(View var1);

    public void display(ViewGroup root, Conversation conversation, LayoutInflater inflater, boolean withFullAnimation) {
        this.conversation = conversation;
        this.display(root, inflater, withFullAnimation);
    }

    public abstract void display(ViewGroup var1, LayoutInflater var2, boolean var3);

    public abstract void update(Conversation var1, Runnable var2);

    protected abstract void updateViewDataDuringReplyPulse();

    public void moveBackward(ViewGroup rootView) {
        this.moveBackward(rootView, new SimpleAnimatorListener());
    }

    public abstract void moveBackward(ViewGroup var1, SimpleAnimatorListener var2);
}

