/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.api;

import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.utilities.TimeProvider;
import java.util.concurrent.TimeUnit;

public class RateLimiter {
    private final AppConfig appConfig;
    private long periodStartTimestamp;
    private int limitedRequestCount;

    public RateLimiter(AppConfig appConfig) {
        this.appConfig = appConfig;
    }

    public boolean isLimited() {
        return this.isInsideCurrentTimePeriod() && this.hasExceededMaxCount();
    }

    public void increment() {
        if (!this.isInsideCurrentTimePeriod()) {
            this.periodStartTimestamp = TimeProvider.SYSTEM.currentTimeMillis();
            this.limitedRequestCount = 0;
        }
        ++this.limitedRequestCount;
    }

    boolean hasExceededMaxCount() {
        return this.limitedRequestCount >= this.appConfig.getRateLimitCount();
    }

    boolean isInsideCurrentTimePeriod() {
        long rateLimitPeriodMillis = TimeUnit.SECONDS.toMillis(this.appConfig.getRateLimitPeriod());
        return TimeProvider.SYSTEM.currentTimeMillis() - this.periodStartTimestamp < rateLimitPeriodMillis;
    }

    long getPeriodStartTimestamp() {
        return this.periodStartTimestamp;
    }

    void setPeriodStartTimestamp(long periodStartTimestamp) {
        this.periodStartTimestamp = periodStartTimestamp;
    }

    int getLimitedRequestCount() {
        return this.limitedRequestCount;
    }

    void setLimitedRequestCount(int limitedRequestCount) {
        this.limitedRequestCount = limitedRequestCount;
    }
}

