/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.metrics;

import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.metrics.MetricObject;
import io.intercom.android.sdk.utilities.TimeProvider;

public class NewMetricFactory {
    static final String ACTION_RECEIVED = "received";
    static final String OBJECT_BADGE = "badge";
    static final String PLACE_IN_APP = "in_app";
    static final String CONTEXT_FROM_LAUNCHER = "from_launcher";
    static final String METADATA_BADGE_VALUE = "badge_value";
    private final UserIdentity userIdentity;

    public NewMetricFactory(UserIdentity userIdentity) {
        this.userIdentity = userIdentity;
    }

    public MetricObject receivedNotificationFromBadgeWhenMessengerClosed(String badgeValue) {
        return this.constructMetricObject(ACTION_RECEIVED, OBJECT_BADGE, PLACE_IN_APP, CONTEXT_FROM_LAUNCHER).addMetaData(METADATA_BADGE_VALUE, badgeValue);
    }

    private MetricObject constructMetricObject(String action, String object, String place, String context) {
        return new MetricObject(this.userIdentity.getIntercomId(), action, object, place, context, TimeProvider.SYSTEM);
    }
}

