/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks.views;

import android.annotation.SuppressLint;
import android.content.Context;
import android.support.annotation.ColorInt;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.text.method.MovementMethod;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.blocks.BlockAlignment;
import io.intercom.android.sdk.blocks.StyleType;
import io.intercom.android.sdk.utilities.BlockUtils;
import io.intercom.android.sdk.utilities.ColorUtils;
import io.intercom.android.sdk.utilities.TrackingLinkMovementMethod;

@SuppressLint(value={"ViewConstructor"})
public class ParagraphView
extends TextView {
    private static final int POST_BOTTOM_MARGIN_DP = 24;
    private static final int POST_LINE_SPACING_DP = 4;
    private static final int DEFAULT_LINE_SPACING_DP = 2;
    private final int defaultLineSpacingPx;

    public ParagraphView(Context context, StyleType style, BlockAlignment alignment, @ColorInt int baseColor) {
        super(context);
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        this.defaultLineSpacingPx = (int)TypedValue.applyDimension((int)1, (float)2.0f, (DisplayMetrics)displayMetrics);
        BlockUtils.createLayoutParams((View)this, -2, -2);
        BlockUtils.setDefaultMarginBottom((View)this);
        this.setLineSpacing(this.defaultLineSpacingPx, 1.0f);
        this.setTextSize(2, 16.0f);
        this.setTextIsSelectable(false);
        this.setEllipsize(TextUtils.TruncateAt.END);
        this.setScrollContainer(false);
        this.setFocusable(false);
        this.setClickable(false);
        this.setLongClickable(false);
        this.setGravity(alignment.getGravity());
        ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)this.getLayoutParams();
        switch (style) {
            case ADMIN: {
                this.setMovementMethod((MovementMethod)new TrackingLinkMovementMethod());
                this.setTextColor(ContextCompat.getColor((Context)context, (int)R.color.intercom_text_light_black));
                this.setLinkTextColor(baseColor);
                break;
            }
            case NOTE: 
            case CONTAINER_CARD: {
                this.setMovementMethod((MovementMethod)new TrackingLinkMovementMethod());
                this.setTextColor(ContextCompat.getColor((Context)context, (int)R.color.intercom_grey_700));
                this.setLinkTextColor(baseColor);
                break;
            }
            case POST: {
                DisplayMetrics metrics = context.getResources().getDisplayMetrics();
                float margin = TypedValue.applyDimension((int)1, (float)24.0f, (DisplayMetrics)metrics);
                float lineSpacing = TypedValue.applyDimension((int)1, (float)4.0f, (DisplayMetrics)metrics);
                params.bottomMargin = (int)margin;
                this.setMovementMethod((MovementMethod)new TrackingLinkMovementMethod());
                this.setLineSpacing(lineSpacing, 1.0f);
                this.setTextColor(ContextCompat.getColor((Context)context, (int)R.color.intercom_white));
                this.setLinkTextColor(ColorUtils.lightenColor(baseColor));
                break;
            }
            case CHAT_FULL: {
                this.setTextSize(2, 14.0f);
                this.setTextColor(ContextCompat.getColor((Context)context, (int)R.color.intercom_grey_600));
                this.setLinkTextColor(baseColor);
                break;
            }
            default: {
                params.bottomMargin = 0;
                this.setMovementMethod((MovementMethod)new TrackingLinkMovementMethod());
                this.setIncludeFontPadding(false);
                this.setTextColor(ContextCompat.getColor((Context)context, (int)R.color.intercom_white));
                this.setLinkTextColor(ContextCompat.getColor((Context)context, (int)R.color.intercom_white));
            }
        }
    }
}

