/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.api;

import android.content.Context;
import android.text.TextUtils;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.api.CallbackHolder;
import io.intercom.android.sdk.api.HeaderInterceptor;
import io.intercom.android.sdk.api.IdentityInterceptor;
import io.intercom.android.sdk.api.IntercomApiInterface;
import io.intercom.android.sdk.api.RetryInterceptor;
import io.intercom.android.sdk.commons.utilities.DeviceUtils;
import io.intercom.android.sdk.commons.utilities.StringUtils;
import io.intercom.android.sdk.identity.AppIdentity;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.com.squareup.otto.Bus;
import io.intercom.okhttp3.Cache;
import io.intercom.okhttp3.CertificatePinner;
import io.intercom.okhttp3.Interceptor;
import io.intercom.okhttp3.OkHttpClient;
import io.intercom.retrofit2.Converter;
import io.intercom.retrofit2.Retrofit;
import io.intercom.retrofit2.converter.gson.GsonConverterFactory;
import java.io.File;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class ApiFactory {
    private static final String CACHE_NAME = "Intercom_SDK/HttpCache";
    private static final String PROTOCOL = "https://";
    private static final String PARTIAL_HOSTNAME = ".mobile-sdk-api.intercom.io";
    private static final String ENDPOINT = "/oreo/";
    private static final int CACHE_SIZE = 0xA00000;
    private static final int MAX_DNS_SEGMENT_SIZE = 63;

    public static Api create(Context context, AppIdentity appIdentity, UserIdentity userIdentity, Bus bus, String hostname) {
        OkHttpClient httpClient = ApiFactory.createHttpClient(context, appIdentity, userIdentity);
        IntercomApiInterface intercomApiInterface = ApiFactory.createIntercomApiInterface(httpClient, hostname);
        return new Api(context, appIdentity, userIdentity, bus, httpClient, intercomApiInterface, new CallbackHolder());
    }

    private static OkHttpClient createHttpClient(Context context, AppIdentity appIdentity, UserIdentity userIdentity) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder().readTimeout(2L, TimeUnit.MINUTES).connectTimeout(2L, TimeUnit.MINUTES).writeTimeout(2L, TimeUnit.MINUTES).addInterceptor((Interceptor)new IdentityInterceptor(appIdentity, userIdentity)).addInterceptor((Interceptor)new RetryInterceptor(new RetryInterceptor.Sleeper())).addNetworkInterceptor((Interceptor)HeaderInterceptor.create(context, appIdentity));
        File cacheDirectory = new File(context.getCacheDir().getAbsolutePath(), CACHE_NAME);
        builder.cache(new Cache(cacheDirectory, 0xA00000L));
        String hostname = ApiFactory.getFullHostname(DeviceUtils.getAppVersion((Context)context), appIdentity.getAppId());
        CertificatePinner certificatePinner = new CertificatePinner.Builder().add(hostname, new String[]{"sha1/BiCgk94N+oILO/VULX+wYS6gWKU="}).build();
        builder.certificatePinner(certificatePinner);
        return builder.build();
    }

    private static IntercomApiInterface createIntercomApiInterface(OkHttpClient apiHttpClient, String hostname) {
        return (IntercomApiInterface)new Retrofit.Builder().baseUrl(hostname).client(apiHttpClient).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).build().create(IntercomApiInterface.class);
    }

    public static String getHostname(Context context, AppIdentity appIdentity) {
        return ApiFactory.convertHostnameToUrl(ApiFactory.getFullHostname(DeviceUtils.getAppVersion((Context)context), appIdentity.getAppId()));
    }

    static String convertHostnameToUrl(String hostname) {
        return PROTOCOL + hostname + ENDPOINT;
    }

    static String getFullHostname(String version, String appId) {
        return ApiFactory.createUniqueIdentifier(version, appId) + PARTIAL_HOSTNAME;
    }

    static String createUniqueIdentifier(String version, String appId) {
        String result;
        List tokens = StringUtils.splitOnEmpty((String)version.replaceAll("[^\\d]", ""));
        StringBuilder sb = new StringBuilder(appId);
        sb.append("-android");
        if (!tokens.isEmpty()) {
            sb.append('-').append(TextUtils.join((CharSequence)"-", (Iterable)tokens));
        }
        if (sb.length() > 63) {
            int endIndex = 63;
            if (sb.charAt(62) == '-') {
                --endIndex;
            }
            result = sb.substring(0, endIndex);
        } else {
            result = sb.toString();
        }
        return result;
    }
}

