/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.views;

import android.content.Context;
import android.util.AttributeSet;
import android.widget.FrameLayout;
import io.intercom.android.sdk.conversation.UploadProgressListener;
import io.intercom.android.sdk.logger.TwigFactory;
import io.intercom.android.sdk.twig.Twig;
import io.intercom.android.sdk.views.UploadProgressBar;

public class ProgressFrameLayout
extends FrameLayout
implements UploadProgressListener {
    final UploadProgressBar uploadProgressBar;
    private final Twig twig = TwigFactory.getLogger();

    public ProgressFrameLayout(Context context) {
        this(context, null);
    }

    public ProgressFrameLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.uploadProgressBar = new UploadProgressBar(context, attrs);
        this.addView(this.uploadProgressBar);
    }

    @Override
    public void uploadStarted() {
        this.uploadProgressBar.smoothStartAnimation();
    }

    @Override
    public void uploadNotice(final byte percentUploaded) {
        this.twig.internal("progress", "" + percentUploaded);
        this.post(new Runnable(){

            @Override
            public void run() {
                ProgressFrameLayout.this.uploadProgressBar.setProgress(percentUploaded);
                if (percentUploaded == 90) {
                    ProgressFrameLayout.this.uploadProgressBar.smoothEndAnimation();
                }
            }
        });
    }

    @Override
    public void uploadStopped() {
        this.uploadProgressBar.hideBar();
    }
}

