/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.state;

import io.intercom.android.sdk.models.TeamPresence;
import io.intercom.android.sdk.state.HostAppState;
import io.intercom.android.sdk.state.InboxState;
import io.intercom.android.sdk.state.UiState;
import java.util.Set;

public class State {
    private final boolean hasConversations;
    private final UiState uiState;
    private final TeamPresence teamPresence;
    private final Set<String> unreadConversationIds;
    private final InboxState inboxState;
    private final HostAppState hostAppState;

    public State(boolean hasConversations, UiState uiState, TeamPresence teamPresence, Set<String> unreadConversationIds, InboxState inboxState, HostAppState hostAppState) {
        this.hasConversations = hasConversations;
        this.uiState = uiState;
        this.teamPresence = teamPresence;
        this.unreadConversationIds = unreadConversationIds;
        this.inboxState = inboxState;
        this.hostAppState = hostAppState;
    }

    public boolean hasConversations() {
        return this.hasConversations;
    }

    public UiState uiState() {
        return this.uiState;
    }

    public TeamPresence teamPresence() {
        return this.teamPresence;
    }

    public Set<String> unreadConversationIds() {
        return this.unreadConversationIds;
    }

    public InboxState inboxState() {
        return this.inboxState;
    }

    public HostAppState hostAppState() {
        return this.hostAppState;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        State state = (State)o;
        if (this.hasConversations != state.hasConversations) {
            return false;
        }
        if (!this.uiState.equals(state.uiState)) {
            return false;
        }
        if (!this.teamPresence.equals(state.teamPresence)) {
            return false;
        }
        if (!this.unreadConversationIds.equals(state.unreadConversationIds)) {
            return false;
        }
        if (!this.inboxState.equals(state.inboxState)) {
            return false;
        }
        return this.hostAppState.equals(state.hostAppState);
    }

    public int hashCode() {
        int result = this.hasConversations ? 1 : 0;
        result = 31 * result + this.uiState.hashCode();
        result = 31 * result + this.teamPresence.hashCode();
        result = 31 * result + this.unreadConversationIds.hashCode();
        result = 31 * result + this.inboxState.hashCode();
        result = 31 * result + this.hostAppState.hashCode();
        return result;
    }

    public String toString() {
        return "State{hasConversations=" + this.hasConversations + ", uiState=" + this.uiState + ", teamPresence=" + this.teamPresence + ", unreadConversationIds=" + this.unreadConversationIds + ", inboxState=" + this.inboxState + ", hostAppState=" + this.hostAppState + '}';
    }
}

