/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk;

import android.app.Activity;
import android.app.Application;
import android.app.KeyguardManager;
import android.content.Context;
import android.support.annotation.VisibleForTesting;
import io.intercom.android.sdk.ResetManager;
import io.intercom.android.sdk.actions.Actions;
import io.intercom.android.sdk.api.DeDuper;
import io.intercom.android.sdk.api.UserUpdater;
import io.intercom.android.sdk.commons.utilities.TimeProvider;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.metrics.MetricsStore;
import io.intercom.android.sdk.nexus.NexusClient;
import io.intercom.android.sdk.push.SystemNotificationManager;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.store.Selectors;
import io.intercom.android.sdk.store.Store;
import io.intercom.android.sdk.utilities.SimpleActivityLifecycleCallbacks;
import java.util.HashSet;
import java.util.Set;

class LifecycleTracker
extends SimpleActivityLifecycleCallbacks
implements Application.ActivityLifecycleCallbacks {
    private final SystemNotificationManager systemNotificationManager;
    private final Set<String> attachedActivities = new HashSet<String>();
    private final MetricsStore metricsStore;
    private final DeDuper deDuper;
    private final AppConfig.Provider appConfigProvider;
    private final NexusClient nexusClient;
    private final TimeProvider timeProvider;
    private final UserUpdater userUpdater;
    private final Store<State> store;
    private final ResetManager resetManager;

    LifecycleTracker(DeDuper deDuper, MetricsStore metricsStore, NexusClient nexusClient, AppConfig.Provider appConfigProvider, TimeProvider timeProvider, SystemNotificationManager systemNotificationManager, UserUpdater userUpdater, Store<State> store, ResetManager resetManager) {
        this.deDuper = deDuper;
        this.metricsStore = metricsStore;
        this.nexusClient = nexusClient;
        this.appConfigProvider = appConfigProvider;
        this.timeProvider = timeProvider;
        this.systemNotificationManager = systemNotificationManager;
        this.userUpdater = userUpdater;
        this.store = store;
        this.resetManager = resetManager;
    }

    @Override
    public void onActivityStarted(Activity activity) {
        this.attachActivity(activity);
        if (this.store.select(Selectors.APP_IS_BACKGROUNDED).booleanValue()) {
            this.store.dispatch(Actions.appEnteredForeground(this.timeProvider.currentTimeMillis()));
            this.systemNotificationManager.clear();
            this.nexusClient.connect(this.appConfigProvider.getAppConfig().getRealTimeConfig(), true);
        }
    }

    private void attachActivity(Activity activity) {
        this.attachedActivities.add(activity.getClass().getName());
    }

    @Override
    public void onActivityStopped(Activity activity) {
        this.detachActivity(activity);
        if (this.hasApplicationBecomeBackgrounded(activity)) {
            if (this.resetManager.shouldReset()) {
                this.resetManager.hardReset();
            }
            this.store.dispatch(Actions.appEnteredBackground(this.timeProvider.currentTimeMillis()));
            this.deDuper.reset();
            this.userUpdater.submitPendingUpdates();
            this.metricsStore.sendMetrics();
            this.nexusClient.disconnect();
        }
    }

    private void detachActivity(Activity activity) {
        this.attachedActivities.remove(activity.getClass().getName());
    }

    private boolean hasApplicationBecomeBackgrounded(Activity activity) {
        return this.isApplicationInBackground(activity) && this.store.select(Selectors.APP_IS_BACKGROUNDED) == false;
    }

    @VisibleForTesting
    boolean isApplicationInBackground(Activity activity) {
        return LifecycleTracker.isScreenLocked((Context)activity) || this.attachedActivities.isEmpty() && !activity.isChangingConfigurations();
    }

    private static boolean isScreenLocked(Context context) {
        KeyguardManager keyguardManager = (KeyguardManager)context.getSystemService("keyguard");
        return keyguardManager.inKeyguardRestrictedInputMode();
    }
}

