/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks.models;

import android.os.Parcel;
import android.os.Parcelable;
import io.intercom.android.sdk.blocks.BlockType;
import io.intercom.android.sdk.blocks.models.Block;
import io.intercom.android.sdk.blocks.models.Channel;
import java.util.ArrayList;
import java.util.List;

public class NotificationChannelsCard
implements Parcelable {
    private final BlockType type;
    private final String text;
    private final String title;
    private final List<Channel> channels;
    public static final Parcelable.Creator<NotificationChannelsCard> CREATOR = new Parcelable.Creator<NotificationChannelsCard>(){

        public NotificationChannelsCard createFromParcel(Parcel source) {
            return new NotificationChannelsCard(source);
        }

        public NotificationChannelsCard[] newArray(int size) {
            return new NotificationChannelsCard[size];
        }
    };

    NotificationChannelsCard() {
        this(new Builder());
    }

    private NotificationChannelsCard(Builder builder) {
        this.type = builder.type == null ? BlockType.NOTIFICATIONCHANNELSCARD : BlockType.typeValueOf(builder.type);
        this.text = builder.text == null ? "" : builder.text;
        this.title = builder.title == null ? "" : builder.title;
        this.channels = builder.channels == null ? new ArrayList() : builder.channels;
    }

    public static NotificationChannelsCard fromBlock(Block block) {
        if (block == null) {
            return new NotificationChannelsCard();
        }
        Builder builder = new Builder();
        builder.type = block.getType().name();
        builder.title = block.getTitle();
        builder.text = block.getText();
        builder.channels = block.getChannels();
        return new NotificationChannelsCard(builder);
    }

    public BlockType getType() {
        return this.type;
    }

    public String getText() {
        return this.text;
    }

    public String getTitle() {
        return this.title;
    }

    public List<Channel> getChannels() {
        return this.channels;
    }

    public String toString() {
        return "NotificationChannelsCard{type=" + (Object)((Object)this.type) + ", text='" + this.text + '\'' + ", title='" + this.title + '\'' + ", channels=" + this.channels + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NotificationChannelsCard that = (NotificationChannelsCard)o;
        if (this.type != that.type) {
            return false;
        }
        if (this.text != null ? !this.text.equals(that.text) : that.text != null) {
            return false;
        }
        if (this.title != null ? !this.title.equals(that.title) : that.title != null) {
            return false;
        }
        return this.channels != null ? this.channels.equals(that.channels) : that.channels == null;
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + (this.text != null ? this.text.hashCode() : 0);
        result = 31 * result + (this.title != null ? this.title.hashCode() : 0);
        result = 31 * result + (this.channels != null ? this.channels.hashCode() : 0);
        return result;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.type == null ? -1 : this.type.ordinal());
        dest.writeString(this.text);
        dest.writeString(this.title);
        dest.writeTypedList(this.channels);
    }

    protected NotificationChannelsCard(Parcel in) {
        int tmpType = in.readInt();
        this.type = tmpType == -1 ? null : BlockType.values()[tmpType];
        this.text = in.readString();
        this.title = in.readString();
        this.channels = in.createTypedArrayList(Channel.CREATOR);
    }

    public static final class Builder {
        String type;
        String text;
        String title;
        List<Channel> channels;

        public Builder withText(String text) {
            this.text = text;
            return this;
        }

        public Builder withTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder withChannels(List<Channel> channels) {
            this.channels = channels;
            return this;
        }

        public NotificationChannelsCard build() {
            return new NotificationChannelsCard(this);
        }
    }
}

