/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.utilities;

import android.app.Application;
import android.text.TextUtils;
import io.intercom.android.sdk.logger.IntercomLogger;

public class ValidatorUtil {
    private static final String API_PREFIX = "android_sdk-";

    public static boolean isValidConstructorParams(Application application, String apiKey, String appId) {
        boolean isValid = true;
        if (application == null) {
            IntercomLogger.e("The Application passed in was null.We need an Application to enable Intercom in your app");
            isValid = false;
        }
        if (TextUtils.isEmpty((CharSequence)appId)) {
            IntercomLogger.e("The app ID you provided is either null or empty. We need a valid app ID to enable Intercom in your app");
            isValid = false;
        }
        if (!ValidatorUtil.isValidLength(apiKey)) {
            IntercomLogger.e("The API key provided is too short.\nPlease check that you are using an Intercom Android SDK key and have not passed the appId into the apiKey field\n");
            isValid = false;
        }
        if (!ValidatorUtil.hasAndroidKeyPrefix(apiKey)) {
            IntercomLogger.e("The API key provided does not begin with 'android_sdk-'.\nPlease check that you are using an Intercom Android SDK key and have not passed the appId into the apiKey field\n");
            isValid = false;
        }
        return isValid;
    }

    static boolean isValidLength(String apiKey) {
        return apiKey != null && apiKey.length() >= 52;
    }

    static boolean hasAndroidKeyPrefix(String apiKey) {
        return apiKey != null && apiKey.startsWith(API_PREFIX);
    }
}

