/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.models;

import io.intercom.android.sdk.blocks.models.Author;

public class Card {
    private final String type;
    private final String text;
    private final String title;
    private final String description;
    private final String articleId;
    private final Author author;

    public Card() {
        this(new Builder());
    }

    Card(Builder builder) {
        this.type = builder.type == null ? "" : builder.type;
        this.text = builder.text == null ? "" : builder.text;
        this.title = builder.title == null ? "" : builder.title;
        this.description = builder.description == null ? "" : builder.description;
        this.articleId = builder.articleId == null ? "" : builder.articleId;
        this.author = builder.author == null ? new Author.Builder().build() : builder.author.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Card card = (Card)o;
        if (this.articleId != null ? !this.articleId.equals(card.articleId) : card.articleId != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(card.type) : card.type != null) {
            return false;
        }
        if (this.text != null ? !this.text.equals(card.text) : card.text != null) {
            return false;
        }
        if (this.title != null ? !this.title.equals(card.title) : card.title != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(card.description) : card.description != null) {
            return false;
        }
        return this.author != null ? this.author.equals((Object)card.author) : card.author == null;
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + (this.text != null ? this.text.hashCode() : 0);
        result = 31 * result + (this.title != null ? this.title.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.articleId != null ? this.articleId.hashCode() : 0);
        result = 31 * result + (this.author != null ? this.author.hashCode() : 0);
        return result;
    }

    public String getType() {
        return this.type;
    }

    public String getText() {
        return this.text;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public Author getAuthor() {
        return this.author;
    }

    public static final class Builder {
        String type;
        String text;
        String title;
        String description;
        String linkType;
        String articleId;
        Author.Builder author;

        public Card build() {
            return new Card(this);
        }
    }
}

