/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.api;

import android.support.annotation.VisibleForTesting;
import io.intercom.android.sdk.commons.utilities.TimeProvider;
import io.intercom.android.sdk.identity.AppIdentity;
import java.util.HashMap;
import java.util.Map;

public class DeDuper {
    private final Map<String, Object> cachedAttributes = new HashMap<String, Object>();
    private final AppIdentity appIdentity;
    private long earliestUpdateAt = 0L;

    public DeDuper(AppIdentity appIdentity) {
        this.appIdentity = appIdentity;
    }

    public void update(Map<String, ?> newAttributes) {
        if (this.hasExpiredCache()) {
            this.cachedAttributes.clear();
            this.setEarliestUpdateAt(TimeProvider.SYSTEM.currentTimeMillis());
        }
        if (this.earliestUpdateAt == 0L) {
            this.setEarliestUpdateAt(TimeProvider.SYSTEM.currentTimeMillis());
        }
        if (this.shouldMergeCustomAttributes(newAttributes)) {
            this.cachedAttributes.put("custom_attributes", this.mergeCustomAttributes(newAttributes));
            newAttributes.remove("custom_attributes");
        }
        this.cachedAttributes.putAll(newAttributes);
    }

    public boolean shouldUpdateUser(Map<String, ?> newAttributes) {
        return this.isNotDuplicateUpdate(newAttributes) || this.isEmpty() || this.hasExpiredCache();
    }

    public void reset() {
        this.cachedAttributes.clear();
        this.earliestUpdateAt = 0L;
    }

    private boolean isEmpty() {
        return this.cachedAttributes.isEmpty();
    }

    private boolean hasExpiredCache() {
        if (this.earliestUpdateAt == 0L) {
            return false;
        }
        long cacheExpiryMillis = this.appIdentity.getAppConfig().getUserUpdateCacheMaxAgeMs();
        return TimeProvider.SYSTEM.currentTimeMillis() - this.earliestUpdateAt > cacheExpiryMillis;
    }

    private boolean isNotDuplicateUpdate(Map<String, ?> newAttributes) {
        HashMap<String, Object> allAttributes = new HashMap<String, Object>();
        allAttributes.putAll(this.cachedAttributes);
        allAttributes.putAll(newAttributes);
        if (this.shouldMergeCustomAttributes(newAttributes)) {
            allAttributes.put("custom_attributes", this.mergeCustomAttributes(newAttributes));
            newAttributes.remove("custom_attributes");
        }
        return !allAttributes.equals(this.cachedAttributes);
    }

    private boolean shouldMergeCustomAttributes(Map<String, ?> newAttributes) {
        return newAttributes.containsKey("custom_attributes") && newAttributes.get("custom_attributes") instanceof Map && this.cachedAttributes.containsKey("custom_attributes") && this.cachedAttributes.get("custom_attributes") instanceof Map;
    }

    private Map<String, Object> mergeCustomAttributes(Map<String, ?> newAttributes) {
        HashMap<String, Object> allCustomAttributes = new HashMap<String, Object>();
        allCustomAttributes.putAll((Map)newAttributes.get("custom_attributes"));
        allCustomAttributes.putAll((Map)this.cachedAttributes.get("custom_attributes"));
        return allCustomAttributes;
    }

    @VisibleForTesting
    Map<String, Object> getMap() {
        return this.cachedAttributes;
    }

    @VisibleForTesting
    void setEarliestUpdateAt(long time) {
        this.earliestUpdateAt = time;
    }

    @VisibleForTesting
    long getEarliestUpdateAt() {
        return this.earliestUpdateAt;
    }
}

