/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk;

import android.app.Activity;
import android.app.Application;
import android.app.KeyguardManager;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.VisibleForTesting;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.api.DeDuper;
import io.intercom.android.sdk.commons.utilities.TimeProvider;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.logger.IntercomLogger;
import io.intercom.android.sdk.metrics.MetricsStore;
import io.intercom.android.sdk.nexus.NexusClient;
import io.intercom.android.sdk.push.IntercomNotificationManager;
import java.util.HashSet;
import java.util.Set;

public class IntercomLifecycleTracker
implements Application.ActivityLifecycleCallbacks {
    private final IntercomNotificationManager intercomNotificationManager;
    private final Set<String> attachedActivities = new HashSet<String>();
    private final MetricsStore metricsStore;
    private final DeDuper deDuper;
    private final Api.Provider apiProvider;
    private final AppConfig.Provider appConfigProvider;
    private final NexusClient nexusClient;
    private final TimeProvider timeProvider;
    private long enteredBackgroundAt = 0L;
    private boolean backgrounded = true;

    IntercomLifecycleTracker(Api.Provider apiProvider, DeDuper deDuper, MetricsStore metricsStore, NexusClient nexusClient, AppConfig.Provider appConfigProvider, TimeProvider timeProvider, IntercomNotificationManager intercomNotificationManager) {
        this.deDuper = deDuper;
        this.apiProvider = apiProvider;
        this.metricsStore = metricsStore;
        this.nexusClient = nexusClient;
        this.appConfigProvider = appConfigProvider;
        this.timeProvider = timeProvider;
        this.intercomNotificationManager = intercomNotificationManager;
    }

    public boolean isAppBackgrounded() {
        return this.backgrounded;
    }

    private static boolean isScreenLocked(Context context) {
        KeyguardManager keyguardManager = (KeyguardManager)context.getSystemService("keyguard");
        return keyguardManager.inKeyguardRestrictedInputMode();
    }

    private void attachActivity(Activity activity) {
        this.attachedActivities.add(activity.getClass().getName());
    }

    private void detachActivity(Activity activity) {
        this.attachedActivities.remove(activity.getClass().getName());
    }

    @VisibleForTesting
    boolean isApplicationInBackground(Activity activity) {
        return IntercomLifecycleTracker.isScreenLocked((Context)activity) || this.attachedActivities.isEmpty() && !activity.isChangingConfigurations();
    }

    @VisibleForTesting
    boolean hasApplicationBecomeBackgrounded(Activity activity) {
        return this.isApplicationInBackground(activity) && !this.backgrounded;
    }

    private void appEnteredBackground() {
        this.backgrounded = true;
        IntercomLogger.internal("lifecycles", "backgrounded");
        this.nexusClient.disconnect();
        this.enteredBackgroundAt = this.timeProvider.currentTimeMillis();
        this.deDuper.reset();
        this.metricsStore.sendMetrics();
    }

    private void appEnteredForeground() {
        this.backgrounded = false;
        IntercomLogger.internal("lifecycles", "foregrounded");
        long timeDifferenceFromLastBackgrounded = this.timeProvider.currentTimeMillis() - this.enteredBackgroundAt;
        if (timeDifferenceFromLastBackgrounded > this.appConfigProvider.getAppConfig().getNewSessionThresholdMs()) {
            this.apiProvider.getApi().ping(this.backgrounded);
            IntercomLogger.internal("sdk ping", "backgrounded ping from lifecycles");
        }
    }

    public void onActivityCreated(Activity activity, Bundle bundle) {
        IntercomLogger.internal("lifecycles", "on create");
    }

    public void onActivityStarted(Activity activity) {
        IntercomLogger.internal("lifecycles", "on start");
        this.attachActivity(activity);
        if (this.backgrounded) {
            this.appEnteredForeground();
        }
        this.intercomNotificationManager.killNotifications();
        this.nexusClient.connect(this.appConfigProvider.getAppConfig().getRealTimeConfig(), true);
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
    }

    public void onActivityResumed(Activity activity) {
        IntercomLogger.internal("lifecycles", "on resume");
    }

    public void onActivityPaused(Activity activity) {
        IntercomLogger.internal("lifecycles", "on pause");
    }

    public void onActivityStopped(Activity activity) {
        IntercomLogger.internal("lifecycles", "on stop");
        this.detachActivity(activity);
        if (this.hasApplicationBecomeBackgrounded(activity)) {
            this.appEnteredBackground();
        }
    }

    public void onActivityDestroyed(Activity activity) {
        IntercomLogger.internal("lifecycles", "on destroy");
    }
}

