/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.metrics;

import io.intercom.android.sdk.commons.utilities.TimeProvider;
import io.intercom.android.sdk.conversation.ReactionInputView;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.metrics.MetricObject;
import io.intercom.android.sdk.preview.LauncherOpenBehaviour;
import io.intercom.android.sdk.profile.ProfileCoordinator;
import java.util.UUID;

public class MetricFactory {
    static final String NAME_MV3_METRIC = "mv3_metric";
    static final String NAME_EDUCATE_METRIC = "educate_event";
    static final String ACTION_OPENED = "opened";
    static final String ACTION_CLOSED = "closed";
    static final String ACTION_TYPED = "typed";
    static final String ACTION_SENT = "sent";
    static final String ACTION_RECEIVED = "received";
    static final String ACTION_VIEWED = "viewed";
    static final String ACTION_DISMISSED = "dismissed";
    static final String OBJECT_BADGE = "badge";
    static final String OBJECT_CONVERSATION_LIST = "conversation_list";
    static final String OBJECT_CONVERSATION = "conversation";
    static final String OBJECT_NEW_CONVERSATION = "new_conversation";
    static final String OBJECT_MESSENGER = "messenger";
    static final String OBJECT_MESSAGE = "message";
    static final String OBJECT_REPLY = "reply";
    static final String OBJECT_REACTION = "reaction";
    static final String OBJECT_TEAMMATE_PROFILE = "teammate_profile";
    static final String OBJECT_TEAM_PROFILE = "team_profile";
    static final String OBJECT_ARTICLE = "article";
    static final String PLACE_MESSENGER = "messenger";
    static final String PLACE_IN_APP = "in_app";
    static final String PLACE_PUSH = "push";
    static final String CONTEXT_FROM_LAUNCHER = "from_launcher";
    static final String CONTEXT_FROM_CUSTOM_LAUNCHER = "from_custom_launcher";
    static final String CONTEXT_FROM_ANDROID_BACK_BUTTON = "from_android_back_button";
    static final String CONTEXT_FROM_CLOSE_BUTTON = "from_close_button";
    static final String CONTEXT_FROM_CONVERSATION_LIST = "from_conversation_list";
    static final String CONTEXT_IN_NEW_CONVERSATION = "in_new_conversation";
    static final String CONTEXT_FROM_NEW_CONVERSATION = "from_new_conversation";
    static final String CONTEXT_FROM_CONVERSATION = "from_conversation";
    static final String CONTEXT_IN_CONVERSATION = "in_conversation";
    static final String CONTEXT_FROM_SNIPPET = "from_snippet";
    static final String CONTEXT_FROM_FULL = "from_full";
    static final String CONTEXT_FROM_CLICKING = "from_clicking";
    static final String CONTEXT_FROM_SCROLLING = "from_scrolling";
    static final String CONTEXT_FROM_AUTO = "from_auto";
    static final String CONTEXT_FROM_PUSH = "from_push";
    static final String CONTEXT_ON_ARTICLE = "on_article";
    static final String CONTEXT_FROM_TEAMMATE = "from_teammate";
    static final String METADATA_BADGE_VALUE = "badge_value";
    static final String METADATA_IS_ATTACHMENT = "is_attachment";
    static final String METADATA_MESSAGE_ID = "message_id";
    static final String METADATA_CONVERSATION_ID = "conversation_id";
    static final String METADATA_COMMENT_ID = "comment_id";
    static final String METADATA_REACTION_INDEX = "reaction_index";
    static final String METADATA_MESSAGE_TYPE = "message_type";
    static final String METADATA_PUSH_TYPE = "push_type";
    static final String METADATA_HAS_ARTICLE_CARD = "has_article_card";
    static final String VALUE_MESSAGE = "message";
    static final String VALUE_NOTIFICATION = "notification";
    static final String OWNER_MESSENGER = "messenger";
    static final String OWNER_EDUCATE = "educate";
    private final UserIdentity userIdentity;

    public MetricFactory(UserIdentity userIdentity) {
        this.userIdentity = userIdentity;
    }

    public MetricObject openedMessengerConversationList(LauncherOpenBehaviour.LauncherType launcherType) {
        String fromContext = LauncherOpenBehaviour.LauncherType.DEFAULT == launcherType ? CONTEXT_FROM_LAUNCHER : CONTEXT_FROM_CUSTOM_LAUNCHER;
        return this.constructMetricObject(NAME_MV3_METRIC, "messenger", ACTION_OPENED, OBJECT_CONVERSATION_LIST, "messenger", fromContext);
    }

    public MetricObject openedMessengerConversation(String conversationId, LauncherOpenBehaviour.LauncherType launcherType) {
        String fromContext = LauncherOpenBehaviour.LauncherType.DEFAULT == launcherType ? CONTEXT_FROM_LAUNCHER : CONTEXT_FROM_CUSTOM_LAUNCHER;
        return this.constructMetricObject(NAME_MV3_METRIC, "messenger", ACTION_OPENED, OBJECT_CONVERSATION, "messenger", fromContext).addMetaData(METADATA_CONVERSATION_ID, conversationId);
    }

    public MetricObject openedMessengerNewConversation(LauncherOpenBehaviour.LauncherType launcherType) {
        String fromContext = LauncherOpenBehaviour.LauncherType.DEFAULT == launcherType ? CONTEXT_FROM_LAUNCHER : CONTEXT_FROM_CUSTOM_LAUNCHER;
        return this.constructMetricObject(NAME_MV3_METRIC, "messenger", ACTION_OPENED, OBJECT_NEW_CONVERSATION, "messenger", fromContext);
    }

    public MetricObject closedMessengerBackButton() {
        return this.constructMetricObject(NAME_MV3_METRIC, "messenger", ACTION_CLOSED, "messenger", "messenger", CONTEXT_FROM_ANDROID_BACK_BUTTON);
    }

    public MetricObject closedMessengerCloseButton() {
        return this.constructMetricObject(NAME_MV3_METRIC, "messenger", ACTION_CLOSED, "messenger", "messenger", CONTEXT_FROM_CLOSE_BUTTON);
    }

    public MetricObject newConversationFromComposeButton() {
        return this.constructMetricObject(NAME_MV3_METRIC, "messenger", ACTION_OPENED, OBJECT_NEW_CONVERSATION, "messenger", CONTEXT_FROM_CONVERSATION_LIST);
    }

    MetricObject typeInNewConversation() {
        return this.constructMetricObject(NAME_MV3_METRIC, "messenger", ACTION_TYPED, "message", "messenger", CONTEXT_IN_NEW_CONVERSATION);
    }

    MetricObject typeInConversation(String conversationId) {
        return this.constructMetricObject(NAME_MV3_METRIC, "messenger", ACTION_TYPED, OBJECT_REPLY, "messenger", CONTEXT_IN_CONVERSATION).addMetaData(METADATA_CONVERSATION_ID, conversationId);
    }

    public MetricObject sentInNewConversation(boolean isAttachment, String partId, String conversationId) {
        return this.constructMetricObject(NAME_MV3_METRIC, "messenger", ACTION_SENT, "message", "messenger", CONTEXT_IN_NEW_CONVERSATION).addMetaData(METADATA_IS_ATTACHMENT, isAttachment).addMetaData(METADATA_MESSAGE_ID, partId).addMetaData(METADATA_CONVERSATION_ID, conversationId);
    }

    public MetricObject sentInConversation(boolean isAttachment, String partId, String conversationId) {
        return this.constructMetricObject(NAME_MV3_METRIC, "messenger", ACTION_SENT, OBJECT_REPLY, "messenger", CONTEXT_IN_CONVERSATION).addMetaData(METADATA_IS_ATTACHMENT, isAttachment).addMetaData(METADATA_MESSAGE_ID, partId).addMetaData(METADATA_CONVERSATION_ID, conversationId);
    }

    public MetricObject openConversationsListFromNewConversation() {
        return this.constructMetricObject(NAME_MV3_METRIC, "messenger", ACTION_OPENED, OBJECT_CONVERSATION_LIST, "messenger", CONTEXT_FROM_NEW_CONVERSATION);
    }

    public MetricObject startConversation(String conversationId) {
        return this.constructMetricObject(NAME_MV3_METRIC, "messenger", ACTION_OPENED, OBJECT_CONVERSATION, "messenger", CONTEXT_FROM_NEW_CONVERSATION).addMetaData(METADATA_CONVERSATION_ID, conversationId);
    }

    public MetricObject openConversationsListFromConversation(String conversationId) {
        return this.constructMetricObject(NAME_MV3_METRIC, "messenger", ACTION_OPENED, OBJECT_CONVERSATION_LIST, "messenger", CONTEXT_FROM_CONVERSATION).addMetaData(METADATA_CONVERSATION_ID, conversationId);
    }

    public MetricObject openedConversationFromFull(String conversationId, String commentId) {
        return this.constructMetricObject(NAME_MV3_METRIC, "messenger", ACTION_OPENED, OBJECT_CONVERSATION, "messenger", CONTEXT_FROM_FULL).addMetaData(METADATA_COMMENT_ID, commentId).addMetaData(METADATA_CONVERSATION_ID, conversationId);
    }

    public MetricObject openedConversationFromSnippet(String conversationId, String commentId) {
        return this.constructMetricObject(NAME_MV3_METRIC, "messenger", ACTION_OPENED, OBJECT_CONVERSATION, "messenger", CONTEXT_FROM_SNIPPET).addMetaData(METADATA_COMMENT_ID, commentId).addMetaData(METADATA_CONVERSATION_ID, conversationId);
    }

    public MetricObject receivedReply(boolean isAttachment, boolean hasArticle, String partId, String conversationId) {
        return this.constructMetricObject(NAME_MV3_METRIC, "messenger", ACTION_RECEIVED, OBJECT_REPLY, "messenger", CONTEXT_IN_CONVERSATION).addMetaData(METADATA_IS_ATTACHMENT, isAttachment).addMetaData(METADATA_HAS_ARTICLE_CARD, hasArticle).addMetaData(METADATA_COMMENT_ID, partId).addMetaData(METADATA_CONVERSATION_ID, conversationId);
    }

    public MetricObject sentReaction(String conversationId, String messageId, int reactionIndex, ReactionInputView.ReactionLocation reactionLocation) {
        if (ReactionInputView.ReactionLocation.CONVERSATION == reactionLocation) {
            return this.constructMetricObject(NAME_MV3_METRIC, "messenger", ACTION_SENT, OBJECT_REACTION, "messenger", CONTEXT_IN_CONVERSATION).addMetaData(METADATA_MESSAGE_ID, messageId).addMetaData(METADATA_REACTION_INDEX, reactionIndex).addMetaData(METADATA_CONVERSATION_ID, conversationId);
        }
        if (ReactionInputView.ReactionLocation.LINK == reactionLocation) {
            return this.constructMetricObject(NAME_EDUCATE_METRIC, OWNER_EDUCATE, ACTION_SENT, OBJECT_REACTION, "messenger", CONTEXT_ON_ARTICLE).addMetaData(METADATA_MESSAGE_ID, messageId).addMetaData(METADATA_CONVERSATION_ID, conversationId);
        }
        return this.constructMetricObject(NAME_MV3_METRIC, "messenger", ACTION_SENT, OBJECT_REACTION, PLACE_IN_APP, CONTEXT_FROM_FULL).addMetaData(METADATA_MESSAGE_ID, messageId).addMetaData(METADATA_CONVERSATION_ID, conversationId);
    }

    public MetricObject profileClickedOpen(String conversationId, ProfileCoordinator.ProfileType profileType) {
        String profileObject = ProfileCoordinator.ProfileType.TEAMMATE == profileType ? OBJECT_TEAMMATE_PROFILE : OBJECT_TEAM_PROFILE;
        return this.constructMetricObject(NAME_MV3_METRIC, "messenger", ACTION_OPENED, profileObject, "messenger", CONTEXT_FROM_CLICKING).addMetaData(METADATA_CONVERSATION_ID, conversationId);
    }

    public MetricObject profileAutoOpen(String conversationId, ProfileCoordinator.ProfileType profileType) {
        String profileObject = ProfileCoordinator.ProfileType.TEAMMATE == profileType ? OBJECT_TEAMMATE_PROFILE : OBJECT_TEAM_PROFILE;
        return this.constructMetricObject(NAME_MV3_METRIC, "messenger", ACTION_OPENED, profileObject, "messenger", CONTEXT_FROM_AUTO).addMetaData(METADATA_CONVERSATION_ID, conversationId);
    }

    public MetricObject profileScrolledOpen(String conversationId, ProfileCoordinator.ProfileType profileType) {
        String profileObject = ProfileCoordinator.ProfileType.TEAMMATE == profileType ? OBJECT_TEAMMATE_PROFILE : OBJECT_TEAM_PROFILE;
        return this.constructMetricObject(NAME_MV3_METRIC, "messenger", ACTION_OPENED, profileObject, "messenger", CONTEXT_FROM_SCROLLING).addMetaData(METADATA_CONVERSATION_ID, conversationId);
    }

    public MetricObject openConversationFromConversationList(String conversationId) {
        return this.constructMetricObject(NAME_MV3_METRIC, "messenger", ACTION_OPENED, OBJECT_CONVERSATION, "messenger", CONTEXT_FROM_CONVERSATION_LIST).addMetaData(METADATA_CONVERSATION_ID, conversationId);
    }

    public MetricObject viewedPushNotification(String conversationId) {
        return this.constructMetricObject(NAME_MV3_METRIC, "messenger", ACTION_VIEWED, "message", PLACE_IN_APP, CONTEXT_FROM_PUSH).addMetaData(METADATA_CONVERSATION_ID, conversationId).addMetaData(METADATA_PUSH_TYPE, VALUE_NOTIFICATION);
    }

    public MetricObject openedPushOnlyNotification(String conversationId) {
        return this.constructMetricObject(NAME_MV3_METRIC, "messenger", ACTION_OPENED, "message", PLACE_IN_APP, CONTEXT_FROM_PUSH).addMetaData(METADATA_CONVERSATION_ID, conversationId).addMetaData(METADATA_PUSH_TYPE, "message");
    }

    public MetricObject dismissedPushNotification(String conversationId, boolean isPushOnly) {
        String pushType = isPushOnly ? "message" : VALUE_NOTIFICATION;
        return this.constructMetricObject(NAME_MV3_METRIC, "messenger", ACTION_DISMISSED, "message", PLACE_IN_APP, CONTEXT_FROM_PUSH).addMetaData(METADATA_CONVERSATION_ID, conversationId).addMetaData(METADATA_PUSH_TYPE, pushType);
    }

    public MetricObject receivedMessageFromSnippetWhenClosed(boolean isAttachment, boolean hasArticle, String conversationId, String messageId, String messageStyle) {
        return this.constructMetricObject(NAME_MV3_METRIC, "messenger", ACTION_RECEIVED, "message", PLACE_IN_APP, CONTEXT_FROM_SNIPPET).addMetaData(METADATA_CONVERSATION_ID, conversationId).addMetaData(METADATA_MESSAGE_ID, messageId).addMetaData(METADATA_MESSAGE_TYPE, messageStyle).addMetaData(METADATA_IS_ATTACHMENT, isAttachment).addMetaData(METADATA_HAS_ARTICLE_CARD, hasArticle);
    }

    public MetricObject receivedReplyFromSnippetWhenClosed(boolean isAttachment, boolean hasArticle, String conversationId, String commentId) {
        return this.constructMetricObject(NAME_MV3_METRIC, "messenger", ACTION_RECEIVED, OBJECT_REPLY, PLACE_IN_APP, CONTEXT_FROM_SNIPPET).addMetaData(METADATA_CONVERSATION_ID, conversationId).addMetaData(METADATA_COMMENT_ID, commentId).addMetaData(METADATA_IS_ATTACHMENT, isAttachment).addMetaData(METADATA_HAS_ARTICLE_CARD, hasArticle);
    }

    public MetricObject receivedMessageFromFullWhenClosed(boolean isAttachment, boolean hasArticle, String conversationId, String messageId, String messageStyle) {
        return this.constructMetricObject(NAME_MV3_METRIC, "messenger", ACTION_RECEIVED, "message", PLACE_IN_APP, CONTEXT_FROM_FULL).addMetaData(METADATA_CONVERSATION_ID, conversationId).addMetaData(METADATA_MESSAGE_ID, messageId).addMetaData(METADATA_MESSAGE_TYPE, messageStyle).addMetaData(METADATA_IS_ATTACHMENT, isAttachment).addMetaData(METADATA_HAS_ARTICLE_CARD, hasArticle);
    }

    public MetricObject dismissInAppMessageSnippet(String conversationId, String messageId) {
        return this.constructMetricObject(NAME_MV3_METRIC, "messenger", ACTION_DISMISSED, "message", PLACE_IN_APP, CONTEXT_FROM_SNIPPET).addMetaData(METADATA_CONVERSATION_ID, conversationId).addMetaData(METADATA_MESSAGE_ID, messageId);
    }

    public MetricObject dismissInAppCommentSnippet(String conversationId, String commentId) {
        return this.constructMetricObject(NAME_MV3_METRIC, "messenger", ACTION_DISMISSED, OBJECT_REPLY, PLACE_IN_APP, CONTEXT_FROM_SNIPPET).addMetaData(METADATA_CONVERSATION_ID, conversationId).addMetaData(METADATA_COMMENT_ID, commentId);
    }

    public MetricObject viewedInAppFromFull(String conversationId, String messageId) {
        return this.constructMetricObject(NAME_MV3_METRIC, "messenger", ACTION_VIEWED, "message", PLACE_IN_APP, CONTEXT_FROM_FULL).addMetaData(METADATA_MESSAGE_ID, messageId).addMetaData(METADATA_CONVERSATION_ID, conversationId);
    }

    public MetricObject viewedInAppFromMessenger(String conversationId, String messageId) {
        return this.constructMetricObject(NAME_MV3_METRIC, "messenger", ACTION_VIEWED, "message", "messenger", CONTEXT_FROM_FULL).addMetaData(METADATA_MESSAGE_ID, messageId).addMetaData(METADATA_CONVERSATION_ID, conversationId);
    }

    public MetricObject viewedInAppFromSnippet(String conversationId, String messageId) {
        return this.constructMetricObject(NAME_MV3_METRIC, "messenger", ACTION_VIEWED, "message", PLACE_IN_APP, CONTEXT_FROM_SNIPPET).addMetaData(METADATA_MESSAGE_ID, messageId).addMetaData(METADATA_CONVERSATION_ID, conversationId);
    }

    public MetricObject closedInAppFromFull(String conversationId, String messageId) {
        return this.constructMetricObject(NAME_MV3_METRIC, "messenger", ACTION_CLOSED, "message", PLACE_IN_APP, CONTEXT_FROM_FULL).addMetaData(METADATA_MESSAGE_ID, messageId).addMetaData(METADATA_CONVERSATION_ID, conversationId);
    }

    public MetricObject receivedPushNotification(String conversationId) {
        return this.constructMetricObject(NAME_MV3_METRIC, "messenger", ACTION_RECEIVED, "message", PLACE_PUSH, CONTEXT_FROM_PUSH).addMetaData(METADATA_CONVERSATION_ID, conversationId).addMetaData(METADATA_PUSH_TYPE, VALUE_NOTIFICATION);
    }

    public MetricObject receivedPushOnlyNotification(String conversationId) {
        return this.constructMetricObject(NAME_MV3_METRIC, "messenger", ACTION_RECEIVED, "message", PLACE_PUSH, CONTEXT_FROM_PUSH).addMetaData(METADATA_CONVERSATION_ID, conversationId).addMetaData(METADATA_PUSH_TYPE, "message");
    }

    public MetricObject receivedNotificationFromBadgeWhenMessengerClosed(String badgeValue) {
        return this.constructMetricObject(NAME_MV3_METRIC, "messenger", ACTION_RECEIVED, OBJECT_BADGE, PLACE_IN_APP, CONTEXT_FROM_LAUNCHER).addMetaData(METADATA_BADGE_VALUE, badgeValue);
    }

    public MetricObject viewedArticle(String conversationId, String messageId) {
        return this.constructMetricObject(NAME_EDUCATE_METRIC, OWNER_EDUCATE, ACTION_VIEWED, OBJECT_ARTICLE, "messenger", CONTEXT_FROM_CONVERSATION).addMetaData(METADATA_MESSAGE_ID, messageId).addMetaData(METADATA_CONVERSATION_ID, conversationId);
    }

    public MetricObject closedArticle(String conversationId, String messageId, boolean pressedDismiss) {
        String context = pressedDismiss ? CONTEXT_FROM_CLOSE_BUTTON : CONTEXT_FROM_ANDROID_BACK_BUTTON;
        return this.constructMetricObject(NAME_EDUCATE_METRIC, OWNER_EDUCATE, ACTION_CLOSED, OBJECT_ARTICLE, "messenger", context).addMetaData(METADATA_MESSAGE_ID, messageId).addMetaData(METADATA_CONVERSATION_ID, conversationId);
    }

    private MetricObject constructMetricObject(String name, String owner, String action, String object, String place, String context) {
        return new MetricObject(name, owner, UUID.randomUUID().toString(), this.userIdentity.getIntercomId(), action, object, place, context, TimeProvider.SYSTEM);
    }
}

