/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.state;

import android.support.annotation.NonNull;
import io.intercom.android.sdk.models.TeamPresence;
import io.intercom.android.sdk.state.InboxState;
import io.intercom.android.sdk.state.UiState;
import java.util.Set;

public class State {
    private final boolean hasConversations;
    @NonNull
    private final UiState currentUiState;
    @NonNull
    private final TeamPresence teamPresence;
    @NonNull
    private final Set<String> unreadConversationIds;
    @NonNull
    private final InboxState inboxState;

    public State(boolean hasConversations, @NonNull UiState currentUiState, @NonNull TeamPresence teamPresence, @NonNull Set<String> unreadConversationIds, @NonNull InboxState inboxState) {
        this.hasConversations = hasConversations;
        this.currentUiState = currentUiState;
        this.teamPresence = teamPresence;
        this.unreadConversationIds = unreadConversationIds;
        this.inboxState = inboxState;
    }

    public boolean hasConversations() {
        return this.hasConversations;
    }

    @NonNull
    public UiState uiState() {
        return this.currentUiState;
    }

    @NonNull
    public TeamPresence teamPresence() {
        return this.teamPresence;
    }

    @NonNull
    public Set<String> unreadConversationIds() {
        return this.unreadConversationIds;
    }

    @NonNull
    public InboxState inboxState() {
        return this.inboxState;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        State state = (State)o;
        if (this.hasConversations != state.hasConversations) {
            return false;
        }
        if (!this.currentUiState.equals(state.currentUiState)) {
            return false;
        }
        if (!this.teamPresence.equals(state.teamPresence)) {
            return false;
        }
        if (!this.unreadConversationIds.equals(state.unreadConversationIds)) {
            return false;
        }
        return this.inboxState.equals(state.inboxState);
    }

    public int hashCode() {
        int result = this.hasConversations ? 1 : 0;
        result = 31 * result + this.currentUiState.hashCode();
        result = 31 * result + this.teamPresence.hashCode();
        result = 31 * result + this.unreadConversationIds.hashCode();
        result = 31 * result + this.inboxState.hashCode();
        return result;
    }

    public String toString() {
        return "State{hasConversations=" + this.hasConversations + ", currentUiState=" + this.currentUiState + ", teamPresence=" + this.teamPresence + ", unreadConversationIds=" + this.unreadConversationIds + ", inboxState=" + this.inboxState + '}';
    }
}

