/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.models;

import android.support.annotation.NonNull;
import io.intercom.android.sdk.commons.utilities.CollectionUtils;
import io.intercom.android.sdk.models.Participant;
import java.util.ArrayList;
import java.util.List;

public class TeamPresence {
    @NonNull
    private final List<Participant> activeAdmins;
    @NonNull
    private final String expectedResponseDelay;

    TeamPresence(Builder builder) {
        this.activeAdmins = new ArrayList<Participant>(CollectionUtils.capacityFor(builder.active_admins));
        if (builder.active_admins != null) {
            for (Participant.Builder participantBuilder : builder.active_admins) {
                if (participantBuilder == null) continue;
                this.activeAdmins.add(participantBuilder.build());
            }
        }
        this.expectedResponseDelay = builder.expected_response_delay == null ? "" : builder.expected_response_delay;
    }

    @NonNull
    public List<Participant> getActiveAdmins() {
        return this.activeAdmins;
    }

    public boolean isEmpty() {
        return this.activeAdmins.isEmpty() && this.expectedResponseDelay.isEmpty();
    }

    @NonNull
    public String getExpectedResponseDelay() {
        return this.expectedResponseDelay;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TeamPresence that = (TeamPresence)o;
        if (!this.activeAdmins.equals(that.activeAdmins)) {
            return false;
        }
        return this.expectedResponseDelay.equals(that.expectedResponseDelay);
    }

    public int hashCode() {
        int result = this.activeAdmins.hashCode();
        result = 31 * result + this.expectedResponseDelay.hashCode();
        return result;
    }

    public static final class Builder {
        List<Participant.Builder> active_admins;
        String expected_response_delay;

        public TeamPresence build() {
            return new TeamPresence(this);
        }
    }
}

