/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.attachments;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.AsyncTask;
import android.support.annotation.DrawableRes;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.attachments.AttachmentActivity;
import io.intercom.android.sdk.attachments.AttachmentData;
import io.intercom.android.sdk.attachments.EglUtils;
import io.intercom.android.sdk.utilities.ImageUtils;

class AttachmentPresenter {
    private static final int MAX_UPLOAD_SIZE = 0x2800000;
    private final AttachmentActivity activity;
    private AttachmentData data;
    private boolean openGlEnabled = true;

    public AttachmentPresenter(AttachmentActivity activity) {
        this.activity = activity;
    }

    public void loadFile(Uri attachmentUri, boolean isHardwareAccelerated) {
        this.openGlEnabled = isHardwareAccelerated;
        new LoadFileTask().execute(new Uri[]{attachmentUri});
    }

    public void sendClicked() {
        if (this.data.getSize() == 0L) {
            this.activity.showAlertDialog(R.string.intercom_file_failed);
        } else if (this.data.getSize() >= 0x2800000L) {
            this.activity.showAlertDialog(R.string.intercom_file_too_big);
        } else {
            Intent output = new Intent();
            output.setData(this.data.getUri());
            this.activity.setResult(-1, output);
            this.activity.finish();
        }
    }

    public void cancelClicked() {
        this.activity.setResult(0);
        this.activity.finish();
    }

    public void imageFailedToLoad() {
        this.activity.displayAttachmentDetails(this.data.getFileName(), this.data.getSize(), this.findImageDrawable(this.data.getMimeType()));
    }

    @DrawableRes
    private int findImageDrawable(String mimeType) {
        if (mimeType.contains("image")) {
            return R.drawable.intercom_image_attachment;
        }
        if (mimeType.contains("video")) {
            return R.drawable.intercom_video_attachment;
        }
        if (mimeType.contains("audio")) {
            return R.drawable.intercom_audio_attachment;
        }
        return R.drawable.intercom_generic_attachment;
    }

    private class LoadFileTask
    extends AsyncTask<Uri, Void, AttachmentData> {
        private LoadFileTask() {
        }

        protected AttachmentData doInBackground(Uri ... attachmentUri) {
            AttachmentData attachmentData;
            try {
                attachmentData = new AttachmentData(attachmentUri[0], "", (Context)AttachmentPresenter.this.activity);
            }
            catch (Exception e) {
                attachmentData = null;
            }
            return attachmentData;
        }

        protected void onPostExecute(AttachmentData data) {
            if (data == null) {
                AttachmentPresenter.this.activity.displayFailedAttachment();
            } else {
                AttachmentPresenter.this.data = data;
                int width = data.getImageWidth();
                int height = data.getImageHeight();
                int eglMaxTextureSize = EglUtils.getEglMaxTextureSize();
                if (data.getMimeType().contains("image")) {
                    AttachmentPresenter.this.activity.displayImage(data.getFile(), ImageUtils.getBoundedWidth(width, height, eglMaxTextureSize, AttachmentPresenter.this.openGlEnabled), ImageUtils.getBoundedHeight(width, height, eglMaxTextureSize, AttachmentPresenter.this.openGlEnabled));
                } else {
                    int drawable2 = AttachmentPresenter.this.findImageDrawable(data.getMimeType());
                    AttachmentPresenter.this.activity.displayAttachmentDetails(data.getFileName(), data.getSize(), drawable2);
                }
                AttachmentPresenter.this.activity.enableSendButton();
            }
        }
    }
}

