/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.nexus;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import io.intercom.android.sdk.nexus.NexusEventType;
import java.util.UUID;
import org.json.JSONObject;

public class NexusEvent {
    static final String EVENT_GUID = "eventGuid";
    static final String EVENT_DATA = "eventData";
    static final String EVENT_NAME = "eventName";
    static final String ADMIN_ID = "adminId";
    static final String ADMIN_NAME = "adminName";
    static final String ADMIN_AVATAR = "adminAvatar";
    static final String ADMIN_TIMESTAMP = "adminTimestamp";
    static final String NX_TO_USER = "nx.ToUser";
    static final String NX_FROM_USER = "nx.FromUser";
    static final String CONVERSATION_ID = "conversationId";
    static final String ASSIGNEE_ID = "assigneeId";
    @NonNull
    private final NexusEventType eventType;
    @Nullable
    private final String guid;
    @Nullable
    private final String adminId;
    @Nullable
    private final String adminName;
    @Nullable
    private final String userId;
    @Nullable
    private final String conversationId;
    @Nullable
    private final String assigneeId;
    @Nullable
    private final String adminAvatarUrl;
    private final long adminTimestamp;

    public NexusEvent(Builder builder) {
        this.guid = UUID.randomUUID().toString();
        this.eventType = builder.eventName;
        this.conversationId = builder.conversationId;
        this.assigneeId = builder.assigneeId;
        this.adminName = builder.adminName;
        this.adminId = builder.adminId;
        this.adminAvatarUrl = builder.adminAvatarUrl;
        this.adminTimestamp = builder.adminTimestamp;
        this.userId = builder.userId;
    }

    public NexusEvent(JSONObject jsonObject) {
        this.eventType = NexusEventType.safeValueOf(jsonObject.optString(EVENT_NAME));
        this.guid = jsonObject.optString(EVENT_GUID);
        JSONObject eventData = jsonObject.optJSONObject(EVENT_DATA);
        this.conversationId = eventData != null && eventData.has(CONVERSATION_ID) ? eventData.optString(CONVERSATION_ID) : jsonObject.optString(EVENT_DATA);
        if (eventData != null) {
            this.adminId = eventData.optString(ADMIN_ID);
            this.adminName = eventData.optString(ADMIN_NAME);
            this.adminAvatarUrl = eventData.optString(ADMIN_AVATAR);
            this.adminTimestamp = eventData.optLong(ADMIN_TIMESTAMP, -1L);
            this.assigneeId = eventData.optString(ASSIGNEE_ID);
        } else {
            this.adminId = null;
            this.adminName = null;
            this.adminAvatarUrl = null;
            this.adminTimestamp = -1L;
            this.assigneeId = null;
        }
        this.userId = jsonObject.has(NX_TO_USER) ? jsonObject.optString(NX_TO_USER) : jsonObject.optString(NX_FROM_USER);
    }

    public String toStringEncodedJsonObject() {
        return this.eventType.toStringEncodedJsonObject(this);
    }

    @NonNull
    public NexusEventType getEventType() {
        return this.eventType;
    }

    @NonNull
    public String getGuid() {
        return this.guid != null ? this.guid : "";
    }

    @NonNull
    public String getUserId() {
        return this.userId != null ? this.userId : "";
    }

    @NonNull
    public String getConversationId() {
        return this.conversationId != null ? this.conversationId : "";
    }

    @NonNull
    public String getAssigneeId() {
        return this.assigneeId != null ? this.assigneeId : "";
    }

    @NonNull
    public String getAdminId() {
        return this.adminId != null ? this.adminId : "";
    }

    @NonNull
    public String getAdminName() {
        return this.adminName != null ? this.adminName : "";
    }

    @NonNull
    public String getAdminAvatarUrl() {
        return this.adminAvatarUrl != null ? this.adminAvatarUrl : "";
    }

    public long getAdminTimestamp() {
        return this.adminTimestamp;
    }

    public static NexusEvent getAdminIsTypingEvent(String conversationId, String adminId, String adminName, String adminAvatarUrl, String userId) {
        return new Builder(NexusEventType.AdminIsTyping).withAdminId(adminId).withConversationId(conversationId).withAdminName(adminName).withAdminAvatarUrl(adminAvatarUrl).withUserId(userId).build();
    }

    public static NexusEvent getAdminIsTypingNoteEvent(String conversationId, String adminId, String adminName, String adminAvatarUrl, String userId) {
        return new Builder(NexusEventType.AdminIsTypingANote).withAdminId(adminId).withConversationId(conversationId).withAdminName(adminName).withAdminAvatarUrl(adminAvatarUrl).withUserId(userId).build();
    }

    public static NexusEvent getUserIsTypingEvent(String conversationId, String userId) {
        return new Builder(NexusEventType.UserIsTyping).withConversationId(conversationId).withUserId(userId).build();
    }

    public static NexusEvent getConversationSeenEvent(String conversationId, String userId) {
        return new Builder(NexusEventType.ConversationSeen).withConversationId(conversationId).withUserId(userId).build();
    }

    public static NexusEvent getConversationSeenAdminEvent(String conversationId, String userId) {
        return new Builder(NexusEventType.UserContentSeenByAdmin).withConversationId(conversationId).withUserId(userId).build();
    }

    public static NexusEvent getNewCommentEvent(String conversationId, String userId) {
        return new Builder(NexusEventType.NewComment).withConversationId(conversationId).withUserId(userId).build();
    }

    public static NexusEvent getNewNoteEvent(String conversationId, String adminId) {
        return new Builder(NexusEventType.NewNote).withAdminId(adminId).withConversationId(conversationId).build();
    }

    public static NexusEvent getCreateConversationEvent(String conversationId, String userId) {
        return new Builder(NexusEventType.CreateConversation).withConversationId(conversationId).withUserId(userId).build();
    }

    public static NexusEvent getConversationAssignedEvent(String conversationId, String adminId, String assigneeId) {
        return new Builder(NexusEventType.ConversationAssigned).withAdminId(adminId).withConversationId(conversationId).withAssigneeId(assigneeId).build();
    }

    public static NexusEvent getConversationClosedEvent(String conversationId, String adminId) {
        return new Builder(NexusEventType.ConversationClosed).withAdminId(adminId).withConversationId(conversationId).build();
    }

    public static NexusEvent getConversationReopenedEvent(String conversationId, String adminId) {
        return new Builder(NexusEventType.ConversationReopened).withAdminId(adminId).withConversationId(conversationId).build();
    }

    public static NexusEvent getUserPresenceEvent() {
        return new Builder(NexusEventType.UserPresence).build();
    }

    static class Builder {
        @NonNull
        NexusEventType eventName;
        @Nullable
        String adminId;
        @Nullable
        String adminName;
        @Nullable
        String userId;
        @Nullable
        String conversationId;
        @Nullable
        String assigneeId;
        @Nullable
        String adminAvatarUrl;
        long adminTimestamp = -1L;

        Builder(@NonNull NexusEventType name) {
            this.eventName = name;
        }

        public Builder withAdminId(String adminId) {
            this.adminId = adminId;
            return this;
        }

        public Builder withAdminName(String adminName) {
            this.adminName = adminName;
            return this;
        }

        public Builder withAdminAvatarUrl(String adminAvatarUrl) {
            this.adminAvatarUrl = adminAvatarUrl;
            return this;
        }

        public Builder withAdminTimeStamp(long adminTimeStamp) {
            this.adminTimestamp = adminTimeStamp;
            return this;
        }

        public Builder withUserId(String userId) {
            this.userId = userId;
            return this;
        }

        public Builder withConversationId(String conversationId) {
            this.conversationId = conversationId;
            return this;
        }

        public Builder withAssigneeId(String assigneeId) {
            this.assigneeId = assigneeId;
            return this;
        }

        public NexusEvent build() {
            return new NexusEvent(this);
        }
    }
}

