/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.utilities;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.widget.ImageView;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.models.Avatar;
import io.intercom.android.sdk.transforms.RoundTransform;
import io.intercom.android.sdk.utilities.ImageUtils;
import io.intercom.android.sdk.views.AvatarDefaultDrawable;
import io.intercom.android.sdk.views.AvatarInitialsDrawable;
import io.intercom.com.bumptech.glide.Glide;
import io.intercom.com.bumptech.glide.load.Transformation;
import io.intercom.com.bumptech.glide.request.animation.GlideAnimation;
import io.intercom.com.bumptech.glide.request.target.SimpleTarget;
import io.intercom.com.bumptech.glide.request.target.Target;
import java.io.File;

public class AvatarUtils {
    public static void preloadAvatar(Avatar avatar, Context context, final Runnable runnable) {
        if (avatar.getImageUrl().isEmpty()) {
            runnable.run();
        } else {
            Glide.with((Context)context).load(avatar.getImageUrl()).downloadOnly((Target)new SimpleTarget<File>(){

                public void onResourceReady(File resource, GlideAnimation<? super File> animation) {
                    runnable.run();
                }

                public void onLoadFailed(Exception e, Drawable errorDrawable) {
                    super.onLoadFailed(e, errorDrawable);
                    runnable.run();
                }
            });
        }
    }

    public static void loadAvatarIntoView(Avatar avatar, ImageView imageView) {
        Context context = imageView.getContext();
        Drawable backupDrawable = avatar.getInitials().isEmpty() ? AvatarUtils.getDefaultDrawable(context) : AvatarUtils.getInitialsDrawable(avatar.getInitials());
        Glide.with((Context)context).load(avatar.getImageUrl()).placeholder(backupDrawable).error(backupDrawable).diskCacheStrategy(ImageUtils.getDiskCacheStrategy(avatar.getImageUrl())).bitmapTransform(new Transformation[]{new RoundTransform(context)}).into(imageView);
    }

    @NonNull
    public static AvatarInitialsDrawable getInitialsDrawable(String initials) {
        int baseColorDark = Injector.get().getAppIdentity().getAppConfig().getBaseColorDark();
        return new AvatarInitialsDrawable(initials, baseColorDark);
    }

    @NonNull
    public static AvatarDefaultDrawable getDefaultDrawable(Context context) {
        int baseColorDark = Injector.get().getAppIdentity().getAppConfig().getBaseColorDark();
        return new AvatarDefaultDrawable(context, baseColorDark);
    }
}

