/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.push;

import android.content.Intent;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import io.intercom.android.sdk.logger.IntercomLogger;

class PushBroadcast {
    private final Uri pushData;
    private final String pushOnlyId;

    PushBroadcast() {
        this.pushData = Uri.EMPTY;
        this.pushOnlyId = "";
    }

    PushBroadcast(Intent intent) {
        String uriPushOnlyId = intent.getStringExtra("push_only_convo_id");
        if (TextUtils.isEmpty((CharSequence)uriPushOnlyId)) {
            IntercomLogger.internal("The uri had no push only id");
            this.pushOnlyId = "";
        } else {
            this.pushOnlyId = uriPushOnlyId;
        }
        Uri data = intent.getData();
        if (data == null) {
            IntercomLogger.internal("The uri had no push data");
            this.pushData = Uri.EMPTY;
        } else {
            this.pushData = data;
        }
    }

    @NonNull
    Uri getPushData() {
        return this.pushData;
    }

    @NonNull
    String getPushOnlyId() {
        return this.pushOnlyId;
    }

    boolean isEmpty() {
        return Uri.EMPTY.equals((Object)this.pushData) && this.pushOnlyId.isEmpty();
    }

    boolean hasPushOnlyId() {
        return !TextUtils.isEmpty((CharSequence)this.pushOnlyId);
    }
}

