/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.models;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import io.intercom.android.sdk.blocks.BlockType;
import io.intercom.android.sdk.blocks.models.Block;
import io.intercom.android.sdk.models.Attachments;
import io.intercom.android.sdk.models.Participant;
import io.intercom.android.sdk.models.ReactionReply;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public class Part
implements Parcelable {
    public static final String POST_MESSAGE_STYLE = "post";
    public static final String NOTE_MESSAGE_STYLE = "note";
    public static final String LEGACY_ANNOUNCEMENT_STYLE = "announcement";
    public static final String LEGACY_SMALL_ANNOUNCEMENT_STYLE = "small-announcement";
    public static final String CHAT_MESSAGE_STYLE = "chat";
    public static final String ADMIN_IS_TYPING_STYLE = "admin_is_typing_style";
    public static final String DAY_DIVIDER_STYLE = "day_divider_style";
    public static final String LOADING_LAYOUT = "loading_layout_style";
    private final String id;
    private final List<Attachments> attachments;
    private final String summary;
    private final ReactionReply reactionReply;
    private final boolean isInitialMessage;
    private List<Block> blocks;
    private String participantId;
    private String messageStyle;
    private boolean participantIsAdmin;
    private long createdAt;
    private DeliveryOption deliveryOption;
    private String seenByAdmin;
    private MessageState messageState;
    private Participant participant;
    private Uri fileUri;
    private boolean displayDelivered;
    private boolean entranceAnimation;
    private boolean isImageOnly;
    public static final Part NULL = new Part(new Builder());
    public static final Parcelable.Creator<Part> CREATOR = new Parcelable.Creator<Part>(){

        public Part createFromParcel(Parcel in) {
            return new Part(in);
        }

        public Part[] newArray(int size) {
            return new Part[size];
        }
    };

    public Part() {
        this(new Builder());
    }

    Part(Builder builder) {
        this.id = builder.id == null ? UUID.randomUUID().toString() : builder.id;
        this.participantId = builder.participant_id == null ? "" : builder.participant_id;
        this.participantIsAdmin = builder.participant_is_admin;
        this.summary = builder.summary == null ? "" : builder.summary;
        this.createdAt = builder.created_at;
        this.messageStyle = Part.convertLegacyMessageStyle(builder.message_style);
        if (builder.delivery_option != null) {
            try {
                this.deliveryOption = DeliveryOption.valueOf(builder.delivery_option.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                this.deliveryOption = DeliveryOption.SUMMARY;
            }
        } else {
            this.deliveryOption = DeliveryOption.SUMMARY;
        }
        this.blocks = new ArrayList<Block>();
        if (builder.body != null) {
            for (Block.Builder blockBuilder : builder.body) {
                this.blocks.add(blockBuilder.build());
            }
        }
        this.reactionReply = builder.reactions_reply == null ? ReactionReply.NULL : builder.reactions_reply.build();
        this.seenByAdmin = builder.seen_by_admin == null ? "hide" : builder.seen_by_admin;
        this.attachments = new ArrayList<Attachments>();
        if (builder.attachments != null) {
            for (Attachments.Builder attachmentBuilder : builder.attachments) {
                this.attachments.add(attachmentBuilder.build());
            }
        }
        this.participant = Participant.NULL;
        this.displayDelivered = false;
        this.entranceAnimation = false;
        this.isInitialMessage = builder.is_initial_message;
        this.messageState = MessageState.NORMAL;
        this.isImageOnly = this.blocks.size() == 1 && this.blocks.get(0).getType() == BlockType.IMAGE;
        this.fileUri = new Uri.Builder().build();
    }

    public DeliveryOption getDeliveryOption() {
        return this.deliveryOption;
    }

    public String getId() {
        return this.id;
    }

    public String getParticipantId() {
        return this.participantId;
    }

    public boolean isAdmin() {
        return this.participantIsAdmin;
    }

    public boolean isUser() {
        return !this.isAdmin();
    }

    public void setParticipantIsAdmin(boolean participantIsAdmin) {
        this.participantIsAdmin = participantIsAdmin;
    }

    public List<Block> getBlocks() {
        return this.blocks;
    }

    public void setBlocks(List<Block> blocks) {
        this.blocks = blocks;
    }

    public List<Attachments> getAttachments() {
        return this.attachments;
    }

    public boolean hasAttachments() {
        return !this.attachments.isEmpty();
    }

    public String getMessageStyle() {
        return this.messageStyle;
    }

    public void setMessageStyle(String messageStyle) {
        this.messageStyle = messageStyle;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(long createdAt) {
        this.createdAt = createdAt;
    }

    public String getSummary() {
        return this.summary;
    }

    public ReactionReply getReactionReply() {
        return this.reactionReply;
    }

    public String getSeenByAdmin() {
        return this.participantIsAdmin ? "hide" : this.seenByAdmin;
    }

    public void setSeenByAdmin(String seenByAdmin) {
        this.seenByAdmin = seenByAdmin;
    }

    public Participant getParticipant() {
        return this.participant;
    }

    public void setParticipant(Participant participant) {
        this.participant = participant;
        this.participantId = participant.getId();
    }

    public boolean isDisplayDelivered() {
        return this.displayDelivered;
    }

    public void setDisplayDelivered(boolean displayDelivered) {
        this.displayDelivered = displayDelivered;
    }

    public boolean hasEntranceAnimation() {
        return this.entranceAnimation;
    }

    public void setEntranceAnimation(boolean entranceAnimation) {
        this.entranceAnimation = entranceAnimation;
    }

    public MessageState getMessageState() {
        return this.messageState;
    }

    public void setMessageState(MessageState messageState) {
        this.messageState = messageState;
    }

    public boolean isImageOnly() {
        return this.isImageOnly;
    }

    public void isImageOnly(boolean isImageOnly) {
        this.isImageOnly = isImageOnly;
    }

    public Uri getFileUri() {
        return this.fileUri;
    }

    public void setFileUri(Uri fileUri) {
        this.fileUri = fileUri;
    }

    public boolean isInitialMessage() {
        return this.isInitialMessage;
    }

    static String convertLegacyMessageStyle(String legacyStyle) {
        if (LEGACY_ANNOUNCEMENT_STYLE.equals(legacyStyle)) {
            return POST_MESSAGE_STYLE;
        }
        if (LEGACY_SMALL_ANNOUNCEMENT_STYLE.equals(legacyStyle)) {
            return NOTE_MESSAGE_STYLE;
        }
        if (ADMIN_IS_TYPING_STYLE.equals(legacyStyle)) {
            return ADMIN_IS_TYPING_STYLE;
        }
        if (DAY_DIVIDER_STYLE.equals(legacyStyle)) {
            return DAY_DIVIDER_STYLE;
        }
        if (LOADING_LAYOUT.equals(legacyStyle)) {
            return LOADING_LAYOUT;
        }
        return CHAT_MESSAGE_STYLE;
    }

    Part(Parcel in) {
        this.id = in.readString();
        this.participantId = in.readString();
        boolean bl = this.participantIsAdmin = in.readByte() != 0;
        if (in.readByte() == 1) {
            this.blocks = new ArrayList<Block>();
            in.readList(this.blocks, Block.class.getClassLoader());
        } else {
            this.blocks = null;
        }
        if (in.readByte() == 1) {
            this.attachments = new ArrayList<Attachments>();
            in.readList(this.attachments, Attachments.class.getClassLoader());
        } else {
            this.attachments = null;
        }
        this.messageStyle = in.readString();
        this.createdAt = in.readLong();
        this.summary = in.readString();
        boolean isNullReaction = in.readByte() == 0;
        this.reactionReply = isNullReaction ? ReactionReply.NULL : (ReactionReply)in.readValue(ReactionReply.class.getClassLoader());
        this.seenByAdmin = in.readString();
        this.participant = (Participant)in.readValue(Participant.class.getClassLoader());
        this.isInitialMessage = in.readByte() != 0;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.id);
        dest.writeString(this.participantId);
        dest.writeByte((byte)(this.participantIsAdmin ? 1 : 0));
        if (this.blocks == null) {
            dest.writeByte((byte)0);
        } else {
            dest.writeByte((byte)1);
            dest.writeList(this.blocks);
        }
        if (this.attachments == null) {
            dest.writeByte((byte)0);
        } else {
            dest.writeByte((byte)1);
            dest.writeList(this.attachments);
        }
        dest.writeString(this.messageStyle);
        dest.writeLong(this.createdAt);
        dest.writeString(this.summary);
        if (ReactionReply.isNull(this.reactionReply)) {
            dest.writeByte((byte)0);
        } else {
            dest.writeByte((byte)1);
            dest.writeValue((Object)this.reactionReply);
        }
        dest.writeString(this.seenByAdmin);
        dest.writeValue((Object)this.participant);
        dest.writeByte((byte)(this.isInitialMessage ? 1 : 0));
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof Part) {
            Part otherPart = (Part)o;
            return this.id.equals(otherPart.id);
        }
        return false;
    }

    public static boolean shouldConcatenate(Part part, Part nextPart) {
        if (DAY_DIVIDER_STYLE.equals(part.getMessageStyle())) {
            return false;
        }
        long timeDifference = Math.abs(nextPart.getCreatedAt() - part.getCreatedAt());
        return timeDifference < TimeUnit.MINUTES.toSeconds(3L) && Part.nextPartFromSameParticipant(part, nextPart) && nextPart.getCreatedAt() != 0L;
    }

    private static boolean nextPartFromSameParticipant(Part part, Part nextPart) {
        return part.getParticipantId().equals(nextPart.getParticipantId());
    }

    public boolean isMessagePart() {
        return POST_MESSAGE_STYLE.equals(this.messageStyle) || NOTE_MESSAGE_STYLE.equals(this.messageStyle) || CHAT_MESSAGE_STYLE.equals(this.messageStyle);
    }

    public static final class Builder {
        String id;
        String participant_id;
        boolean participant_is_admin;
        List<Block.Builder> body;
        List<Attachments.Builder> attachments;
        String message_style;
        long created_at;
        String summary;
        ReactionReply.Builder reactions_reply;
        String delivery_option;
        boolean is_initial_message;
        String seen_by_admin;

        public Builder withStyle(String style) {
            this.message_style = style;
            return this;
        }

        public Builder withCreatedAt(long createdAt) {
            this.created_at = createdAt;
            return this;
        }

        public Builder withParticipantIsAdmin(boolean participantIsAdmin) {
            this.participant_is_admin = participantIsAdmin;
            return this;
        }

        public Part build() {
            return new Part(this);
        }
    }

    public static enum DeliveryOption {
        FULL,
        SUMMARY,
        BADGE;

    }

    public static enum MessageState {
        SENDING,
        FAILED,
        UPLOAD_FAILED,
        NORMAL;

    }
}

