/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.inbox;

import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import io.intercom.android.sdk.models.Conversation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;

class InboxStore {
    private final List<Conversation> conversations;

    InboxStore() {
        this(new ArrayList<Conversation>());
    }

    @VisibleForTesting
    InboxStore(List<Conversation> conversations) {
        this.conversations = conversations;
    }

    void syncInbox(List<Conversation> newConversations, RecyclerView.Adapter adapter, LinearLayoutManager layoutManager) {
        ArrayList<Conversation> result = new ArrayList<Conversation>();
        HashSet<String> seenIds = new HashSet<String>(newConversations.size());
        for (Conversation conversation : newConversations) {
            seenIds.add(conversation.getId());
            result.add(conversation);
        }
        for (Conversation conversation : this.conversations) {
            if (seenIds.contains(conversation.getId())) continue;
            result.add(conversation);
        }
        Collections.sort(result, new Comparator<Conversation>(){

            @Override
            public int compare(Conversation lhs, Conversation rhs) {
                return (int)(rhs.getLastPart().getCreatedAt() - lhs.getLastPart().getCreatedAt());
            }
        });
        this.conversations.clear();
        this.conversations.addAll(result);
        adapter.notifyDataSetChanged();
        if (layoutManager.findFirstCompletelyVisibleItemPosition() == 0) {
            layoutManager.scrollToPosition(0);
        }
    }

    @Nullable
    Conversation getLastConversation() {
        if (this.isEmpty()) {
            return null;
        }
        return this.get(this.size() - 1);
    }

    int size() {
        return this.conversations.size();
    }

    boolean isEmpty() {
        return this.conversations.isEmpty();
    }

    boolean contains(Conversation conversation) {
        return this.conversations.contains(conversation);
    }

    boolean add(Conversation conversation) {
        return this.conversations.add(conversation);
    }

    void add(int index, Conversation element) {
        this.conversations.add(index, element);
    }

    Conversation get(int index) {
        return this.conversations.get(index);
    }

    Conversation remove(int index) {
        return this.conversations.remove(index);
    }
}

