/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.conversation;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.ColorFilter;
import android.graphics.Rect;
import android.os.Vibrator;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.commons.utilities.DeviceUtils;
import io.intercom.android.sdk.commons.utilities.ScreenUtils;
import io.intercom.android.sdk.imageloader.LongTermImageLoader;
import io.intercom.android.sdk.logger.IntercomLogger;
import io.intercom.android.sdk.metrics.MetricFactory;
import io.intercom.android.sdk.models.Reaction;
import io.intercom.android.sdk.models.ReactionReply;
import io.intercom.android.sdk.utilities.ColorUtils;
import io.intercom.com.facebook.rebound.BaseSpringSystem;
import io.intercom.com.facebook.rebound.SimpleSpringListener;
import io.intercom.com.facebook.rebound.Spring;
import io.intercom.com.facebook.rebound.SpringConfig;
import io.intercom.com.facebook.rebound.SpringListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ReactionInputView
extends LinearLayout {
    private static final int INTRO_SPRING_TENSION = 600;
    private static final int INTRO_SPRING_FRICTION = 40;
    private static final int REACTION_SPRING_TENSION = 1000;
    private static final int REACTION_SPRING_FRICTION = 36;
    private static final double REACTION_SCALE = 2.5;
    private static final int VIBRATION_DURATION_MS = 10;
    private final List<Spring> reactionSprings;
    private final List<ImageView> reactionViews;
    private final LongTermImageLoader longTermImageLoader;
    private final Vibrator vibrator;
    private final ColorFilter deselectedFilter;
    private String conversationId = "";
    private String partId = "";
    private Integer highlightedViewIndex = null;
    private int reactionsLoaded = 0;
    private ReactionReply reactionReply;
    private ReactionLocation reactionLocation = ReactionLocation.IN_APP;
    private final View.OnTouchListener touchListener = new View.OnTouchListener(){
        private final Rect touchRect = new Rect();

        public boolean onTouch(View view, MotionEvent event) {
            int action = event.getActionMasked();
            switch (action) {
                case 0: 
                case 2: {
                    this.handleTouchMove(event);
                    break;
                }
                case 1: {
                    ReactionInputView.this.handleTouchUp();
                    break;
                }
            }
            return true;
        }

        private void handleTouchMove(MotionEvent event) {
            ReactionInputView.this.getHitRect(this.touchRect);
            if (this.touchRect.contains((int)event.getX(), (int)event.getY())) {
                for (int i = 0; i < ReactionInputView.this.getChildCount(); ++i) {
                    ReactionInputView.this.getChildAt(i).getHitRect(this.touchRect);
                    if (this.touchRect.contains((int)event.getX(), (int)event.getY())) {
                        if (ReactionInputView.this.highlightedViewIndex == null || ReactionInputView.this.highlightedViewIndex != i) {
                            ReactionInputView.this.vibrateForSelection();
                            ReactionInputView.this.selectViewAtIndex(2.5, i);
                        }
                        ReactionInputView.this.highlightedViewIndex = i;
                        continue;
                    }
                    ReactionInputView.this.deselectViewAtIndex(i);
                }
            } else {
                ReactionInputView.this.highlightedViewIndex = null;
                ReactionInputView.this.highlightSelectedReaction();
            }
        }
    };

    public ReactionInputView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ReactionInputView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.reactionSprings = new ArrayList<Spring>();
        this.reactionViews = new ArrayList<ImageView>();
        this.setVisibility(8);
        if (this.isInEditMode()) {
            this.longTermImageLoader = null;
            this.vibrator = null;
        } else {
            this.longTermImageLoader = LongTermImageLoader.newInstance(context);
            this.vibrator = (Vibrator)context.getSystemService("vibrator");
        }
        this.deselectedFilter = ColorUtils.newGreyscaleFilter();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.setOnTouchListener(this.touchListener);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.setOnTouchListener(null);
        if (!this.isInEditMode()) {
            try {
                this.longTermImageLoader.close();
            }
            catch (IOException e) {
                IntercomLogger.d("Couldn't close LongTermImageLoader: " + e.getMessage());
            }
        }
    }

    public void setUpReactions(ReactionReply reactionReply, String conversationId, String partId, ReactionLocation reactionLocation, final boolean animated) {
        final Context context = this.getContext();
        this.reactionReply = reactionReply;
        this.conversationId = conversationId;
        this.partId = partId;
        this.reactionLocation = reactionLocation;
        List<Reaction> reactionSet = reactionReply.getReactionSet();
        final int reactionCount = reactionSet.size();
        final BaseSpringSystem springSystem = Injector.get().getSpringProvider().newSpringSystem();
        final SpringConfig introSpringConfig = new SpringConfig(600.0, 40.0);
        SpringConfig reactionSpringConfig = new SpringConfig(1000.0, 36.0);
        for (int i = 0; i < reactionSet.size(); ++i) {
            FrameLayout frameLayout = new FrameLayout(context);
            frameLayout.setClipChildren(false);
            frameLayout.setClipToPadding(false);
            frameLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -1, 1.0f));
            final ImageView reactionImageView = new ImageView(context);
            int imageSizePx = this.getResources().getDimensionPixelSize(R.dimen.intercom_reaction_size);
            reactionImageView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(imageSizePx, imageSizePx, 17));
            reactionImageView.setPivotY((float)this.getResources().getDimensionPixelSize(R.dimen.intercom_reaction_offset));
            reactionImageView.setPivotX((float)(imageSizePx / 2));
            this.reactionViews.add(reactionImageView);
            frameLayout.addView((View)reactionImageView);
            Reaction reaction = reactionSet.get(i);
            this.longTermImageLoader.loadImage(reaction.getImageUrl(), this.getContext(), new LongTermImageLoader.OnImageReadyListener(){

                @Override
                public void onImageReady(Bitmap bitmap) {
                    reactionImageView.setImageBitmap(bitmap);
                    ReactionInputView.this.reactionsLoaded++;
                    if (ReactionInputView.this.reactionsLoaded == reactionCount) {
                        if (animated) {
                            double startY = ReactionInputView.this.getY();
                            springSystem.createSpring().setSpringConfig(introSpringConfig).addListener((SpringListener)new SimpleSpringListener(){

                                public void onSpringActivate(Spring spring) {
                                    ReactionInputView.this.setVisibility(0);
                                }

                                public void onSpringUpdate(Spring spring) {
                                    ReactionInputView.this.setY((float)spring.getCurrentValue());
                                }
                            }).setCurrentValue(startY + (double)ReactionInputView.this.getHeight() + (double)ScreenUtils.dpToPx((float)60.0f, (Context)context)).setEndValue(startY);
                        } else {
                            ReactionInputView.this.setVisibility(0);
                        }
                    }
                }
            });
            Spring spring = springSystem.createSpring().setSpringConfig(reactionSpringConfig).addListener((SpringListener)new SimpleSpringListener(){

                public void onSpringUpdate(Spring spring) {
                    float value = (float)spring.getCurrentValue();
                    reactionImageView.setScaleX(value);
                    reactionImageView.setScaleY(value);
                }
            }).setCurrentValue(1.0);
            this.reactionSprings.add(spring);
            Integer selectedReactionIndex = reactionReply.getReactionIndex();
            if (selectedReactionIndex != null && !selectedReactionIndex.equals(reaction.getIndex())) {
                this.deselectViewAtIndex(i);
            }
            this.addView((View)frameLayout);
        }
    }

    public void preloadReactionImages(ReactionReply reactionReply) {
        for (Reaction reaction : reactionReply.getReactionSet()) {
            this.longTermImageLoader.loadImage(reaction.getImageUrl(), this.getContext(), null);
        }
    }

    private void vibrateForSelection() {
        if (DeviceUtils.hasPermission((Context)this.getContext(), (String)"android.permission.VIBRATE")) {
            this.vibrator.vibrate(10L);
        }
    }

    private void handleTouchUp() {
        Reaction selectedReaction;
        if (this.highlightedViewIndex != null && this.highlightedViewIndex >= 0 && this.highlightedViewIndex < this.reactionReply.getReactionSet().size() && (selectedReaction = this.reactionReply.getReactionSet().get(this.highlightedViewIndex)) != null && (this.reactionReply.getReactionIndex() == null || selectedReaction.getIndex() != this.reactionReply.getReactionIndex().intValue())) {
            this.reactionReply.setReactionIndex(selectedReaction.getIndex());
            Injector.get().getApi().reactToConversation(this.conversationId, selectedReaction.getIndex());
            Injector.get().getMetricsStore().track(MetricFactory.sentReaction(this.conversationId, this.partId, this.reactionLocation));
        }
        this.highlightSelectedReaction();
        this.highlightedViewIndex = null;
    }

    private void highlightSelectedReaction() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            Integer selectedReactionIndex = this.reactionReply.getReactionIndex();
            Reaction reaction = this.reactionReply.getReactionSet().get(i);
            if (selectedReactionIndex == null || selectedReactionIndex.equals(reaction.getIndex())) {
                this.selectViewAtIndex(1.0, i);
                continue;
            }
            this.deselectViewAtIndex(i);
        }
    }

    private void selectViewAtIndex(double scale, int index) {
        ImageView reactionImage;
        Spring spring = this.reactionSprings.get(index);
        if (spring.getEndValue() != scale) {
            spring.setAtRest();
            spring.setEndValue(scale);
        }
        if ((reactionImage = this.reactionViews.get(index)) != null) {
            reactionImage.clearColorFilter();
        }
    }

    private void deselectViewAtIndex(int index) {
        ImageView reactionImage;
        Spring spring = this.reactionSprings.get(index);
        if (spring.getEndValue() != 1.0) {
            spring.setAtRest();
            spring.setEndValue(1.0);
        }
        if ((reactionImage = this.reactionViews.get(index)) != null) {
            reactionImage.setColorFilter(this.deselectedFilter);
        }
    }

    public static enum ReactionLocation {
        CONVERSATION,
        IN_APP;

    }
}

