/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.conversation;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.text.Editable;
import android.text.TextWatcher;
import android.widget.ImageButton;
import io.intercom.android.sdk.nexus.NexusClient;
import io.intercom.android.sdk.nexus.NexusEvent;

class ComposerTextWatcher
implements TextWatcher {
    private static final long IS_TYPING_DELAY = 1000L;
    private final ImageButton sendButton;
    private final ImageButton attachmentButton;
    private final String userId;
    private final NexusClient nexusClient;
    private String conversationId = "";
    private boolean shouldSendIsTyping = true;
    private final ObjectAnimator showAttach;
    private final ObjectAnimator hideAttach;
    private final ObjectAnimator showSend;
    private final ObjectAnimator hideSend;

    public ComposerTextWatcher(final ImageButton sendButton, final ImageButton attachmentButton, String userId, NexusClient nexusClient) {
        this.sendButton = sendButton;
        this.attachmentButton = attachmentButton;
        this.userId = userId;
        this.nexusClient = nexusClient;
        this.showAttach = ObjectAnimator.ofPropertyValuesHolder((Object)attachmentButton, (PropertyValuesHolder[])new PropertyValuesHolder[]{PropertyValuesHolder.ofFloat((String)"alpha", (float[])new float[]{0.0f, 1.0f}), PropertyValuesHolder.ofFloat((String)"scaleX", (float[])new float[]{0.6f, 1.0f}), PropertyValuesHolder.ofFloat((String)"scaleY", (float[])new float[]{0.6f, 1.0f})}).setDuration(100L);
        this.showAttach.setStartDelay(50L);
        this.showAttach.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                attachmentButton.setVisibility(0);
            }
        });
        this.hideAttach = ObjectAnimator.ofPropertyValuesHolder((Object)attachmentButton, (PropertyValuesHolder[])new PropertyValuesHolder[]{PropertyValuesHolder.ofFloat((String)"alpha", (float[])new float[]{1.0f, 0.0f}), PropertyValuesHolder.ofFloat((String)"scaleX", (float[])new float[]{1.0f, 0.6f}), PropertyValuesHolder.ofFloat((String)"scaleY", (float[])new float[]{1.0f, 0.6f})}).setDuration(100L);
        this.hideAttach.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                attachmentButton.setVisibility(8);
            }
        });
        this.showSend = ObjectAnimator.ofPropertyValuesHolder((Object)sendButton, (PropertyValuesHolder[])new PropertyValuesHolder[]{PropertyValuesHolder.ofFloat((String)"alpha", (float[])new float[]{0.0f, 1.0f}), PropertyValuesHolder.ofFloat((String)"scaleX", (float[])new float[]{0.6f, 1.0f}), PropertyValuesHolder.ofFloat((String)"scaleY", (float[])new float[]{0.6f, 1.0f})}).setDuration(100L);
        this.showSend.setStartDelay(50L);
        this.showSend.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                sendButton.setVisibility(0);
            }
        });
        this.hideSend = ObjectAnimator.ofPropertyValuesHolder((Object)sendButton, (PropertyValuesHolder[])new PropertyValuesHolder[]{PropertyValuesHolder.ofFloat((String)"alpha", (float[])new float[]{1.0f, 0.0f}), PropertyValuesHolder.ofFloat((String)"scaleX", (float[])new float[]{1.0f, 0.6f}), PropertyValuesHolder.ofFloat((String)"scaleY", (float[])new float[]{1.0f, 0.6f})}).setDuration(100L);
        this.hideSend.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                sendButton.setVisibility(8);
            }
        });
    }

    protected void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    public void onTextChanged(CharSequence s, int start, int before, int count) {
    }

    public void afterTextChanged(Editable editable) {
        if (this.shouldSendIsTyping) {
            this.shouldSendIsTyping = false;
            this.sendButton.postDelayed(new Runnable(){

                @Override
                public void run() {
                    ComposerTextWatcher.this.shouldSendIsTyping = true;
                }
            }, 1000L);
            if (!this.conversationId.isEmpty()) {
                this.nexusClient.fire(NexusEvent.getUserIsTypingEvent((String)this.conversationId, (String)this.userId));
            }
        }
        if (ComposerTextWatcher.containsText(editable.toString())) {
            if (this.sendButton.getVisibility() == 8) {
                this.hideAttach.start();
                this.showSend.start();
            }
        } else if (this.attachmentButton.getVisibility() == 8) {
            this.hideSend.start();
            this.showAttach.start();
        }
    }

    protected static boolean containsText(String text) {
        return !text.trim().isEmpty();
    }
}

