/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.identity;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import io.intercom.android.sdk.logger.IntercomLogger;
import java.util.HashMap;
import java.util.Map;

public class Registration {
    private String email = "";
    private String userId = "";
    private String gcmRegistrationId = "";
    private Map<String, Object> attributes = new HashMap<String, Object>();
    private boolean isValidRegistration = true;

    public static Registration create() {
        return new Registration();
    }

    public Registration withEmail(@NonNull String email) {
        if (TextUtils.isEmpty((CharSequence)email)) {
            IntercomLogger.e("Email cannot be null or empty");
            this.isValidRegistration = false;
        } else {
            this.email = email;
        }
        return this;
    }

    public Registration withUserId(@NonNull String userId) {
        if (TextUtils.isEmpty((CharSequence)userId)) {
            IntercomLogger.e("UserId cannot be null or empty");
            this.isValidRegistration = false;
        } else {
            this.userId = userId;
        }
        return this;
    }

    public Registration withUserAttributes(Map<String, Object> attributes) {
        this.isValidRegistration = false;
        if (attributes == null) {
            IntercomLogger.e("Registration.withUserAttributes method failed: the attributes Map provided is null");
        } else if (attributes.isEmpty()) {
            IntercomLogger.e("Registration.withUserAttributes method failed: the attributes Map provided is empty");
        } else {
            this.attributes = attributes;
            this.isValidRegistration = true;
        }
        return this;
    }

    public String getEmail() {
        return this.email;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getGcmRegistrationId() {
        return this.gcmRegistrationId;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    protected boolean isValidRegistration() {
        return this.isValidRegistration;
    }
}

