/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.identity;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.VisibleForTesting;
import io.intercom.android.sdk.identity.Registration;
import io.intercom.android.sdk.models.User;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class UserIdentity {
    private static final String PREFS_ANONYMOUS_ID = "INTERCOM_SDK_ANONYMOUS_ID";
    private static final String PREFS_INTERCOM_ID = "INTERCOM_SDK_INTERCOM_ID";
    private static final String PREFS_USER_ID = "INTERCOM_SDK_USER_ID";
    private static final String PREFS_EMAIL_ID = "INTERCOM_SDK_EMAIL_ID";
    private static final String USER = "user";
    public static final String TYPE = "type";
    public static final String EMAIL = "email";
    public static final String ANONYMOUS_ID = "anonymous_id";
    public static final String USER_ID = "user_id";
    public static final String INTERCOM_ID = "intercom_id";
    private final SharedPreferences prefs;
    private String data;
    private String hmac;
    private String anonymousId;
    private String intercomId;
    private String userId;
    private String email;
    private String fingerprint = "";

    public UserIdentity(Context context) {
        this.prefs = context.getSharedPreferences("INTERCOM_SDK_USER_PREFS", 0);
        this.anonymousId = this.prefs.getString("intercomsdk-session-INTERCOM_SDK_ANONYMOUS_ID", "");
        this.intercomId = this.prefs.getString("intercomsdk-session-INTERCOM_SDK_INTERCOM_ID", "");
        this.userId = this.prefs.getString("intercomsdk-session-INTERCOM_SDK_USER_ID", "");
        this.email = this.prefs.getString("intercomsdk-session-INTERCOM_SDK_EMAIL_ID", "");
        this.data = this.prefs.getString("intercomsdk-session-SecureMode_Data", "");
        this.hmac = this.prefs.getString("intercomsdk-session-SecureMode_HMAC", "");
        if (this.identityExists()) {
            this.fingerprint = this.generateFingerprint();
        }
    }

    public boolean canRegisterIdentifiedUser(Registration registration) {
        return registration.isValidRegistration() && !this.isIdentified();
    }

    public boolean canRegisterUnidentifiedUser() {
        return !this.identityExists();
    }

    public void registerIdentifiedUser(Registration registration) {
        SharedPreferences.Editor editor = this.prefs.edit();
        this.intercomId = "";
        editor.putString("intercomsdk-session-INTERCOM_SDK_INTERCOM_ID", this.intercomId);
        if (!registration.getUserId().isEmpty()) {
            this.userId = registration.getUserId();
            editor.putString("intercomsdk-session-INTERCOM_SDK_USER_ID", this.userId);
        }
        if (!registration.getEmail().isEmpty()) {
            this.email = registration.getEmail();
            editor.putString("intercomsdk-session-INTERCOM_SDK_EMAIL_ID", this.email);
        }
        editor.apply();
        if (this.fingerprint.isEmpty()) {
            this.fingerprint = this.generateFingerprint();
        }
    }

    @VisibleForTesting
    void setIntercomId(String id2) {
        this.intercomId = id2;
        this.prefs.edit().putString("intercomsdk-session-INTERCOM_SDK_INTERCOM_ID", this.intercomId);
    }

    public void registerUnidentifiedUser() {
        this.anonymousId = UUID.randomUUID().toString();
        this.prefs.edit().putString("intercomsdk-session-INTERCOM_SDK_ANONYMOUS_ID", this.anonymousId).apply();
        if (this.fingerprint.isEmpty()) {
            this.fingerprint = this.generateFingerprint();
        }
    }

    public void update(User user) {
        SharedPreferences.Editor editor = this.prefs.edit();
        this.userId = user.getUserId();
        editor.putString("intercomsdk-session-INTERCOM_SDK_USER_ID", this.userId);
        this.email = user.getEmail();
        editor.putString("intercomsdk-session-INTERCOM_SDK_EMAIL_ID", this.email);
        if (!user.getIntercomId().isEmpty()) {
            this.intercomId = user.getIntercomId();
            editor.putString("intercomsdk-session-INTERCOM_SDK_INTERCOM_ID", this.intercomId);
        }
        this.anonymousId = user.getAnonymousId();
        editor.putString("intercomsdk-session-INTERCOM_SDK_ANONYMOUS_ID", this.anonymousId);
        editor.apply();
    }

    public void setSecureMode(String hmac, String data) {
        this.data = data;
        this.hmac = hmac;
        SharedPreferences.Editor editor = this.prefs.edit();
        editor.putString("intercomsdk-session-SecureMode_Data", data);
        editor.putString("intercomsdk-session-SecureMode_HMAC", hmac);
        editor.apply();
    }

    public String getData() {
        return this.data;
    }

    public String getHmac() {
        return this.hmac;
    }

    public String getIntercomId() {
        return this.intercomId;
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    public boolean hasIntercomId() {
        return !this.getIntercomId().isEmpty();
    }

    public boolean identityExists() {
        return !this.email.isEmpty() || !this.userId.isEmpty() || !this.intercomId.isEmpty() || !this.anonymousId.isEmpty();
    }

    public boolean isIdentified() {
        return this.identityExists() && !this.isUnidentified();
    }

    public boolean isUnidentified() {
        return !this.anonymousId.isEmpty() && this.email.isEmpty() && this.userId.isEmpty();
    }

    @SuppressLint(value={"CommitPrefEdits"})
    public void reset() {
        this.prefs.edit().clear().commit();
        this.anonymousId = "";
        this.intercomId = "";
        this.userId = "";
        this.email = "";
        this.data = "";
        this.hmac = "";
        this.fingerprint = "";
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (!this.anonymousId.isEmpty()) {
            map.put(ANONYMOUS_ID, this.anonymousId);
        } else if (!this.intercomId.isEmpty()) {
            map.put(INTERCOM_ID, this.intercomId);
        }
        if (!this.userId.isEmpty()) {
            map.put(USER_ID, this.userId);
        }
        if (!this.email.isEmpty()) {
            map.put(EMAIL, this.email);
        }
        if (!USER.isEmpty()) {
            map.put(TYPE, USER);
        }
        return map;
    }

    private String generateFingerprint() {
        return UUID.randomUUID().toString();
    }
}

