/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk;

import android.app.Application;
import android.app.TaskStackBuilder;
import android.content.Intent;
import android.support.annotation.NonNull;
import io.intercom.android.sdk.RealIntercom;
import io.intercom.android.sdk.UnreadConversationCountListener;
import io.intercom.android.sdk.identity.Registration;
import io.intercom.android.sdk.logger.IntercomLogger;
import java.util.Map;

public abstract class Intercom {
    public static final Visibility VISIBLE = Visibility.VISIBLE;
    public static final Visibility GONE = Visibility.GONE;
    public static final String GCM_RECEIVER = "intercom_sdk";
    private static Intercom instance;

    public static synchronized void initialize(Application application, String apiKey, String appId) {
        if (instance == null) {
            instance = new RealIntercom(application, apiKey, appId);
        } else {
            IntercomLogger.i("Intercom has already been initialized");
        }
    }

    public static synchronized Intercom client() {
        if (instance == null) {
            throw new IllegalStateException("Please call Intercom.initialize() before requesting the client.");
        }
        return instance;
    }

    public abstract void registerUnidentifiedUser();

    public abstract void registerIdentifiedUser(Registration var1);

    public abstract void setSecureMode(String var1, String var2);

    public abstract void updateUser(Map<String, ?> var1);

    public abstract void logEvent(String var1);

    public abstract void logEvent(String var1, Map<String, ?> var2);

    public abstract void displayMessenger();

    public abstract void displayMessageComposer();

    public abstract void displayConversationsList();

    public abstract void setInAppMessageVisibility(Visibility var1);

    public abstract void setLauncherVisibility(Visibility var1);

    public abstract void hideMessenger();

    public abstract void setupGcm(@NonNull String var1);

    public abstract void openGcmMessage(Intent var1);

    public abstract void openGcmMessage(Intent var1, TaskStackBuilder var2);

    public abstract void reset();

    public abstract int getUnreadConversationCount();

    public abstract void addUnreadConversationCountListener(@NonNull UnreadConversationCountListener var1);

    public abstract void removeUnreadConversationCountListener(UnreadConversationCountListener var1);

    public static void setLogLevel(int logLevel) {
        IntercomLogger.setLogLevel(logLevel);
    }

    public static enum Visibility {
        GONE,
        VISIBLE;

    }
}

