/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.transforms;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import io.intercom.com.bumptech.glide.Glide;
import io.intercom.com.bumptech.glide.load.Transformation;
import io.intercom.com.bumptech.glide.load.engine.Resource;
import io.intercom.com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import io.intercom.com.bumptech.glide.load.resource.bitmap.BitmapResource;

public class RoundedCornersTransform
implements Transformation<Bitmap> {
    private BitmapPool bitmapPool;
    private int radius;

    public RoundedCornersTransform(Context context, int radius) {
        this.bitmapPool = Glide.get((Context)context).getBitmapPool();
        this.radius = radius;
    }

    public Resource<Bitmap> transform(Resource<Bitmap> resource, int outWidth, int outHeight) {
        int height;
        Bitmap source = (Bitmap)resource.get();
        int width = source.getWidth();
        Bitmap bitmap = this.bitmapPool.get(width, height = source.getHeight(), Bitmap.Config.ARGB_8888);
        if (bitmap == null) {
            bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        Canvas canvas = new Canvas(bitmap);
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        paint.setShader((Shader)new BitmapShader(source, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP));
        canvas.drawRoundRect(new RectF(0.0f, 0.0f, (float)width, (float)height), (float)this.radius, (float)this.radius, paint);
        return BitmapResource.obtain((Bitmap)bitmap, (BitmapPool)this.bitmapPool);
    }

    public String getId() {
        return "RoundedTransformation(radius=" + this.radius + ")";
    }
}

