/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.preview;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.media.SoundPool;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.Toast;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.Intercom;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.UnreadCountTracker;
import io.intercom.android.sdk.activities.IamActivity;
import io.intercom.android.sdk.activities.IntercomNoteActivity;
import io.intercom.android.sdk.activities.IntercomPostActivity;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.lifecycles.EmptyActivityLifecycleCallbacks;
import io.intercom.android.sdk.logger.IntercomLogger;
import io.intercom.android.sdk.metrics.MetricsStore;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.models.events.FirstMessageEvent;
import io.intercom.android.sdk.models.events.ReadEvent;
import io.intercom.android.sdk.models.events.UnreadConversationsEvent;
import io.intercom.android.sdk.models.events.realtime.CreateConversationEvent;
import io.intercom.android.sdk.models.events.realtime.NewCommentEvent;
import io.intercom.android.sdk.preview.DefaultLauncherManager;
import io.intercom.android.sdk.preview.LauncherOpenBehaviour;
import io.intercom.android.sdk.preview.NotificationManager;
import io.intercom.android.sdk.preview.PreviewInteractionManager;
import io.intercom.android.sdk.utilities.AvatarUtils;
import io.intercom.android.sdk.utilities.IntercomUtils;
import io.intercom.com.squareup.otto.Bus;
import io.intercom.com.squareup.otto.Subscribe;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@TargetApi(value=14)
public class PreviewManager
extends EmptyActivityLifecycleCallbacks
implements PreviewInteractionManager {
    private final List<Conversation> conversations = new ArrayList<Conversation>();
    private final Set<String> dismissedPartIds = new HashSet<String>();
    private final DefaultLauncherManager defaultLauncherManager;
    private final NotificationManager notificationManager;
    private final Handler handler;
    private Intercom.Visibility previewVisibility = Intercom.Visibility.VISIBLE;
    private Intercom.Visibility launcherVisibility = Intercom.Visibility.GONE;
    @Nullable
    private Activity lastActive;

    public PreviewManager(Application application, Bus bus, MetricsStore metricsStore, UnreadCountTracker unreadCountTracker, AppConfig.Provider appConfigProvider) {
        bus.register((Object)this);
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        LayoutInflater inflater = LayoutInflater.from((Context)application.getApplicationContext());
        this.handler = new Handler(Looper.getMainLooper());
        this.notificationManager = new NotificationManager(inflater, this.handler, this, metricsStore);
        this.defaultLauncherManager = new DefaultLauncherManager(inflater, unreadCountTracker, metricsStore, appConfigProvider, new LauncherOpenBehaviour());
    }

    public Intercom.Visibility getPreviewVisibility() {
        return this.previewVisibility;
    }

    public Intercom.Visibility getLauncherVisibility() {
        return this.launcherVisibility;
    }

    public void setPreviewVisibility(Intercom.Visibility visibility) {
        this.previewVisibility = visibility;
        this.refreshOverlayStates(visibility);
    }

    public void setLauncherVisibility(Intercom.Visibility visibility) {
        this.launcherVisibility = visibility;
        this.refreshOverlayStates(visibility);
    }

    private void refreshOverlayStates(Intercom.Visibility visibility) {
        if (visibility == Intercom.Visibility.GONE) {
            this.conditionallyRemovePreview(this.lastActive);
        }
        this.conditionallyAddPreview(this.conversations);
    }

    public void displayFirstMessageVisuals(Activity activity) throws Exception {
        View view = activity.getLayoutInflater().inflate(R.layout.intercom_onboarding_layout, null);
        Toast toast = new Toast(Injector.get().getContext());
        toast.setGravity(17, 0, 0);
        toast.setDuration(1);
        toast.setView(view);
        toast.show();
    }

    public void reset() {
        this.conversations.clear();
        this.notificationManager.reset();
        this.conditionallyRemovePreview(this.lastActive);
    }

    @Subscribe
    public void unreadConversationsReveived(UnreadConversationsEvent event) {
        IntercomLogger.internal("chathead", "received unread count update with: " + event.getResponse().getConversations() + " conversations and total unread count of " + event.getResponse().getTotalUnreadCount());
        this.conversations.clear();
        this.conversations.addAll(event.getResponse().getConversations());
        this.removeDismissedConversations(this.conversations, this.dismissedPartIds);
        this.removeBadgeConversations(this.conversations);
        this.conditionallyAddPreview(this.conversations);
    }

    @Subscribe
    public void conversationMarkedAsRead(ReadEvent event) {
        for (Conversation conversation : this.conversations) {
            if (!conversation.getId().equals(event.getConversationId())) continue;
            this.conversations.remove(conversation);
            break;
        }
        if (this.conversations.size() == 1 && Injector.get().getUnreadCountTracker().getCount() > this.conversations.size()) {
            this.getUnreadConversations();
        }
    }

    @Subscribe
    public void newComment(NewCommentEvent event) {
        this.realtimeUpdate();
    }

    @Subscribe
    public void newConversation(CreateConversationEvent event) {
        this.realtimeUpdate();
    }

    @Subscribe
    public void firstMessage(FirstMessageEvent event) {
        IntercomLogger.i(Injector.get().getContext().getString(R.string.intercomsdk_activated_key_message));
        try {
            this.displayFirstMessageVisuals(this.lastActive);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void realtimeUpdate() {
        if (!IntercomUtils.isIntercomActivity(this.lastActive)) {
            this.getUnreadConversations();
        }
    }

    private void getUnreadConversations() {
        Injector.get().getApi().getUnreadConversations();
    }

    @Override
    public void onActivityResumed(Activity activity) {
        this.lastActive = activity;
        this.conditionallyAddPreview(this.conversations);
    }

    @Override
    public void onActivityPaused(Activity activity) {
        this.handler.removeCallbacksAndMessages(null);
        this.conditionallyRemovePreview(activity);
        this.lastActive = null;
    }

    public void conditionallyAddPreview(final List<Conversation> conversations) {
        if (this.shouldDisplayPreview(this.lastActive, conversations)) {
            this.handler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (PreviewManager.this.shouldDisplayPreview(PreviewManager.this.lastActive, conversations)) {
                        PreviewManager.this.displayPreview(PreviewManager.this.lastActive, conversations);
                    }
                }
            }, 500L);
        } else if (this.shouldDisplayLauncher(this.lastActive, conversations)) {
            this.handler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (PreviewManager.this.shouldDisplayLauncher(PreviewManager.this.lastActive, conversations)) {
                        try {
                            PreviewManager.this.defaultLauncherManager.displayLauncher(PreviewManager.this.getRootView());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }, 500L);
        }
    }

    public void conditionallyRemovePreview(Activity activity) {
        View root;
        if (activity != null && (root = activity.findViewById(R.id.preview_root)) != null) {
            this.defaultLauncherManager.reset();
            this.notificationManager.reset();
            if (root.getParent() != null) {
                ((ViewGroup)root.getParent()).removeView(root);
            }
        }
    }

    private void displayPreview(@NonNull Activity activity, final List<Conversation> conversations) {
        AvatarUtils.preloadAvatar(conversations.get(0).getLastAdmin().getAvatar(), (Context)activity, new Runnable(){

            @Override
            public void run() {
                if (PreviewManager.this.shouldDisplayPreview(PreviewManager.this.lastActive, conversations)) {
                    PreviewManager.this.displayPreviewWithPreloadedAvatar(conversations);
                }
            }
        });
    }

    private void displayPreviewWithPreloadedAvatar(List<Conversation> conversations) {
        ViewGroup rootView;
        try {
            rootView = this.getRootView();
        }
        catch (Exception ignored) {
            return;
        }
        Conversation conversation = conversations.get(0);
        String messageStyle = conversation.getLastPart().getMessageStyle();
        Part.DeliveryOption deliveryOption = conversation.getLastPart().getDeliveryOption();
        if (conversations.size() > 1 || this.notificationManager.isDisplaying() || deliveryOption == Part.DeliveryOption.SUMMARY || deliveryOption == Part.DeliveryOption.FULL && "chat".equals(messageStyle)) {
            if (this.defaultLauncherManager.isDisplaying()) {
                this.notificationManager.displayNotificationPreview(rootView, conversations, this.defaultLauncherManager.getLauncher());
            } else {
                this.notificationManager.displayNotificationPreview(rootView, conversations);
            }
        } else if (deliveryOption == Part.DeliveryOption.FULL) {
            if ("post".equals(messageStyle)) {
                this.openPost(conversation);
            } else if ("note".equals(messageStyle)) {
                this.openNote(conversation);
            }
        }
    }

    @Override
    public ViewGroup getRootView() throws Exception {
        if (this.lastActive == null) {
            throw new NullPointerException();
        }
        ViewGroup root = (ViewGroup)this.lastActive.findViewById(R.id.preview_root);
        if (root == null) {
            root = (ViewGroup)this.lastActive.getLayoutInflater().inflate(R.layout.intercom_preview_container, null, false);
            FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1);
            params.gravity = 80;
            this.lastActive.addContentView((View)root, (ViewGroup.LayoutParams)params);
        }
        return root;
    }

    @Override
    public void playSound(Context context) {
        SoundPool soundPool = new SoundPool(1, 5, 0);
        soundPool.setOnLoadCompleteListener(new SoundPool.OnLoadCompleteListener(){

            public void onLoadComplete(SoundPool soundPool, int sampleId, int status) {
                soundPool.play(sampleId, 1.0f, 1.0f, 1, 0, 1.0f);
            }
        });
        soundPool.load(context, R.raw.intercomsdk_birdy_done_1, 1);
    }

    @Override
    public void markAsDismissed(Conversation conversation) {
        Injector.get().getApi().markConversationAsDismissed(conversation.getId());
        this.dismissedPartIds.add(conversation.getLastPart().getId());
        this.removeDismissedConversations(this.conversations, this.dismissedPartIds);
        if (this.shouldDisplayLauncher(this.lastActive, this.conversations)) {
            try {
                this.defaultLauncherManager.displayLauncher(this.getRootView());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void openNotification(Conversation conversation) {
        String messageStyle = conversation.getLastPart().getMessageStyle();
        if ("post".equals(messageStyle)) {
            this.openPost(conversation);
        } else if ("note".equals(messageStyle)) {
            this.openNote(conversation);
        } else {
            this.openIam(conversation);
        }
    }

    public void openIam(Conversation conversation) {
        Context context = Injector.get().getContext();
        Intent conversationIntent = IamActivity.openConversationFull(context, conversation.getId(), conversation.getLastParticipatingAdmin());
        context.startActivity(conversationIntent);
    }

    public void openPost(Conversation conversation) {
        Context context = Injector.get().getContext();
        context.startActivity(IntercomPostActivity.buildPostIntent(context, conversation.getLastPart(), conversation.getId(), conversation.getLastParticipatingAdmin(), true));
    }

    private void openNote(Conversation conversation) {
        try {
            Context context = Injector.get().getContext();
            context.startActivity(IntercomNoteActivity.buildNoteIntent(context, conversation.getLastPart(), conversation.getId(), conversation.getLastParticipatingAdmin()));
        }
        catch (IllegalArgumentException e) {
            IntercomLogger.internal("preview", "Error loading the note " + e.getMessage());
        }
    }

    boolean shouldDisplayPreview(@Nullable Activity activity, List<Conversation> conversations) {
        boolean result = this.previewVisibility == Intercom.Visibility.VISIBLE && activity != null && conversations != null && !conversations.isEmpty() && !IntercomUtils.isIntercomActivity(activity);
        IntercomLogger.internal("preview", "should display preview: " + result);
        return result;
    }

    boolean shouldDisplayLauncher(@Nullable Activity activity, List<Conversation> conversations) {
        if (this.previewVisibility == Intercom.Visibility.VISIBLE) {
            for (Conversation c : conversations) {
                if (Part.DeliveryOption.BADGE == c.getLastPart().getDeliveryOption()) continue;
                return false;
            }
        }
        return this.launcherVisibility == Intercom.Visibility.VISIBLE && activity != null && Injector.get().getIdentityStore().userIdentityExists() && !IntercomUtils.isIntercomActivity(activity);
    }

    void removeDismissedConversations(List<Conversation> conversations, Set<String> dismissedPartIds) {
        for (int i = conversations.size() - 1; i >= 0; --i) {
            if (!dismissedPartIds.contains(conversations.get(i).getLastPart().getId())) continue;
            conversations.remove(i);
        }
    }

    void removeBadgeConversations(List<Conversation> conversations) {
        for (int i = conversations.size() - 1; i >= 0; --i) {
            if (conversations.get(i).getLastPart().getDeliveryOption() != Part.DeliveryOption.BADGE) continue;
            conversations.remove(i);
        }
    }
}

