/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.preview;

import android.content.Context;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import io.intercom.android.sdk.UnreadConversationCountListener;
import io.intercom.android.sdk.UnreadCountTracker;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.metrics.MetricFactory;
import io.intercom.android.sdk.metrics.MetricsStore;
import io.intercom.android.sdk.preview.DefaultLauncher;
import io.intercom.android.sdk.preview.LauncherOpenBehaviour;
import io.intercom.android.sdk.utilities.ViewUtils;

class DefaultLauncherManager
implements UnreadConversationCountListener,
DefaultLauncher.Listener {
    private final LayoutInflater inflater;
    private final MetricsStore metricsStore;
    private final AppConfig.Provider appConfigProvider;
    private final LauncherOpenBehaviour openBehaviour;
    @Nullable
    private DefaultLauncher defaultLauncher;
    private UnreadCountTracker unreadCountTracker;

    public DefaultLauncherManager(LayoutInflater inflater, UnreadCountTracker unreadCountTracker, MetricsStore metricsStore, AppConfig.Provider appConfigProvider, LauncherOpenBehaviour openBehaviour) {
        this.inflater = inflater;
        this.unreadCountTracker = unreadCountTracker;
        this.metricsStore = metricsStore;
        this.appConfigProvider = appConfigProvider;
        this.openBehaviour = openBehaviour;
    }

    public void displayLauncher(final ViewGroup root) {
        ViewUtils.waitForViewAttachment((View)root, new Runnable(){

            @Override
            public void run() {
                DefaultLauncherManager.this.displayLauncherOnAttachedRoot(root);
            }
        });
    }

    private void displayLauncherOnAttachedRoot(ViewGroup root) {
        if (this.defaultLauncher == null) {
            this.defaultLauncher = new DefaultLauncher(root.getContext(), root, this.inflater, this.appConfigProvider.getAppConfig(), this);
            this.setUnreadCount(this.unreadCountTracker.getCount());
            this.defaultLauncher.fadeOnScreen();
            this.unreadCountTracker.addListener(this);
        } else {
            this.setUnreadCount(this.unreadCountTracker.getCount());
        }
    }

    public DefaultLauncher getLauncher() {
        DefaultLauncher localLauncher = this.defaultLauncher;
        this.defaultLauncher = null;
        return localLauncher;
    }

    public void reset() {
        this.unreadCountTracker.removeListener(this);
        this.removeLauncher();
    }

    public void removeLauncher() {
        if (this.defaultLauncher != null) {
            this.defaultLauncher.fadeOffScreen();
            this.defaultLauncher = null;
        }
    }

    public boolean isDisplaying() {
        return this.defaultLauncher != null;
    }

    @Override
    public void onCountUpdate(int unreadCount) {
        this.setUnreadCount(unreadCount);
    }

    private void setUnreadCount(int unreadCount) {
        if (this.defaultLauncher != null) {
            if (unreadCount > 0) {
                this.defaultLauncher.setBadgeCount(String.valueOf(unreadCount));
            } else {
                this.defaultLauncher.hideBadeCount();
            }
        }
    }

    @Override
    public void onLauncherClicked(Context context) {
        this.metricsStore.track(MetricFactory.tappedOnLauncher("default"));
        this.openBehaviour.openMessenger(context);
    }
}

