/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.blocks.BlockAlignment;
import io.intercom.android.sdk.blocks.Image;
import io.intercom.android.sdk.blocks.StyleType;
import io.intercom.android.sdk.blocks.blockInterfaces.LocalImageBlock;
import io.intercom.android.sdk.logger.IntercomLogger;
import io.intercom.android.sdk.transforms.RoundedCornersTransform;
import io.intercom.android.sdk.utilities.BlockUtils;
import io.intercom.android.sdk.utilities.ImageUtils;
import io.intercom.android.sdk.views.ProgressFrameLayout;
import io.intercom.android.sdk.views.ResizableImageView;
import io.intercom.android.sdk.views.UploadProgressBar;
import io.intercom.com.bumptech.glide.DrawableTypeRequest;
import io.intercom.com.bumptech.glide.Glide;
import io.intercom.com.bumptech.glide.load.Transformation;
import io.intercom.com.bumptech.glide.load.resource.drawable.GlideDrawable;
import io.intercom.com.bumptech.glide.request.RequestListener;
import io.intercom.com.bumptech.glide.request.target.Target;
import java.io.File;

public class LocalImage
extends Image
implements LocalImageBlock {
    public LocalImage(Context context, LayoutInflater inflater, StyleType style) {
        super(context, inflater, style);
    }

    public View addImage(String url, int width, int height, BlockAlignment alignment, boolean isFirstObject, boolean isLastObject, ViewGroup parent) {
        ProgressFrameLayout rootView = (ProgressFrameLayout)this.inflater.inflate(R.layout.intercom_blocks_local_image, parent, false);
        final ResizableImageView imageView = (ResizableImageView)rootView.findViewById(R.id.image_block);
        DrawableTypeRequest requestCreator = Glide.with((Context)this.context).load(new File(url));
        this.setImageViewBounds(width, height, imageView, requestCreator);
        View view = rootView.getChildAt(0);
        if (view instanceof UploadProgressBar) {
            UploadProgressBar uploadProgressBar = (UploadProgressBar)view;
            int spinnerSize = this.context.getResources().getDimensionPixelSize(R.dimen.intercomsdk_local_image_upload_size);
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(spinnerSize, spinnerSize, 17);
            uploadProgressBar.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            uploadProgressBar.bringToFront();
        }
        this.setBackground(imageView);
        requestCreator.bitmapTransform(new Transformation[]{new RoundedCornersTransform(this.context, this.context.getResources().getDimensionPixelSize(R.dimen.intercomsdk_image_rounded_corners))}).listener((RequestListener)new RequestListener<File, GlideDrawable>(){

            public boolean onException(Exception e, File model, Target<GlideDrawable> target, boolean isFirstResource) {
                IntercomLogger.internal("images", "FAILURE");
                return false;
            }

            public boolean onResourceReady(GlideDrawable resource, File model, Target<GlideDrawable> target, boolean isFromMemoryCache, boolean isFirstResource) {
                IntercomLogger.internal("images", "SUCCESS");
                imageView.setBackgroundResource(17170445);
                return false;
            }
        }).diskCacheStrategy(ImageUtils.getDiskCacheStrategy(url)).into((ImageView)imageView);
        BlockUtils.setLayoutMarginsAndGravity((View)rootView, alignment.getGravity(), isLastObject);
        return rootView;
    }
}

