/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.activities;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.design.widget.AppBarLayout;
import android.support.v7.app.AppCompatActivity;
import android.text.TextUtils;
import android.util.Property;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ScrollView;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.activities.IamActivity;
import io.intercom.android.sdk.blocks.ViewHolderGenerator;
import io.intercom.android.sdk.commons.utilities.ScreenUtils;
import io.intercom.android.sdk.conversation.ComposerInputView;
import io.intercom.android.sdk.conversation.ReactionInputView;
import io.intercom.android.sdk.metrics.MetricFactory;
import io.intercom.android.sdk.models.LastParticipatingAdmin;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.models.ReactionReply;
import io.intercom.android.sdk.utilities.BlockUtils;
import io.intercom.android.sdk.utilities.SimpleAnimatorListener;
import io.intercom.android.sdk.views.IntercomToolbar;
import io.intercom.com.facebook.rebound.SimpleSpringListener;
import io.intercom.com.facebook.rebound.Spring;
import io.intercom.com.facebook.rebound.SpringConfig;
import io.intercom.com.facebook.rebound.SpringListener;
import io.intercom.com.facebook.rebound.SpringSystem;

public class IntercomPostActivity
extends AppCompatActivity
implements IntercomToolbar.Listener,
View.OnClickListener {
    private static final int SPRING_TENSION = 600;
    private static final int SPRING_FRICTION = 40;
    private static final String PARCEL_PART = "parcel_part";
    private static final String PARCEL_CONVERSATION_ID = "parcel_conversation_id";
    private static final String POST_PREVIEW = "is_post_preview";
    private static final String LAST_PARTICIPANT = "last_participant";
    private Part part;
    private SpringSystem springSystem;
    private IntercomToolbar intercomToolbar;
    private AppBarLayout appBarLayout;
    private FrameLayout postContainer;
    private ScrollView postView;
    private String conversationId;
    private FrameLayout composerLayout;
    private ComposerInputView textComposer;
    private ReactionInputView reactionComposer;
    private LastParticipatingAdmin lastParticipatingAdmin;
    private boolean isPreview = false;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.intercom_activity_post);
        this.springSystem = SpringSystem.create();
        this.appBarLayout = (AppBarLayout)this.findViewById(R.id.app_bar_layout);
        this.intercomToolbar = (IntercomToolbar)this.findViewById(R.id.intercom_toolbar);
        this.intercomToolbar.setListener(this);
        this.intercomToolbar.setBackgroundColor(Injector.get().getIdentityStore().getAppConfig().getBaseColor());
        Bundle data = this.getIntent().getExtras();
        this.part = new Part();
        this.lastParticipatingAdmin = LastParticipatingAdmin.NULL;
        if (data != null) {
            if (data.containsKey(PARCEL_PART)) {
                this.part = (Part)data.getParcelable(PARCEL_PART);
                this.intercomToolbar.setTitle(this.part.getParticipant().getForename());
                this.intercomToolbar.setSubtitle(String.format(this.getResources().getString(R.string.intercom_from_company), Injector.get().getIdentityStore().getAppConfig().getName()));
            }
            if (data.containsKey(PARCEL_CONVERSATION_ID)) {
                this.conversationId = data.getString(PARCEL_CONVERSATION_ID, "");
                Injector.get().getUnreadCountTracker().decrementCount();
                Injector.get().getApi().markConversationAsRead(this.conversationId);
            }
            if (data.containsKey(POST_PREVIEW)) {
                this.isPreview = data.getBoolean(POST_PREVIEW, false);
            }
            if (data.containsKey(LAST_PARTICIPANT)) {
                this.lastParticipatingAdmin = (LastParticipatingAdmin)data.getParcelable(LAST_PARTICIPANT);
            }
        }
        this.intercomToolbar.setVisibility(8);
        this.intercomToolbar.setUpPostToolbar(this.part.getParticipant().getAvatar());
        int primaryColor = Injector.get().getIdentityStore().getAppConfig().getBaseColor();
        View background = this.getWindow().getDecorView();
        background.setBackgroundColor(Color.argb((int)153, (int)Color.red((int)primaryColor), (int)Color.green((int)primaryColor), (int)Color.blue((int)primaryColor)));
        ViewHolderGenerator.createPartUi(new ViewHolderGenerator((Context)this).getPostHolder(), this.part, (Context)this);
        this.postView = (ScrollView)this.findViewById(R.id.post_view);
        this.postView.addView(BlockUtils.getBlockView((ViewGroup)this.postView, this.part.getLayout(), (Context)this));
        this.postContainer = (FrameLayout)this.findViewById(R.id.post_container);
        this.composerLayout = (FrameLayout)this.findViewById(R.id.conversation_coordinator);
        this.textComposer = (ComposerInputView)this.findViewById(R.id.composer_input_view);
        this.reactionComposer = (ReactionInputView)this.findViewById(R.id.reaction_input_view);
        ObjectAnimator animator2 = ObjectAnimator.ofFloat((Object)this.getWindow().getDecorView(), (Property)View.ALPHA, (float[])new float[]{0.0f, 1.0f}).setDuration(200L);
        animator2.addListener((Animator.AnimatorListener)new SimpleAnimatorListener(){

            @Override
            public void onAnimationEnd(Animator animation) {
                IntercomPostActivity.this.animateToolbar();
                IntercomPostActivity.this.animateContent();
                if (IntercomPostActivity.this.isPreview) {
                    if (ReactionReply.isNull(IntercomPostActivity.this.part.getReactionReply())) {
                        View touchTarget = IntercomPostActivity.this.findViewById(R.id.post_touch_target);
                        touchTarget.setOnClickListener((View.OnClickListener)IntercomPostActivity.this);
                        IntercomPostActivity.this.animateComposer();
                    } else {
                        IntercomPostActivity.this.composerLayout.setVisibility(0);
                        IntercomPostActivity.this.reactionComposer.setUpReactions(IntercomPostActivity.this.part.getReactionReply(), IntercomPostActivity.this.conversationId, true);
                    }
                } else {
                    IntercomPostActivity.this.composerLayout.setVisibility(8);
                }
            }
        });
        animator2.start();
    }

    private void animateToolbar() {
        Spring spring = this.createSpring();
        spring.setCurrentValue((double)ScreenUtils.convertDpToPixel((float)200.0f, (Context)this));
        spring.setEndValue(0.0);
        spring.addListener((SpringListener)new SimpleSpringListener(){

            public void onSpringActivate(Spring spring) {
                IntercomPostActivity.this.intercomToolbar.setVisibility(0);
            }

            public void onSpringUpdate(Spring spring) {
                float value = (float)spring.getCurrentValue();
                IntercomPostActivity.this.appBarLayout.setY(value);
            }
        });
    }

    private void animateContent() {
        Spring spring = this.createSpring();
        spring.setCurrentValue((double)ScreenUtils.convertDpToPixel((float)400.0f, (Context)this));
        spring.setEndValue((double)this.getResources().getDimensionPixelSize(R.dimen.intercom_toolbar_height));
        spring.addListener((SpringListener)new SimpleSpringListener(){

            public void onSpringActivate(Spring spring) {
                IntercomPostActivity.this.postContainer.setVisibility(0);
            }

            public void onSpringUpdate(Spring spring) {
                float value = (float)spring.getCurrentValue();
                IntercomPostActivity.this.postContainer.setY(value);
            }
        });
    }

    private void animateComposer() {
        int height = this.getWindow().findViewById(0x1020002).getHeight();
        Spring spring = this.createSpring();
        spring.setCurrentValue((double)(height + ScreenUtils.convertDpToPixel((float)100.0f, (Context)this)));
        spring.setEndValue((double)(height - this.getResources().getDimensionPixelSize(R.dimen.intercom_composer_height)));
        spring.addListener((SpringListener)new SimpleSpringListener(){

            public void onSpringActivate(Spring spring) {
                IntercomPostActivity.this.composerLayout.setVisibility(0);
                IntercomPostActivity.this.textComposer.setVisibility(0);
            }

            public void onSpringUpdate(Spring spring) {
                float value = (float)spring.getCurrentValue();
                IntercomPostActivity.this.composerLayout.setY(value);
            }
        });
    }

    private Spring createSpring() {
        Spring spring = this.springSystem.createSpring();
        SpringConfig springConfig = new SpringConfig(600.0, 40.0);
        spring.setSpringConfig(springConfig);
        return spring;
    }

    private void closePost() {
        ObjectAnimator animator2 = ObjectAnimator.ofFloat((Object)this.getWindow().getDecorView(), (Property)View.ALPHA, (float[])new float[]{1.0f, 0.0f}).setDuration(200L);
        animator2.addListener((Animator.AnimatorListener)new SimpleAnimatorListener(){

            @Override
            public void onAnimationEnd(Animator animation) {
                IntercomPostActivity.this.finish();
                IntercomPostActivity.this.overridePendingTransition(0, 0);
            }
        });
        animator2.start();
    }

    public static Intent buildPostIntent(@NonNull Context context, @NonNull Part part, @NonNull String conversationId, @NonNull LastParticipatingAdmin lastParticipatingAdmin, boolean isPreview) {
        Intent intent = new Intent(context, IntercomPostActivity.class);
        intent.putExtra(PARCEL_PART, (Parcelable)part);
        if (!TextUtils.isEmpty((CharSequence)conversationId)) {
            intent.putExtra(PARCEL_CONVERSATION_ID, conversationId);
        }
        intent.putExtra(LAST_PARTICIPANT, (Parcelable)lastParticipatingAdmin);
        intent.putExtra(POST_PREVIEW, isPreview);
        intent.setFlags(0x10000000);
        return intent;
    }

    public void onBackPressed() {
        this.closePost();
        if (this.isPreview) {
            Injector.get().getMetricsStore().track(MetricFactory.dismissedFullInApp(this.conversationId, this.part.getMessageStyle()));
        }
    }

    @Override
    public void onCloseClicked() {
        this.onBackPressed();
    }

    @Override
    public void onInboxClicked() {
    }

    public void onClick(View v) {
        if (v.getId() == R.id.post_touch_target) {
            this.closePost();
            if (this.isPreview) {
                Intent conversationIntent = IamActivity.openConversationFull((Context)this, this.conversationId, this.lastParticipatingAdmin);
                this.startActivity(conversationIntent);
                Injector.get().getMetricsStore().track(MetricFactory.tappedOnFullInApp(this.conversationId, this.part.getMessageStyle()));
            }
        }
    }
}

