/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk;

import android.annotation.TargetApi;
import android.app.Application;
import android.app.TaskStackBuilder;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import io.intercom.android.sdk.Gcm;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.Intercom;
import io.intercom.android.sdk.NexusWrapper;
import io.intercom.android.sdk.UnreadConversationCountListener;
import io.intercom.android.sdk.UnreadCountTracker;
import io.intercom.android.sdk.activities.IamActivity;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.api.DeDuper;
import io.intercom.android.sdk.api.RateLimiter;
import io.intercom.android.sdk.commons.utilities.DeviceUtils;
import io.intercom.android.sdk.identity.IdentityStore;
import io.intercom.android.sdk.identity.Migrations;
import io.intercom.android.sdk.identity.Registration;
import io.intercom.android.sdk.logger.IntercomLogger;
import io.intercom.android.sdk.metrics.MetricFactory;
import io.intercom.android.sdk.metrics.MetricsStore;
import io.intercom.android.sdk.models.LastParticipatingAdmin;
import io.intercom.android.sdk.models.events.CloseIAMEvent;
import io.intercom.android.sdk.preview.PreviewManager;
import io.intercom.android.sdk.user.DeviceData;
import io.intercom.android.sdk.utilities.AttributeSanitiser;
import io.intercom.android.sdk.utilities.IntentUtils;
import io.intercom.android.sdk.utilities.IntercomUtils;
import io.intercom.android.sdk.utilities.ValidatorUtil;
import io.intercom.com.squareup.otto.Bus;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@TargetApi(value=14)
public class RealIntercom
extends Intercom {
    private static final String GCM_RECEIVE = "com.google.android.c2dm.permission.RECEIVE";
    private final DeDuper superDeDuper;
    private final RateLimiter rateLimiter;
    private final IdentityStore identityStore;
    private final Api api;
    private final NexusWrapper nexusClient;
    private final UnreadCountTracker unreadCountTracker;
    private final MetricsStore metricsStore;
    private final Context context;
    private final PreviewManager previewManager;
    private final Bus bus;
    private boolean initialised = false;

    protected RealIntercom(Application application, String apiKey, String appId) {
        if (!ValidatorUtil.isValidConstructorParams(application, apiKey, appId)) {
            this.superDeDuper = null;
            this.rateLimiter = null;
            this.identityStore = null;
            this.api = null;
            this.nexusClient = null;
            this.unreadCountTracker = null;
            this.metricsStore = null;
            this.context = null;
            this.previewManager = null;
            this.bus = null;
            return;
        }
        IntercomUtils.changeComponentState(1, application.getApplicationContext());
        Injector.initWithAppCredentials(application, apiKey, appId);
        Migrations.runAll(application.getApplicationContext());
        Injector injector = Injector.get();
        this.identityStore = injector.getIdentityStore();
        this.api = injector.getApi();
        this.nexusClient = injector.getNexusClient();
        this.unreadCountTracker = injector.getUnreadCountTracker();
        this.metricsStore = injector.getMetricsStore();
        this.superDeDuper = injector.getDeDuper();
        this.context = injector.getContext();
        this.previewManager = injector.getPreviewManager();
        this.bus = injector.getBus();
        this.rateLimiter = new RateLimiter(this.identityStore.getAppConfig());
        this.initialised = true;
    }

    @Override
    public void registerUnidentifiedUser() {
        if (!this.isInitialised()) {
            this.logIntercomNotInitialised();
            return;
        }
        if (this.identityStore.registerUnidentifiedUser()) {
            this.api.registerUnidentifiedUser();
        } else {
            IntercomLogger.i("Failed to register user. We already have a registered user. If you are attempting to register a new user, call reset before this. If you are attempting to register an identified user call: registerIdentifiedUser(Registration)");
        }
    }

    @Override
    public void registerIdentifiedUser(Registration userRegistration) {
        if (!this.isInitialised()) {
            this.logIntercomNotInitialised();
            return;
        }
        if (userRegistration != null) {
            if (this.identityStore.registerIdentifiedUser(userRegistration)) {
                this.api.registerIdentifiedUser(userRegistration);
            } else {
                IntercomLogger.i("Failed to register user. We already have a registered user. If you are attempting to register a new user, call reset before this. If you are attempting to change the user call update instead.");
            }
        } else {
            IntercomLogger.e("The registration object you passed to is null. An example successful call is registerIdentifiedUser(new Registration().withEmail(email));");
        }
    }

    @Override
    public void setSecureMode(String secureHash, String secureData) {
        if (this.initialised) {
            if (TextUtils.isEmpty((CharSequence)secureHash)) {
                IntercomLogger.w("The hmac you sent us for secure mode was either null or empty, we will not be able to authenticate your requests without a valid hmac.");
            } else if (TextUtils.isEmpty((CharSequence)secureData)) {
                IntercomLogger.w("The data you sent us for secure mode was either null or empty, we will not be able to authenticate your requests without valid data.");
            } else {
                this.identityStore.setSecureMode(secureHash, secureData);
            }
        }
    }

    @Override
    public void updateUser(Map<String, ?> attributes) {
        if (!this.isInitialised()) {
            this.logIntercomNotInitialised();
            return;
        }
        if (attributes == null) {
            IntercomLogger.e("updateUser method failed: the attributes Map provided is null");
        } else if (attributes.isEmpty()) {
            IntercomLogger.e("updateUser method failed: the attributes Map provided is empty");
        } else if (attributes.getClass().isAnonymousClass()) {
            IntercomLogger.e("updateUser method failed: the attributes Map provided is an anonymous subclass");
        } else if (this.rateLimiter.isLimited()) {
            IntercomLogger.e("Your app is being rate limited because you're performing too many requests per minute");
        } else {
            this.rateLimiter.increment();
            if (this.identityStore.isAnonymousUser()) {
                AttributeSanitiser.anonymousSanitisation(attributes);
            }
            if (this.superDeDuper.shouldUpdateUser(attributes)) {
                this.superDeDuper.setAttributes(attributes);
                this.api.updateUser(attributes);
                IntercomLogger.internal("dupe", "updated user");
            } else {
                IntercomLogger.internal("dupe", "dropped dupe");
            }
        }
    }

    @Override
    public void logEvent(String name) {
        this.logEventWithValidation(name, new HashMap());
    }

    @Override
    public void logEvent(String name, Map<String, ?> metadata) {
        if (metadata == null) {
            IntercomLogger.i("The metadata provided is null, logging event with no metadata");
            metadata = new HashMap();
        } else if (!metadata.isEmpty()) {
            IntercomLogger.i("The metadata provided is empty, logging event with no metadata");
        }
        this.logEventWithValidation(name, metadata);
    }

    private void logEventWithValidation(String name, Map<String, ?> metadata) {
        if (!this.isInitialised()) {
            this.logIntercomNotInitialised();
            return;
        }
        if (TextUtils.isEmpty((CharSequence)name)) {
            IntercomLogger.e("The event name is null or empty. We can't log an event with this string.");
        } else if (this.rateLimiter.isLimited()) {
            IntercomLogger.e("Your app is being rate limited because you're performing too many requests per minute");
        } else {
            this.rateLimiter.increment();
            this.api.logEvent(name, metadata);
        }
    }

    @Override
    public void displayMessageComposer() {
        if (!this.isInitialised()) {
            this.logIntercomNotInitialised();
            return;
        }
        this.metricsStore.track(MetricFactory.tappedOnLauncher("custom"));
        if (this.identityStore.getAppConfig().isInboundMessages()) {
            this.context.startActivity(IamActivity.openComposer(this.context));
        } else {
            IntercomLogger.e("It appears your app is not on a plan that allows message composing As a fallback we are calling displayConversationsList()");
            this.displayConversationsList();
        }
    }

    @Override
    public void displayConversationsList() {
        if (!this.isInitialised()) {
            this.logIntercomNotInitialised();
            return;
        }
        this.metricsStore.track(MetricFactory.tappedOnLauncher("custom"));
        this.context.startActivity(IamActivity.openInbox(this.context));
    }

    @Override
    public void setInAppMessageVisibility(Intercom.Visibility visibility) {
        if (!this.isInitialised()) {
            this.logIntercomNotInitialised();
            return;
        }
        this.previewManager.setPreviewVisibility(visibility);
    }

    @Override
    public void setLauncherVisibility(Intercom.Visibility visibility) {
        if (!this.isInitialised()) {
            this.logIntercomNotInitialised();
            return;
        }
        this.previewManager.setLauncherVisibility(visibility);
    }

    @Override
    public void hideMessenger() {
        if (!this.isInitialised()) {
            this.logIntercomNotInitialised();
            return;
        }
        this.bus.post((Object)new CloseIAMEvent());
    }

    @Override
    public void setupGCM(String regId, int appLogo) {
        if (!this.isInitialised()) {
            this.logIntercomNotInitialised();
            return;
        }
        if (this.hasPermission(GCM_RECEIVE) && this.hasPermission("android.permission.WAKE_LOCK") && this.hasPermission("android.permission.VIBRATE")) {
            if (Gcm.gcmModuleInstalled()) {
                if (Gcm.isGcmEnabled(this.context)) {
                    if (TextUtils.isEmpty((CharSequence)regId)) {
                        IntercomLogger.e("The GCM registrationId  passed in is null or empty, we require a valid GCM registrationId to enable push");
                    } else {
                        SharedPreferences settings = this.context.getSharedPreferences("INTERCOM_SDK_PREFS", 0);
                        SharedPreferences.Editor editor = settings.edit();
                        editor.putInt("INTERCOM_SDK_PUSH_LOGO", appLogo);
                        editor.apply();
                        if (!DeviceData.hasCachedPushToken(this.context, regId)) {
                            this.api.setGcmPushKey(regId);
                            DeviceData.cachePushToken(this.context, regId);
                        }
                    }
                } else {
                    IntercomLogger.e("GCM components are disabled on gingerbread devices");
                }
            } else {
                IntercomLogger.e("intercom-sdk-gcm module not found. Please add it to your build.gradle");
            }
        } else {
            IntercomLogger.e("To enable GCM notifications the following permissions are required. <uses-permission android:name=\"android.permission.WAKE_LOCK\" />\n<uses-permission android:name=\"com.google.android.c2dm.permission.RECEIVE\" />\n<uses-permission android:name=\"android.permission.VIBRATE\"/>\nIn addition to the required permissions the following optional permissions improve push reliability<uses-permission android:name=\"android.permission.READ_PHONE_STATE\"/>\n<uses-permission android:name=\"android.permission.ACCESS_WIFI_STATE\"/>");
        }
    }

    boolean hasPermission(String permission2) {
        return DeviceUtils.hasPermission((Context)this.context, (String)permission2);
    }

    @Override
    public void openGCMMessage(Intent intent) {
        this.openGCMMessage(intent, null);
    }

    @Override
    public void openGCMMessage(Intent intent, TaskStackBuilder customStack) {
        boolean launchedFromHistory;
        boolean bl = launchedFromHistory = intent != null && (intent.getFlags() & 0x100000) != 0;
        if (!launchedFromHistory) {
            if (!this.isInitialised()) {
                this.logIntercomNotInitialised();
                return;
            }
            if (intent != null && intent.getData() != null) {
                String pushOnlyId = intent.getStringExtra("push_only_convo_id");
                if (!TextUtils.isEmpty((CharSequence)pushOnlyId)) {
                    this.api.markConversationAsRead(pushOnlyId);
                }
                if (!intent.getDataString().isEmpty() && !TextUtils.isEmpty((CharSequence)pushOnlyId)) {
                    this.openPushOnlyMessage(pushOnlyId, intent, this.context);
                } else {
                    this.openIntercomChatPush(pushOnlyId, intent, customStack);
                }
            } else {
                IntercomLogger.i("The Uri passed into the method openGCMMessage was null.");
            }
        }
    }

    @Deprecated
    public boolean openGCMMessage(Uri data) {
        boolean wasSdkPush = false;
        if (!this.isInitialised()) {
            this.logIntercomNotInitialised();
            return false;
        }
        if (data != null) {
            List pathParts = data.getPathSegments();
            if (pathParts.size() > 1 && ((String)pathParts.get(0)).equals("intercom_sdk")) {
                wasSdkPush = true;
                String firstPart = (String)pathParts.get(1);
                if (firstPart.equals("multiple_notifications")) {
                    this.context.startActivity(IamActivity.openInbox(this.context));
                } else {
                    Intent intent = IamActivity.openConversationFull(this.context, firstPart.substring(firstPart.lastIndexOf(61) + 1), LastParticipatingAdmin.NULL);
                    this.context.startActivity(intent);
                }
                Gcm.clearNotifications(this.context);
            } else {
                IntercomLogger.i("The Uri passed into the method openGCMMessage was not an Intercom GCM message");
            }
        } else {
            IntercomLogger.i("The Uri passed into the method openGCMMessage was null.");
        }
        return wasSdkPush;
    }

    private void openPushOnlyMessage(String conversationId, Intent intent, Context context) {
        Intent notificationIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)intent.getDataString()));
        notificationIntent.addFlags(0x10000000);
        if (notificationIntent.resolveActivity(context.getPackageManager()) != null) {
            IntentUtils.safelyOpenIntent(context, intent);
        } else {
            IntercomLogger.i("This device has no application that can handlethe Uri passed in");
        }
        this.metricsStore.track(MetricFactory.openedPushMessage(conversationId, "push_only"));
    }

    private void openIntercomChatPush(String conversationId, Intent intent, TaskStackBuilder customStack) {
        List pathParts = intent.getData().getPathSegments();
        if (pathParts.size() > 1 && ((String)pathParts.get(0)).equals("intercom_sdk")) {
            String firstPart = (String)pathParts.get(1);
            Intent messengerIntent = firstPart.equals("multiple_notifications") ? IamActivity.openInbox(this.context) : IamActivity.openConversationFull(this.context, firstPart.substring(firstPart.lastIndexOf(61) + 1), LastParticipatingAdmin.NULL);
            if (customStack != null && Build.VERSION.SDK_INT >= 16) {
                customStack.addNextIntent(messengerIntent);
                this.context.startActivities(customStack.getIntents());
            } else {
                this.context.startActivity(messengerIntent);
            }
            Gcm.clearNotifications(this.context);
        } else {
            IntercomLogger.i("The Uri passed into the method openGCMMessage was not an Intercom GCM message");
        }
        this.metricsStore.track(MetricFactory.openedPushMessage(conversationId, "in_app"));
    }

    @Override
    public void reset() {
        if (!this.isInitialised()) {
            this.logIntercomNotInitialised();
            return;
        }
        this.api.removeGcmDeviceToken(DeviceData.getPushToken(this.context));
        this.identityStore.getAppConfig().resetRealTimeConfig();
        this.nexusClient.disconnect();
        this.identityStore.resetUserIdentity();
        this.bus.post((Object)new CloseIAMEvent());
        this.previewManager.reset();
        IntercomLogger.i("Successfully reset user. To resume communicating with Intercom, you can register a user");
    }

    @Override
    public int getUnreadConversationCount() {
        return this.unreadCountTracker.getCount();
    }

    @Override
    public void addUnreadConversationCountListener(@NonNull UnreadConversationCountListener listener) {
        if (listener != null) {
            this.unreadCountTracker.addListener(listener);
        }
    }

    @Override
    public void removeUnreadConversationCountListener(UnreadConversationCountListener listener) {
        this.unreadCountTracker.removeListener(listener);
    }

    private boolean isInitialised() {
        return this.initialised;
    }

    private void logIntercomNotInitialised() {
        IntercomLogger.e("It appears Intercom has not been initialized correctly. Please make sure the first Intercom method you call is initialize and that you're passing in the correct app id and api-key");
    }
}

