/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.nexus;

import android.os.Handler;
import android.os.HandlerThread;
import android.support.annotation.NonNull;
import io.intercom.android.sdk.nexus.NexusConfig;
import io.intercom.android.sdk.nexus.NexusEvent;
import io.intercom.android.sdk.nexus.NexusEventPropagator;
import io.intercom.android.sdk.nexus.NexusListener;
import io.intercom.android.sdk.nexus.NexusLogger;
import io.intercom.android.sdk.nexus.NexusSocket;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class NexusClient {
    private final List<NexusSocket> sockets = new ArrayList<NexusSocket>();
    private final NexusEventPropagator eventPropagator;
    private long presenceInterval;
    private Handler backgroundHandler;

    public NexusClient() {
        this(new NexusEventPropagator());
    }

    NexusClient(NexusEventPropagator eventPropagator) {
        this.eventPropagator = eventPropagator;
        HandlerThread bgThread = new HandlerThread("background-handler");
        bgThread.start();
        this.backgroundHandler = new Handler(bgThread.getLooper());
    }

    public void connect(NexusConfig config, boolean shouldSendPresence) {
        if (config.getEndpoints().isEmpty()) {
            NexusLogger.errorLog("No endpoints present");
        }
        for (String url : config.getEndpoints()) {
            NexusLogger.d("adding socket");
            this.sockets.add(new NexusSocket(url, config.getConnectionTimeout(), shouldSendPresence, this.eventPropagator));
        }
        this.presenceInterval = TimeUnit.SECONDS.toMillis(config.getPresenceHeartbeatInterval());
        if (shouldSendPresence) {
            this.schedulePresence();
        }
    }

    public synchronized void disconnect() {
        if (!this.sockets.isEmpty()) {
            for (NexusSocket nexusSocket : this.sockets) {
                NexusLogger.d("disconnecting socket");
                nexusSocket.disconnect();
            }
            this.sockets.clear();
            NexusLogger.d("client disconnected");
        }
        this.backgroundHandler.removeCallbacksAndMessages(null);
    }

    public synchronized void fire(NexusEvent event) {
        this.eventPropagator.cacheEvent(event);
        String data = event.toStringEncodedJsonObject();
        if (!data.isEmpty()) {
            for (NexusSocket nexusSocket : this.sockets) {
                nexusSocket.fire(data);
            }
        }
    }

    public synchronized void localUpdate(@NonNull NexusEvent event) {
        this.eventPropagator.notifyEvent(event);
    }

    public synchronized boolean isConnected() {
        for (NexusSocket socket : this.sockets) {
            if (!socket.isConnected()) continue;
            return true;
        }
        return false;
    }

    public void addEventListener(@NonNull NexusListener listener) {
        this.eventPropagator.addListener(listener);
    }

    public void removeEventListener(@NonNull NexusListener listener) {
        this.eventPropagator.removeListener(listener);
    }

    public void setLoggingEnabled(boolean loggingEnabled) {
        NexusLogger.setLoggingEnabled(loggingEnabled);
    }

    public void setPresenceHeartbeatEnabled(boolean presenceHeartbeatEnabled) {
        this.backgroundHandler.removeCallbacksAndMessages(null);
        if (presenceHeartbeatEnabled) {
            this.schedulePresence();
        }
    }

    private void schedulePresence() {
        if (this.presenceInterval > 0L) {
            this.backgroundHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    NexusClient.this.fire(NexusEvent.getUserPresenceEvent());
                    NexusClient.this.schedulePresence();
                }
            }, this.presenceInterval);
        }
    }
}

