/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.transforms;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Shader;
import io.intercom.com.bumptech.glide.Glide;
import io.intercom.com.bumptech.glide.load.Transformation;
import io.intercom.com.bumptech.glide.load.engine.Resource;
import io.intercom.com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import io.intercom.com.bumptech.glide.load.resource.bitmap.BitmapResource;

public class RoundTransform
implements Transformation<Bitmap> {
    private BitmapPool bitmapPool;

    public RoundTransform(Context context) {
        this.bitmapPool = Glide.get((Context)context).getBitmapPool();
    }

    public Resource<Bitmap> transform(Resource<Bitmap> resource, int outWidth, int outHeight) {
        Bitmap source = (Bitmap)resource.get();
        int size = Math.min(source.getWidth(), source.getHeight());
        int width = (source.getWidth() - size) / 2;
        int height = (source.getHeight() - size) / 2;
        Bitmap bitmap = this.bitmapPool.get(size, size, Bitmap.Config.ARGB_8888);
        if (bitmap == null) {
            bitmap = Bitmap.createBitmap((int)size, (int)size, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        Canvas canvas = new Canvas(bitmap);
        Paint paint = new Paint();
        BitmapShader shader = new BitmapShader(source, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
        if (width != 0 || height != 0) {
            Matrix matrix = new Matrix();
            matrix.setTranslate((float)(-width), (float)(-height));
            shader.setLocalMatrix(matrix);
        }
        paint.setShader((Shader)shader);
        paint.setAntiAlias(true);
        float r = (float)size / 2.0f;
        canvas.drawCircle(r, r, r, paint);
        return BitmapResource.obtain((Bitmap)bitmap, (BitmapPool)this.bitmapPool);
    }

    public String getId() {
        return "roundAvatarTransformation";
    }
}

