/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.preview;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.content.Intent;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.util.Property;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.activities.IamActivity;
import io.intercom.android.sdk.metrics.MetricFactory;
import io.intercom.android.sdk.utilities.BackgroundUtils;
import io.intercom.android.sdk.utilities.SimpleAnimatorListener;

public class DefaultLauncher
implements View.OnTouchListener {
    private final TextView badgeCount;
    private final View launcherRoot;

    public DefaultLauncher(Context context, ViewGroup root, LayoutInflater inflater) {
        inflater.inflate(R.layout.intercom_default_launcher, root, true);
        this.launcherRoot = root.findViewById(R.id.launcher_root);
        View badge = this.launcherRoot.findViewById(R.id.launcher_icon);
        this.badgeCount = (TextView)this.launcherRoot.findViewById(R.id.launcher_badge_count);
        Drawable iconBg = ContextCompat.getDrawable((Context)context, (int)R.drawable.intercom_solid_circle);
        iconBg.setColorFilter(Injector.get().getIdentityStore().getAppConfig().getBaseColor(), PorterDuff.Mode.SRC_IN);
        Drawable countBg = iconBg.getConstantState().newDrawable();
        countBg.setColorFilter(ContextCompat.getColor((Context)context, (int)R.color.intercom_inbox_count_background), PorterDuff.Mode.SRC_IN);
        BackgroundUtils.setBackground((View)this.badgeCount, countBg);
        BackgroundUtils.setBackground(badge, iconBg);
        this.launcherRoot.setOnTouchListener((View.OnTouchListener)this);
    }

    public void setBadgeCount(String unreadCount) {
        this.badgeCount.setVisibility(0);
        this.badgeCount.setText((CharSequence)unreadCount);
    }

    public void hideBadeCount() {
        this.badgeCount.setVisibility(8);
    }

    public void fadeOnScreen() {
        this.launcherRoot.setAlpha(0.0f);
        this.launcherRoot.animate().alpha(1.0f).setDuration(100L).start();
    }

    public void fadeOffScreen() {
        this.fadeOffScreen(null);
    }

    public void fadeOffScreen(@Nullable Animator.AnimatorListener listener) {
        this.launcherRoot.animate().alpha(0.0f).setDuration(100L).setListener(listener).start();
    }

    public void pulseForTransformation(final Animator.AnimatorListener listener) {
        this.launcherRoot.animate().scaleX(1.1f).scaleY(1.1f).setDuration(100L).setListener((Animator.AnimatorListener)new SimpleAnimatorListener(){

            @Override
            public void onAnimationEnd(Animator animation) {
                listener.onAnimationEnd(animation);
                DefaultLauncher.this.launcherRoot.animate().scaleX(1.0f).scaleY(1.0f).setDuration(100L).start();
            }
        }).start();
    }

    public void removeView() {
        if (this.launcherRoot.getParent() != null) {
            ((ViewGroup)this.launcherRoot.getParent()).removeView(this.launcherRoot);
        }
    }

    public boolean onTouch(View v, MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                v.setScaleX(0.9f);
                v.setScaleY(0.9f);
                break;
            }
            case 1: {
                Injector.get().getMetricsStore().track(MetricFactory.tappedOnLauncher("default"));
                this.openMessenger(v.getContext());
            }
        }
        return true;
    }

    private void openMessenger(final Context context) {
        ObjectAnimator fadeOut = ObjectAnimator.ofFloat((Object)this.launcherRoot, (Property)View.ALPHA, (float[])new float[]{1.0f, 0.0f}).setDuration(50L);
        fadeOut.addListener((Animator.AnimatorListener)new SimpleAnimatorListener(){

            @Override
            public void onAnimationEnd(Animator animation) {
                Intent intent = IamActivity.openInbox(context);
                context.startActivity(intent);
            }
        });
        fadeOut.start();
    }
}

