/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.models;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import io.intercom.android.sdk.models.LastParticipatingAdmin;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.models.Participant;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class Conversation
implements Parcelable {
    @NonNull
    private final Map<String, Participant> participants;
    @NonNull
    private final List<Part> conversationParts;
    @NonNull
    private final LastParticipatingAdmin lastParticipatingAdmin;
    @NonNull
    private final String id;
    private boolean read;
    private boolean userParticipated;
    public static final Parcelable.Creator<Conversation> CREATOR = new Parcelable.Creator<Conversation>(){

        public Conversation createFromParcel(Parcel in) {
            return new Conversation(in);
        }

        public Conversation[] newArray(int size) {
            return new Conversation[size];
        }
    };

    public Conversation() {
        this(new Builder());
    }

    private Conversation(Builder builder) {
        this.id = builder.id == null ? "" : builder.id;
        this.read = builder.read;
        this.userParticipated = builder.user_participated;
        this.participants = new LinkedHashMap<String, Participant>();
        if (builder.participants != null) {
            for (Participant.Builder participantBuilder : builder.participants) {
                Participant participant = participantBuilder.build();
                this.participants.put(participant.getId(), participant);
            }
        }
        this.conversationParts = new ArrayList<Part>();
        if (builder.conversation_parts != null) {
            for (Part.Builder partBuilder : builder.conversation_parts) {
                Part part = partBuilder.build();
                part.setParticipant(this.getParticipant(part.getParticipantId()));
                this.conversationParts.add(part);
            }
        }
        this.lastParticipatingAdmin = builder.last_participating_admin != null ? builder.last_participating_admin.build() : new LastParticipatingAdmin.NullLastParticipant();
        this.lastParticipatingAdmin.setAvatar(this.getLastAdmin().getAvatar());
    }

    public List<Part> getParts() {
        return this.conversationParts;
    }

    public Part getLastPart() {
        return this.conversationParts.isEmpty() ? new Part.NullPart() : this.conversationParts.get(this.conversationParts.size() - 1);
    }

    public Part getLastAdminPart() {
        for (int i = this.conversationParts.size() - 1; i >= 0; --i) {
            Part part = this.conversationParts.get(i);
            if (!part.isAdmin()) continue;
            return part;
        }
        return new Part.NullPart();
    }

    public Participant getParticipant(String id2) {
        Participant participant = this.participants.get(id2);
        if (participant == null) {
            participant = Participant.NULL;
        }
        return participant;
    }

    public String getId() {
        return this.id;
    }

    public Boolean getRead() {
        return this.read;
    }

    public void setRead(Boolean read) {
        this.read = read;
    }

    public boolean isUserParticipated() {
        return this.userParticipated;
    }

    public Participant getLastAdmin() {
        ListIterator<Participant> iterator = new ArrayList<Participant>(this.participants.values()).listIterator(this.participants.values().size());
        while (iterator.hasPrevious()) {
            Participant participant = iterator.previous();
            if (!participant.isAdmin()) continue;
            return participant;
        }
        return Participant.NULL;
    }

    @NonNull
    public Map<String, Participant> getParticipants() {
        return this.participants;
    }

    @NonNull
    public LastParticipatingAdmin getLastParticipatingAdmin() {
        return this.lastParticipatingAdmin;
    }

    public boolean isAdminReply() {
        return this.participants.size() > 1;
    }

    protected Conversation(Parcel in) {
        this.id = in.readString();
        this.read = in.readByte() != 0;
        this.userParticipated = in.readByte() != 0;
        this.conversationParts = new ArrayList<Part>();
        if (in.readByte() == 1) {
            in.readList(this.conversationParts, Part.class.getClassLoader());
        }
        this.participants = new LinkedHashMap<String, Participant>();
        if (in.readByte() == 1) {
            in.readHashMap(Participant.class.getClassLoader());
        }
        this.lastParticipatingAdmin = (LastParticipatingAdmin)in.readParcelable(LastParticipatingAdmin.class.getClassLoader());
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.id);
        dest.writeByte((byte)(this.read ? 1 : 0));
        dest.writeByte((byte)(this.userParticipated ? 1 : 0));
        dest.writeByte((byte)1);
        dest.writeList(this.conversationParts);
        dest.writeByte((byte)1);
        dest.writeMap(this.participants);
        dest.writeParcelable((Parcelable)this.lastParticipatingAdmin, 0);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Conversation that = (Conversation)o;
        if (this.read != that.read) {
            return false;
        }
        if (this.userParticipated != that.userParticipated) {
            return false;
        }
        if (!this.conversationParts.equals(that.conversationParts)) {
            return false;
        }
        return this.id.equals(that.id);
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + (this.read ? 1 : 0);
        result = 31 * result + (this.userParticipated ? 1 : 0);
        result = 31 * result + this.conversationParts.hashCode();
        return result;
    }

    public static final class Loading
    extends Conversation {
        public Loading() {
            super(new Builder());
        }
    }

    public static final class Builder {
        private String id;
        private boolean read;
        private List<Participant.Builder> participants;
        private List<Part.Builder> conversation_parts;
        private LastParticipatingAdmin.Builder last_participating_admin;
        private boolean user_participated;

        public Builder withId(String id2) {
            this.id = id2;
            return this;
        }

        public Builder withRead(boolean read) {
            this.read = read;
            return this;
        }

        public Builder withParticipants(List<Participant.Builder> participants) {
            this.participants = participants;
            return this;
        }

        public Builder withParts(List<Part.Builder> parts) {
            this.conversation_parts = parts;
            return this;
        }

        public Conversation build() {
            return new Conversation(this);
        }
    }
}

