/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.metrics;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import java.io.ByteArrayInputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;

public class AppTypeDetector {
    private static final X500Principal DEBUG_DN = new X500Principal("CN=Android Debug,O=Android,C=US");

    public static boolean isDebugBuild(Context context) {
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 64);
            Signature[] signatures = packageInfo.signatures;
            if (signatures != null && signatures.length > 0) {
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                for (Signature signature : signatures) {
                    byte[] buf = signature.toByteArray();
                    ByteArrayInputStream stream = new ByteArrayInputStream(buf);
                    X509Certificate cert = (X509Certificate)certificateFactory.generateCertificate(stream);
                    if (!cert.getSubjectX500Principal().equals(DEBUG_DN)) continue;
                    return true;
                }
            }
        }
        catch (PackageManager.NameNotFoundException | CertificateException throwable) {
            // empty catch block
        }
        return false;
    }

    @Nullable
    public static String getInstallerPackageName(Context context) {
        String result = null;
        try {
            result = context.getPackageManager().getInstallerPackageName(context.getPackageName());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (TextUtils.isEmpty(result)) {
            result = "unknown";
        }
        return result;
    }
}

